/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1GroupVersionForDiscovery;
import io.kubernetes.client.openapi.models.V1ServerAddressByClientCIDR;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1APIGroup {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PREFERRED_VERSION = "preferredVersion";
    @SerializedName(value="preferredVersion")
    private V1GroupVersionForDiscovery preferredVersion;
    public static final String SERIALIZED_NAME_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS = "serverAddressByClientCIDRs";
    @SerializedName(value="serverAddressByClientCIDRs")
    private List<V1ServerAddressByClientCIDR> serverAddressByClientCIDRs;
    public static final String SERIALIZED_NAME_VERSIONS = "versions";
    @SerializedName(value="versions")
    private List<V1GroupVersionForDiscovery> versions = new ArrayList<V1GroupVersionForDiscovery>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1APIGroup apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1APIGroup kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1APIGroup name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1APIGroup preferredVersion(V1GroupVersionForDiscovery preferredVersion) {
        this.preferredVersion = preferredVersion;
        return this;
    }

    @Nullable
    public V1GroupVersionForDiscovery getPreferredVersion() {
        return this.preferredVersion;
    }

    public void setPreferredVersion(V1GroupVersionForDiscovery preferredVersion) {
        this.preferredVersion = preferredVersion;
    }

    public V1APIGroup serverAddressByClientCIDRs(List<V1ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
        this.serverAddressByClientCIDRs = serverAddressByClientCIDRs;
        return this;
    }

    public V1APIGroup addServerAddressByClientCIDRsItem(V1ServerAddressByClientCIDR serverAddressByClientCIDRsItem) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList<V1ServerAddressByClientCIDR>();
        }
        this.serverAddressByClientCIDRs.add(serverAddressByClientCIDRsItem);
        return this;
    }

    @Nullable
    public List<V1ServerAddressByClientCIDR> getServerAddressByClientCIDRs() {
        return this.serverAddressByClientCIDRs;
    }

    public void setServerAddressByClientCIDRs(List<V1ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
        this.serverAddressByClientCIDRs = serverAddressByClientCIDRs;
    }

    public V1APIGroup versions(List<V1GroupVersionForDiscovery> versions) {
        this.versions = versions;
        return this;
    }

    public V1APIGroup addVersionsItem(V1GroupVersionForDiscovery versionsItem) {
        if (this.versions == null) {
            this.versions = new ArrayList<V1GroupVersionForDiscovery>();
        }
        this.versions.add(versionsItem);
        return this;
    }

    @Nonnull
    public List<V1GroupVersionForDiscovery> getVersions() {
        return this.versions;
    }

    public void setVersions(List<V1GroupVersionForDiscovery> versions) {
        this.versions = versions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIGroup v1APIGroup = (V1APIGroup)o;
        return Objects.equals(this.apiVersion, v1APIGroup.apiVersion) && Objects.equals(this.kind, v1APIGroup.kind) && Objects.equals(this.name, v1APIGroup.name) && Objects.equals(this.preferredVersion, v1APIGroup.preferredVersion) && Objects.equals(this.serverAddressByClientCIDRs, v1APIGroup.serverAddressByClientCIDRs) && Objects.equals(this.versions, v1APIGroup.versions);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.name, this.preferredVersion, this.serverAddressByClientCIDRs, this.versions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1APIGroup {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    preferredVersion: ").append(this.toIndentedString(this.preferredVersion)).append("\n");
        sb.append("    serverAddressByClientCIDRs: ").append(this.toIndentedString(this.serverAddressByClientCIDRs)).append("\n");
        sb.append("    versions: ").append(this.toIndentedString(this.versions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayserverAddressByClientCIDRs;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1APIGroup is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1APIGroup` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PREFERRED_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_PREFERRED_VERSION).isJsonNull()) {
            V1GroupVersionForDiscovery.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PREFERRED_VERSION));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS) != null && !jsonObj.get(SERIALIZED_NAME_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS).isJsonNull() && (jsonArrayserverAddressByClientCIDRs = jsonObj.getAsJsonArray(SERIALIZED_NAME_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `serverAddressByClientCIDRs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS).toString()));
            }
            for (int i = 0; i < jsonArrayserverAddressByClientCIDRs.size(); ++i) {
                V1ServerAddressByClientCIDR.validateJsonObject(jsonArrayserverAddressByClientCIDRs.get(i).getAsJsonObject());
            }
        }
        if (!jsonObj.get(SERIALIZED_NAME_VERSIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `versions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSIONS).toString()));
        }
        JsonArray jsonArrayversions = jsonObj.getAsJsonArray(SERIALIZED_NAME_VERSIONS);
        for (int i = 0; i < jsonArrayversions.size(); ++i) {
            V1GroupVersionForDiscovery.validateJsonObject(jsonArrayversions.get(i).getAsJsonObject());
        }
    }

    public static V1APIGroup fromJson(String jsonString) throws IOException {
        return (V1APIGroup)JSON.getGson().fromJson(jsonString, V1APIGroup.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_PREFERRED_VERSION);
        openapiFields.add(SERIALIZED_NAME_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS);
        openapiFields.add(SERIALIZED_NAME_VERSIONS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSIONS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1APIGroup.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1APIGroup.class));
            return new TypeAdapter<V1APIGroup>(){

                public void write(JsonWriter out, V1APIGroup value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1APIGroup read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1APIGroup.validateJsonObject(jsonObj);
                    return (V1APIGroup)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

