/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1DeploymentStrategy;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1DeploymentSpec {
    public static final String SERIALIZED_NAME_MIN_READY_SECONDS = "minReadySeconds";
    @SerializedName(value="minReadySeconds")
    private Integer minReadySeconds;
    public static final String SERIALIZED_NAME_PAUSED = "paused";
    @SerializedName(value="paused")
    private Boolean paused;
    public static final String SERIALIZED_NAME_PROGRESS_DEADLINE_SECONDS = "progressDeadlineSeconds";
    @SerializedName(value="progressDeadlineSeconds")
    private Integer progressDeadlineSeconds;
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    private Integer replicas;
    public static final String SERIALIZED_NAME_REVISION_HISTORY_LIMIT = "revisionHistoryLimit";
    @SerializedName(value="revisionHistoryLimit")
    private Integer revisionHistoryLimit;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private V1LabelSelector selector;
    public static final String SERIALIZED_NAME_STRATEGY = "strategy";
    @SerializedName(value="strategy")
    private V1DeploymentStrategy strategy;
    public static final String SERIALIZED_NAME_TEMPLATE = "template";
    @SerializedName(value="template")
    private V1PodTemplateSpec template;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1DeploymentSpec minReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    @Nullable
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public V1DeploymentSpec paused(Boolean paused) {
        this.paused = paused;
        return this;
    }

    @Nullable
    public Boolean getPaused() {
        return this.paused;
    }

    public void setPaused(Boolean paused) {
        this.paused = paused;
    }

    public V1DeploymentSpec progressDeadlineSeconds(Integer progressDeadlineSeconds) {
        this.progressDeadlineSeconds = progressDeadlineSeconds;
        return this;
    }

    @Nullable
    public Integer getProgressDeadlineSeconds() {
        return this.progressDeadlineSeconds;
    }

    public void setProgressDeadlineSeconds(Integer progressDeadlineSeconds) {
        this.progressDeadlineSeconds = progressDeadlineSeconds;
    }

    public V1DeploymentSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @Nullable
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1DeploymentSpec revisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return this;
    }

    @Nullable
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public void setRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
    }

    public V1DeploymentSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @Nonnull
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1DeploymentSpec strategy(V1DeploymentStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    @Nullable
    public V1DeploymentStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(V1DeploymentStrategy strategy) {
        this.strategy = strategy;
    }

    public V1DeploymentSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @Nonnull
    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1DeploymentSpec v1DeploymentSpec = (V1DeploymentSpec)o;
        return Objects.equals(this.minReadySeconds, v1DeploymentSpec.minReadySeconds) && Objects.equals(this.paused, v1DeploymentSpec.paused) && Objects.equals(this.progressDeadlineSeconds, v1DeploymentSpec.progressDeadlineSeconds) && Objects.equals(this.replicas, v1DeploymentSpec.replicas) && Objects.equals(this.revisionHistoryLimit, v1DeploymentSpec.revisionHistoryLimit) && Objects.equals(this.selector, v1DeploymentSpec.selector) && Objects.equals(this.strategy, v1DeploymentSpec.strategy) && Objects.equals(this.template, v1DeploymentSpec.template);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.paused, this.progressDeadlineSeconds, this.replicas, this.revisionHistoryLimit, this.selector, this.strategy, this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1DeploymentSpec {\n");
        sb.append("    minReadySeconds: ").append(this.toIndentedString(this.minReadySeconds)).append("\n");
        sb.append("    paused: ").append(this.toIndentedString(this.paused)).append("\n");
        sb.append("    progressDeadlineSeconds: ").append(this.toIndentedString(this.progressDeadlineSeconds)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    revisionHistoryLimit: ").append(this.toIndentedString(this.revisionHistoryLimit)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    strategy: ").append(this.toIndentedString(this.strategy)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1DeploymentSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1DeploymentSpec` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        V1LabelSelector.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SELECTOR));
        if (jsonObj.get(SERIALIZED_NAME_STRATEGY) != null && !jsonObj.get(SERIALIZED_NAME_STRATEGY).isJsonNull()) {
            V1DeploymentStrategy.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_STRATEGY));
        }
        V1PodTemplateSpec.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TEMPLATE));
    }

    public static V1DeploymentSpec fromJson(String jsonString) throws IOException {
        return (V1DeploymentSpec)JSON.getGson().fromJson(jsonString, V1DeploymentSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MIN_READY_SECONDS);
        openapiFields.add(SERIALIZED_NAME_PAUSED);
        openapiFields.add(SERIALIZED_NAME_PROGRESS_DEADLINE_SECONDS);
        openapiFields.add(SERIALIZED_NAME_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_REVISION_HISTORY_LIMIT);
        openapiFields.add(SERIALIZED_NAME_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_STRATEGY);
        openapiFields.add(SERIALIZED_NAME_TEMPLATE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SELECTOR);
        openapiRequiredFields.add(SERIALIZED_NAME_TEMPLATE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1DeploymentSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1DeploymentSpec.class));
            return new TypeAdapter<V1DeploymentSpec>(){

                public void write(JsonWriter out, V1DeploymentSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1DeploymentSpec read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1DeploymentSpec.validateJsonObject(jsonObj);
                    return (V1DeploymentSpec)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

