/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1HTTPIngressPath {
    public static final String SERIALIZED_NAME_BACKEND = "backend";
    @SerializedName(value="backend")
    private V1IngressBackend backend;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;
    public static final String SERIALIZED_NAME_PATH_TYPE = "pathType";
    @SerializedName(value="pathType")
    private String pathType;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1HTTPIngressPath backend(V1IngressBackend backend) {
        this.backend = backend;
        return this;
    }

    @Nonnull
    public V1IngressBackend getBackend() {
        return this.backend;
    }

    public void setBackend(V1IngressBackend backend) {
        this.backend = backend;
    }

    public V1HTTPIngressPath path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public V1HTTPIngressPath pathType(String pathType) {
        this.pathType = pathType;
        return this;
    }

    @Nonnull
    public String getPathType() {
        return this.pathType;
    }

    public void setPathType(String pathType) {
        this.pathType = pathType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HTTPIngressPath v1HTTPIngressPath = (V1HTTPIngressPath)o;
        return Objects.equals(this.backend, v1HTTPIngressPath.backend) && Objects.equals(this.path, v1HTTPIngressPath.path) && Objects.equals(this.pathType, v1HTTPIngressPath.pathType);
    }

    public int hashCode() {
        return Objects.hash(this.backend, this.path, this.pathType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1HTTPIngressPath {\n");
        sb.append("    backend: ").append(this.toIndentedString(this.backend)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    pathType: ").append(this.toIndentedString(this.pathType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1HTTPIngressPath is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1HTTPIngressPath` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        V1IngressBackend.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BACKEND));
        if (jsonObj.get(SERIALIZED_NAME_PATH) != null && !jsonObj.get(SERIALIZED_NAME_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATH).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PATH_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pathType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATH_TYPE).toString()));
        }
    }

    public static V1HTTPIngressPath fromJson(String jsonString) throws IOException {
        return (V1HTTPIngressPath)JSON.getGson().fromJson(jsonString, V1HTTPIngressPath.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BACKEND);
        openapiFields.add(SERIALIZED_NAME_PATH);
        openapiFields.add(SERIALIZED_NAME_PATH_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BACKEND);
        openapiRequiredFields.add(SERIALIZED_NAME_PATH_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1HTTPIngressPath.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1HTTPIngressPath.class));
            return new TypeAdapter<V1HTTPIngressPath>(){

                public void write(JsonWriter out, V1HTTPIngressPath value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1HTTPIngressPath read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1HTTPIngressPath.validateJsonObject(jsonObj);
                    return (V1HTTPIngressPath)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

