/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V2CrossVersionObjectReference;
import io.kubernetes.client.openapi.models.V2MetricIdentifier;
import io.kubernetes.client.openapi.models.V2MetricValueStatus;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V2ObjectMetricStatus {
    public static final String SERIALIZED_NAME_CURRENT = "current";
    @SerializedName(value="current")
    private V2MetricValueStatus current;
    public static final String SERIALIZED_NAME_DESCRIBED_OBJECT = "describedObject";
    @SerializedName(value="describedObject")
    private V2CrossVersionObjectReference describedObject;
    public static final String SERIALIZED_NAME_METRIC = "metric";
    @SerializedName(value="metric")
    private V2MetricIdentifier metric;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V2ObjectMetricStatus current(V2MetricValueStatus current) {
        this.current = current;
        return this;
    }

    @Nonnull
    public V2MetricValueStatus getCurrent() {
        return this.current;
    }

    public void setCurrent(V2MetricValueStatus current) {
        this.current = current;
    }

    public V2ObjectMetricStatus describedObject(V2CrossVersionObjectReference describedObject) {
        this.describedObject = describedObject;
        return this;
    }

    @Nonnull
    public V2CrossVersionObjectReference getDescribedObject() {
        return this.describedObject;
    }

    public void setDescribedObject(V2CrossVersionObjectReference describedObject) {
        this.describedObject = describedObject;
    }

    public V2ObjectMetricStatus metric(V2MetricIdentifier metric) {
        this.metric = metric;
        return this;
    }

    @Nonnull
    public V2MetricIdentifier getMetric() {
        return this.metric;
    }

    public void setMetric(V2MetricIdentifier metric) {
        this.metric = metric;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2ObjectMetricStatus v2ObjectMetricStatus = (V2ObjectMetricStatus)o;
        return Objects.equals(this.current, v2ObjectMetricStatus.current) && Objects.equals(this.describedObject, v2ObjectMetricStatus.describedObject) && Objects.equals(this.metric, v2ObjectMetricStatus.metric);
    }

    public int hashCode() {
        return Objects.hash(this.current, this.describedObject, this.metric);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2ObjectMetricStatus {\n");
        sb.append("    current: ").append(this.toIndentedString(this.current)).append("\n");
        sb.append("    describedObject: ").append(this.toIndentedString(this.describedObject)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V2ObjectMetricStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V2ObjectMetricStatus` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        V2MetricValueStatus.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CURRENT));
        V2CrossVersionObjectReference.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DESCRIBED_OBJECT));
        V2MetricIdentifier.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_METRIC));
    }

    public static V2ObjectMetricStatus fromJson(String jsonString) throws IOException {
        return (V2ObjectMetricStatus)JSON.getGson().fromJson(jsonString, V2ObjectMetricStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CURRENT);
        openapiFields.add(SERIALIZED_NAME_DESCRIBED_OBJECT);
        openapiFields.add(SERIALIZED_NAME_METRIC);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENT);
        openapiRequiredFields.add(SERIALIZED_NAME_DESCRIBED_OBJECT);
        openapiRequiredFields.add(SERIALIZED_NAME_METRIC);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V2ObjectMetricStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V2ObjectMetricStatus.class));
            return new TypeAdapter<V2ObjectMetricStatus>(){

                public void write(JsonWriter out, V2ObjectMetricStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V2ObjectMetricStatus read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V2ObjectMetricStatus.validateJsonObject(jsonObj);
                    return (V2ObjectMetricStatus)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

