/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.apis;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.Pair;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CustomObjectsApi {
    private ApiClient localVarApiClient;

    public CustomObjectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomObjectsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createClusterCustomObjectCall(String group, String version, String plural, Object body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createClusterCustomObjectValidateBeforeCall(String group, String version, String plural, Object body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling createClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling createClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling createClusterCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createClusterCustomObject(Async)");
        }
        Call localVarCall = this.createClusterCustomObjectCall(group, version, plural, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public Object createClusterCustomObject(String group, String version, String plural, Object body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<Object> localVarResp = this.createClusterCustomObjectWithHttpInfo(group, version, plural, body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<Object> createClusterCustomObjectWithHttpInfo(String group, String version, String plural, Object body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.createClusterCustomObjectValidateBeforeCall(group, version, plural, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createClusterCustomObjectAsync(String group, String version, String plural, Object body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.createClusterCustomObjectValidateBeforeCall(group, version, plural, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createNamespacedCustomObjectCall(String group, String version, String namespace, String plural, Object body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNamespacedCustomObjectValidateBeforeCall(String group, String version, String namespace, String plural, Object body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling createNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling createNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling createNamespacedCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedCustomObject(Async)");
        }
        Call localVarCall = this.createNamespacedCustomObjectCall(group, version, namespace, plural, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public Object createNamespacedCustomObject(String group, String version, String namespace, String plural, Object body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<Object> localVarResp = this.createNamespacedCustomObjectWithHttpInfo(group, version, namespace, plural, body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<Object> createNamespacedCustomObjectWithHttpInfo(String group, String version, String namespace, String plural, Object body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.createNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createNamespacedCustomObjectAsync(String group, String version, String namespace, String plural, Object body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.createNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteClusterCustomObjectCall(String group, String version, String plural, String name, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteClusterCustomObjectValidateBeforeCall(String group, String version, String plural, String name, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling deleteClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling deleteClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling deleteClusterCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteClusterCustomObject(Async)");
        }
        Call localVarCall = this.deleteClusterCustomObjectCall(group, version, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, _callback);
        return localVarCall;
    }

    public Object deleteClusterCustomObject(String group, String version, String plural, String name, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body) throws ApiException {
        ApiResponse<Object> localVarResp = this.deleteClusterCustomObjectWithHttpInfo(group, version, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body);
        return localVarResp.getData();
    }

    public ApiResponse<Object> deleteClusterCustomObjectWithHttpInfo(String group, String version, String plural, String name, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteClusterCustomObjectValidateBeforeCall(group, version, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteClusterCustomObjectAsync(String group, String version, String plural, String name, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.deleteClusterCustomObjectValidateBeforeCall(group, version, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCollectionClusterCustomObjectCall(String group, String version, String plural, String pretty, String labelSelector, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionClusterCustomObjectValidateBeforeCall(String group, String version, String plural, String pretty, String labelSelector, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling deleteCollectionClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling deleteCollectionClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling deleteCollectionClusterCustomObject(Async)");
        }
        Call localVarCall = this.deleteCollectionClusterCustomObjectCall(group, version, plural, pretty, labelSelector, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, _callback);
        return localVarCall;
    }

    public Object deleteCollectionClusterCustomObject(String group, String version, String plural, String pretty, String labelSelector, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body) throws ApiException {
        ApiResponse<Object> localVarResp = this.deleteCollectionClusterCustomObjectWithHttpInfo(group, version, plural, pretty, labelSelector, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body);
        return localVarResp.getData();
    }

    public ApiResponse<Object> deleteCollectionClusterCustomObjectWithHttpInfo(String group, String version, String plural, String pretty, String labelSelector, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionClusterCustomObjectValidateBeforeCall(group, version, plural, pretty, labelSelector, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCollectionClusterCustomObjectAsync(String group, String version, String plural, String pretty, String labelSelector, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionClusterCustomObjectValidateBeforeCall(group, version, plural, pretty, labelSelector, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCollectionNamespacedCustomObjectCall(String group, String version, String namespace, String plural, String pretty, String labelSelector, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, String fieldSelector, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionNamespacedCustomObjectValidateBeforeCall(String group, String version, String namespace, String plural, String pretty, String labelSelector, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, String fieldSelector, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling deleteCollectionNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling deleteCollectionNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling deleteCollectionNamespacedCustomObject(Async)");
        }
        Call localVarCall = this.deleteCollectionNamespacedCustomObjectCall(group, version, namespace, plural, pretty, labelSelector, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, fieldSelector, body, _callback);
        return localVarCall;
    }

    public Object deleteCollectionNamespacedCustomObject(String group, String version, String namespace, String plural, String pretty, String labelSelector, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, String fieldSelector, V1DeleteOptions body) throws ApiException {
        ApiResponse<Object> localVarResp = this.deleteCollectionNamespacedCustomObjectWithHttpInfo(group, version, namespace, plural, pretty, labelSelector, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, fieldSelector, body);
        return localVarResp.getData();
    }

    public ApiResponse<Object> deleteCollectionNamespacedCustomObjectWithHttpInfo(String group, String version, String namespace, String plural, String pretty, String labelSelector, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, String fieldSelector, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, pretty, labelSelector, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, fieldSelector, body, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCollectionNamespacedCustomObjectAsync(String group, String version, String namespace, String plural, String pretty, String labelSelector, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, String fieldSelector, V1DeleteOptions body, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, pretty, labelSelector, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, fieldSelector, body, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteNamespacedCustomObjectCall(String group, String version, String namespace, String plural, String name, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNamespacedCustomObjectValidateBeforeCall(String group, String version, String namespace, String plural, String name, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling deleteNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling deleteNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling deleteNamespacedCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedCustomObject(Async)");
        }
        Call localVarCall = this.deleteNamespacedCustomObjectCall(group, version, namespace, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, _callback);
        return localVarCall;
    }

    public Object deleteNamespacedCustomObject(String group, String version, String namespace, String plural, String name, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body) throws ApiException {
        ApiResponse<Object> localVarResp = this.deleteNamespacedCustomObjectWithHttpInfo(group, version, namespace, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body);
        return localVarResp.getData();
    }

    public ApiResponse<Object> deleteNamespacedCustomObjectWithHttpInfo(String group, String version, String namespace, String plural, String name, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteNamespacedCustomObjectAsync(String group, String version, String namespace, String plural, String name, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.deleteNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIResourcesCall(String group, String version, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcesValidateBeforeCall(String group, String version, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getAPIResources(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getAPIResources(Async)");
        }
        Call localVarCall = this.getAPIResourcesCall(group, version, _callback);
        return localVarCall;
    }

    public V1APIResourceList getAPIResources(String group, String version) throws ApiException {
        ApiResponse<V1APIResourceList> localVarResp = this.getAPIResourcesWithHttpInfo(group, version);
        return localVarResp.getData();
    }

    public ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo(String group, String version) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(group, version, null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIResourcesAsync(String group, String version, ApiCallback<V1APIResourceList> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(group, version, _callback);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getClusterCustomObjectCall(String group, String version, String plural, String name, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getClusterCustomObjectValidateBeforeCall(String group, String version, String plural, String name, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getClusterCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getClusterCustomObject(Async)");
        }
        Call localVarCall = this.getClusterCustomObjectCall(group, version, plural, name, _callback);
        return localVarCall;
    }

    public Object getClusterCustomObject(String group, String version, String plural, String name) throws ApiException {
        ApiResponse<Object> localVarResp = this.getClusterCustomObjectWithHttpInfo(group, version, plural, name);
        return localVarResp.getData();
    }

    public ApiResponse<Object> getClusterCustomObjectWithHttpInfo(String group, String version, String plural, String name) throws ApiException {
        Call localVarCall = this.getClusterCustomObjectValidateBeforeCall(group, version, plural, name, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getClusterCustomObjectAsync(String group, String version, String plural, String name, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getClusterCustomObjectValidateBeforeCall(group, version, plural, name, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getClusterCustomObjectScaleCall(String group, String version, String plural, String name, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/scale".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getClusterCustomObjectScaleValidateBeforeCall(String group, String version, String plural, String name, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getClusterCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getClusterCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getClusterCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getClusterCustomObjectScale(Async)");
        }
        Call localVarCall = this.getClusterCustomObjectScaleCall(group, version, plural, name, _callback);
        return localVarCall;
    }

    public Object getClusterCustomObjectScale(String group, String version, String plural, String name) throws ApiException {
        ApiResponse<Object> localVarResp = this.getClusterCustomObjectScaleWithHttpInfo(group, version, plural, name);
        return localVarResp.getData();
    }

    public ApiResponse<Object> getClusterCustomObjectScaleWithHttpInfo(String group, String version, String plural, String name) throws ApiException {
        Call localVarCall = this.getClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getClusterCustomObjectScaleAsync(String group, String version, String plural, String name, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getClusterCustomObjectStatusCall(String group, String version, String plural, String name, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/status".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getClusterCustomObjectStatusValidateBeforeCall(String group, String version, String plural, String name, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getClusterCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getClusterCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getClusterCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getClusterCustomObjectStatus(Async)");
        }
        Call localVarCall = this.getClusterCustomObjectStatusCall(group, version, plural, name, _callback);
        return localVarCall;
    }

    public Object getClusterCustomObjectStatus(String group, String version, String plural, String name) throws ApiException {
        ApiResponse<Object> localVarResp = this.getClusterCustomObjectStatusWithHttpInfo(group, version, plural, name);
        return localVarResp.getData();
    }

    public ApiResponse<Object> getClusterCustomObjectStatusWithHttpInfo(String group, String version, String plural, String name) throws ApiException {
        Call localVarCall = this.getClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getClusterCustomObjectStatusAsync(String group, String version, String plural, String name, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getNamespacedCustomObjectCall(String group, String version, String namespace, String plural, String name, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNamespacedCustomObjectValidateBeforeCall(String group, String version, String namespace, String plural, String name, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getNamespacedCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getNamespacedCustomObject(Async)");
        }
        Call localVarCall = this.getNamespacedCustomObjectCall(group, version, namespace, plural, name, _callback);
        return localVarCall;
    }

    public Object getNamespacedCustomObject(String group, String version, String namespace, String plural, String name) throws ApiException {
        ApiResponse<Object> localVarResp = this.getNamespacedCustomObjectWithHttpInfo(group, version, namespace, plural, name);
        return localVarResp.getData();
    }

    public ApiResponse<Object> getNamespacedCustomObjectWithHttpInfo(String group, String version, String namespace, String plural, String name) throws ApiException {
        Call localVarCall = this.getNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getNamespacedCustomObjectAsync(String group, String version, String namespace, String plural, String name, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getNamespacedCustomObjectScaleCall(String group, String version, String namespace, String plural, String name, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNamespacedCustomObjectScaleValidateBeforeCall(String group, String version, String namespace, String plural, String name, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getNamespacedCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getNamespacedCustomObjectScale(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getNamespacedCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getNamespacedCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getNamespacedCustomObjectScale(Async)");
        }
        Call localVarCall = this.getNamespacedCustomObjectScaleCall(group, version, namespace, plural, name, _callback);
        return localVarCall;
    }

    public Object getNamespacedCustomObjectScale(String group, String version, String namespace, String plural, String name) throws ApiException {
        ApiResponse<Object> localVarResp = this.getNamespacedCustomObjectScaleWithHttpInfo(group, version, namespace, plural, name);
        return localVarResp.getData();
    }

    public ApiResponse<Object> getNamespacedCustomObjectScaleWithHttpInfo(String group, String version, String namespace, String plural, String name) throws ApiException {
        Call localVarCall = this.getNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getNamespacedCustomObjectScaleAsync(String group, String version, String namespace, String plural, String name, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getNamespacedCustomObjectStatusCall(String group, String version, String namespace, String plural, String name, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNamespacedCustomObjectStatusValidateBeforeCall(String group, String version, String namespace, String plural, String name, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getNamespacedCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getNamespacedCustomObjectStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getNamespacedCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getNamespacedCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getNamespacedCustomObjectStatus(Async)");
        }
        Call localVarCall = this.getNamespacedCustomObjectStatusCall(group, version, namespace, plural, name, _callback);
        return localVarCall;
    }

    public Object getNamespacedCustomObjectStatus(String group, String version, String namespace, String plural, String name) throws ApiException {
        ApiResponse<Object> localVarResp = this.getNamespacedCustomObjectStatusWithHttpInfo(group, version, namespace, plural, name);
        return localVarResp.getData();
    }

    public ApiResponse<Object> getNamespacedCustomObjectStatusWithHttpInfo(String group, String version, String namespace, String plural, String name) throws ApiException {
        Call localVarCall = this.getNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getNamespacedCustomObjectStatusAsync(String group, String version, String namespace, String plural, String name, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listClusterCustomObjectCall(String group, String version, String plural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/{plural}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/json;stream=watch"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listClusterCustomObjectValidateBeforeCall(String group, String version, String plural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling listClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling listClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling listClusterCustomObject(Async)");
        }
        Call localVarCall = this.listClusterCustomObjectCall(group, version, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, _callback);
        return localVarCall;
    }

    public Object listClusterCustomObject(String group, String version, String plural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<Object> localVarResp = this.listClusterCustomObjectWithHttpInfo(group, version, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch);
        return localVarResp.getData();
    }

    public ApiResponse<Object> listClusterCustomObjectWithHttpInfo(String group, String version, String plural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listClusterCustomObjectValidateBeforeCall(group, version, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listClusterCustomObjectAsync(String group, String version, String plural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, Boolean watch, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.listClusterCustomObjectValidateBeforeCall(group, version, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCustomObjectForAllNamespacesCall(String group, String version, String resourcePlural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/{resource_plural}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{resource_plural\\}", this.localVarApiClient.escapeString(resourcePlural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/json;stream=watch"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCustomObjectForAllNamespacesValidateBeforeCall(String group, String version, String resourcePlural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling listCustomObjectForAllNamespaces(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling listCustomObjectForAllNamespaces(Async)");
        }
        if (resourcePlural == null) {
            throw new ApiException("Missing the required parameter 'resourcePlural' when calling listCustomObjectForAllNamespaces(Async)");
        }
        Call localVarCall = this.listCustomObjectForAllNamespacesCall(group, version, resourcePlural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, _callback);
        return localVarCall;
    }

    public Object listCustomObjectForAllNamespaces(String group, String version, String resourcePlural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<Object> localVarResp = this.listCustomObjectForAllNamespacesWithHttpInfo(group, version, resourcePlural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch);
        return localVarResp.getData();
    }

    public ApiResponse<Object> listCustomObjectForAllNamespacesWithHttpInfo(String group, String version, String resourcePlural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listCustomObjectForAllNamespacesValidateBeforeCall(group, version, resourcePlural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCustomObjectForAllNamespacesAsync(String group, String version, String resourcePlural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, Boolean watch, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.listCustomObjectForAllNamespacesValidateBeforeCall(group, version, resourcePlural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNamespacedCustomObjectCall(String group, String version, String namespace, String plural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/json;stream=watch"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNamespacedCustomObjectValidateBeforeCall(String group, String version, String namespace, String plural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling listNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling listNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling listNamespacedCustomObject(Async)");
        }
        Call localVarCall = this.listNamespacedCustomObjectCall(group, version, namespace, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, _callback);
        return localVarCall;
    }

    public Object listNamespacedCustomObject(String group, String version, String namespace, String plural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<Object> localVarResp = this.listNamespacedCustomObjectWithHttpInfo(group, version, namespace, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch);
        return localVarResp.getData();
    }

    public ApiResponse<Object> listNamespacedCustomObjectWithHttpInfo(String group, String version, String namespace, String plural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNamespacedCustomObjectAsync(String group, String version, String namespace, String plural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, Boolean watch, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.listNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchClusterCustomObjectCall(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchClusterCustomObjectValidateBeforeCall(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchClusterCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchClusterCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchClusterCustomObject(Async)");
        }
        Call localVarCall = this.patchClusterCustomObjectCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public Object patchClusterCustomObject(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<Object> localVarResp = this.patchClusterCustomObjectWithHttpInfo(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<Object> patchClusterCustomObjectWithHttpInfo(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchClusterCustomObjectValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchClusterCustomObjectAsync(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.patchClusterCustomObjectValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchClusterCustomObjectScaleCall(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/scale".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchClusterCustomObjectScaleValidateBeforeCall(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchClusterCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchClusterCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchClusterCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchClusterCustomObjectScale(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchClusterCustomObjectScale(Async)");
        }
        Call localVarCall = this.patchClusterCustomObjectScaleCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public Object patchClusterCustomObjectScale(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<Object> localVarResp = this.patchClusterCustomObjectScaleWithHttpInfo(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<Object> patchClusterCustomObjectScaleWithHttpInfo(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchClusterCustomObjectScaleAsync(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.patchClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchClusterCustomObjectStatusCall(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/status".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchClusterCustomObjectStatusValidateBeforeCall(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchClusterCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchClusterCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchClusterCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchClusterCustomObjectStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchClusterCustomObjectStatus(Async)");
        }
        Call localVarCall = this.patchClusterCustomObjectStatusCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public Object patchClusterCustomObjectStatus(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<Object> localVarResp = this.patchClusterCustomObjectStatusWithHttpInfo(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<Object> patchClusterCustomObjectStatusWithHttpInfo(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchClusterCustomObjectStatusAsync(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.patchClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNamespacedCustomObjectCall(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedCustomObjectValidateBeforeCall(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchNamespacedCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedCustomObject(Async)");
        }
        Call localVarCall = this.patchNamespacedCustomObjectCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public Object patchNamespacedCustomObject(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<Object> localVarResp = this.patchNamespacedCustomObjectWithHttpInfo(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<Object> patchNamespacedCustomObjectWithHttpInfo(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNamespacedCustomObjectAsync(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNamespacedCustomObjectScaleCall(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedCustomObjectScaleValidateBeforeCall(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchNamespacedCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchNamespacedCustomObjectScale(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchNamespacedCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedCustomObjectScale(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedCustomObjectScale(Async)");
        }
        Call localVarCall = this.patchNamespacedCustomObjectScaleCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public Object patchNamespacedCustomObjectScale(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<Object> localVarResp = this.patchNamespacedCustomObjectScaleWithHttpInfo(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<Object> patchNamespacedCustomObjectScaleWithHttpInfo(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNamespacedCustomObjectScaleAsync(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNamespacedCustomObjectStatusCall(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedCustomObjectStatusValidateBeforeCall(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        Call localVarCall = this.patchNamespacedCustomObjectStatusCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public Object patchNamespacedCustomObjectStatus(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<Object> localVarResp = this.patchNamespacedCustomObjectStatusWithHttpInfo(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<Object> patchNamespacedCustomObjectStatusWithHttpInfo(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNamespacedCustomObjectStatusAsync(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceClusterCustomObjectCall(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceClusterCustomObjectValidateBeforeCall(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceClusterCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceClusterCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceClusterCustomObject(Async)");
        }
        Call localVarCall = this.replaceClusterCustomObjectCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public Object replaceClusterCustomObject(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<Object> localVarResp = this.replaceClusterCustomObjectWithHttpInfo(group, version, plural, name, body, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<Object> replaceClusterCustomObjectWithHttpInfo(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceClusterCustomObjectValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceClusterCustomObjectAsync(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.replaceClusterCustomObjectValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceClusterCustomObjectScaleCall(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/scale".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceClusterCustomObjectScaleValidateBeforeCall(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceClusterCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceClusterCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceClusterCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceClusterCustomObjectScale(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceClusterCustomObjectScale(Async)");
        }
        Call localVarCall = this.replaceClusterCustomObjectScaleCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public Object replaceClusterCustomObjectScale(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<Object> localVarResp = this.replaceClusterCustomObjectScaleWithHttpInfo(group, version, plural, name, body, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<Object> replaceClusterCustomObjectScaleWithHttpInfo(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceClusterCustomObjectScaleAsync(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.replaceClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceClusterCustomObjectStatusCall(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/status".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceClusterCustomObjectStatusValidateBeforeCall(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceClusterCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceClusterCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceClusterCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceClusterCustomObjectStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceClusterCustomObjectStatus(Async)");
        }
        Call localVarCall = this.replaceClusterCustomObjectStatusCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public Object replaceClusterCustomObjectStatus(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<Object> localVarResp = this.replaceClusterCustomObjectStatusWithHttpInfo(group, version, plural, name, body, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<Object> replaceClusterCustomObjectStatusWithHttpInfo(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceClusterCustomObjectStatusAsync(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.replaceClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceNamespacedCustomObjectCall(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedCustomObjectValidateBeforeCall(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceNamespacedCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedCustomObject(Async)");
        }
        Call localVarCall = this.replaceNamespacedCustomObjectCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public Object replaceNamespacedCustomObject(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<Object> localVarResp = this.replaceNamespacedCustomObjectWithHttpInfo(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<Object> replaceNamespacedCustomObjectWithHttpInfo(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceNamespacedCustomObjectAsync(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceNamespacedCustomObjectScaleCall(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedCustomObjectScaleValidateBeforeCall(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        Call localVarCall = this.replaceNamespacedCustomObjectScaleCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public Object replaceNamespacedCustomObjectScale(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<Object> localVarResp = this.replaceNamespacedCustomObjectScaleWithHttpInfo(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<Object> replaceNamespacedCustomObjectScaleWithHttpInfo(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceNamespacedCustomObjectScaleAsync(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceNamespacedCustomObjectStatusCall(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status".replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.localVarApiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.localVarApiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedCustomObjectStatusValidateBeforeCall(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        Call localVarCall = this.replaceNamespacedCustomObjectStatusCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public Object replaceNamespacedCustomObjectStatus(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<Object> localVarResp = this.replaceNamespacedCustomObjectStatusWithHttpInfo(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<Object> replaceNamespacedCustomObjectStatusWithHttpInfo(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceNamespacedCustomObjectStatusAsync(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

