/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ResourceHealth;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class V1ResourceStatus {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private List<V1ResourceHealth> resources = null;

    public V1ResourceStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the resource. Must be unique within the pod and match one of the resources from the pod spec.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ResourceStatus resources(List<V1ResourceHealth> resources) {
        this.resources = resources;
        return this;
    }

    public V1ResourceStatus addResourcesItem(V1ResourceHealth resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<V1ResourceHealth>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of unique Resources health. Each element in the list contains an unique resource ID and resource health. At a minimum, ResourceID must uniquely identify the Resource allocated to the Pod on the Node for the lifetime of a Pod. See ResourceID type for it's definition.")
    public List<V1ResourceHealth> getResources() {
        return this.resources;
    }

    public void setResources(List<V1ResourceHealth> resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceStatus v1ResourceStatus = (V1ResourceStatus)o;
        return Objects.equals(this.name, v1ResourceStatus.name) && Objects.equals(this.resources, v1ResourceStatus.resources);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.resources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceStatus {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

