/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1alpha3DeviceAllocationResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="AllocationResult contains attributes of an allocated resource.")
public class V1alpha3AllocationResult {
    public static final String SERIALIZED_NAME_CONTROLLER = "controller";
    @SerializedName(value="controller")
    private String controller;
    public static final String SERIALIZED_NAME_DEVICES = "devices";
    @SerializedName(value="devices")
    private V1alpha3DeviceAllocationResult devices;
    public static final String SERIALIZED_NAME_NODE_SELECTOR = "nodeSelector";
    @SerializedName(value="nodeSelector")
    private V1NodeSelector nodeSelector;

    public V1alpha3AllocationResult controller(String controller) {
        this.controller = controller;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.  A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.  This is an alpha field and requires enabling the DRAControlPlaneController feature gate.")
    public String getController() {
        return this.controller;
    }

    public void setController(String controller) {
        this.controller = controller;
    }

    public V1alpha3AllocationResult devices(V1alpha3DeviceAllocationResult devices) {
        this.devices = devices;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha3DeviceAllocationResult getDevices() {
        return this.devices;
    }

    public void setDevices(V1alpha3DeviceAllocationResult devices) {
        this.devices = devices;
    }

    public V1alpha3AllocationResult nodeSelector(V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3AllocationResult v1alpha3AllocationResult = (V1alpha3AllocationResult)o;
        return Objects.equals(this.controller, v1alpha3AllocationResult.controller) && Objects.equals(this.devices, v1alpha3AllocationResult.devices) && Objects.equals(this.nodeSelector, v1alpha3AllocationResult.nodeSelector);
    }

    public int hashCode() {
        return Objects.hash(this.controller, this.devices, this.nodeSelector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3AllocationResult {\n");
        sb.append("    controller: ").append(this.toIndentedString(this.controller)).append("\n");
        sb.append("    devices: ").append(this.toIndentedString(this.devices)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

