/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="CertificateSigningRequestSpec contains the certificate request.")
public class V1CertificateSigningRequestSpec {
    public static final String SERIALIZED_NAME_EXPIRATION_SECONDS = "expirationSeconds";
    @SerializedName(value="expirationSeconds")
    private Integer expirationSeconds;
    public static final String SERIALIZED_NAME_EXTRA = "extra";
    @SerializedName(value="extra")
    private Map<String, List<String>> extra = new HashMap<String, List<String>>();
    public static final String SERIALIZED_NAME_GROUPS = "groups";
    @SerializedName(value="groups")
    private List<String> groups = new ArrayList<String>();
    public static final String SERIALIZED_NAME_REQUEST = "request";
    @SerializedName(value="request")
    private byte[] request;
    public static final String SERIALIZED_NAME_SIGNER_NAME = "signerName";
    @SerializedName(value="signerName")
    private String signerName;
    public static final String SERIALIZED_NAME_UID = "uid";
    @SerializedName(value="uid")
    private String uid;
    public static final String SERIALIZED_NAME_USAGES = "usages";
    @SerializedName(value="usages")
    private List<String> usages = new ArrayList<String>();
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1CertificateSigningRequestSpec expirationSeconds(Integer expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="expirationSeconds is the requested duration of validity of the issued certificate. The certificate signer may issue a certificate with a different validity duration so a client must check the delta between the notBefore and and notAfter fields in the issued certificate to determine the actual duration.  The v1.22+ in-tree implementations of the well-known Kubernetes signers will honor this field as long as the requested duration is not greater than the maximum duration they will honor per the --cluster-signing-duration CLI flag to the Kubernetes controller manager.  Certificate signers may not honor this field for various reasons:    1. Old signer that is unaware of the field (such as the in-tree      implementations prior to v1.22)   2. Signer whose configured maximum is shorter than the requested duration   3. Signer whose configured minimum is longer than the requested duration  The minimum valid value for expirationSeconds is 600, i.e. 10 minutes.")
    public Integer getExpirationSeconds() {
        return this.expirationSeconds;
    }

    public void setExpirationSeconds(Integer expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
    }

    public V1CertificateSigningRequestSpec extra(Map<String, List<String>> extra) {
        this.extra = extra;
        return this;
    }

    public V1CertificateSigningRequestSpec putExtraItem(String key, List<String> extraItem) {
        if (this.extra == null) {
            this.extra = new HashMap<String, List<String>>();
        }
        this.extra.put(key, extraItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="extra contains extra attributes of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.")
    public Map<String, List<String>> getExtra() {
        return this.extra;
    }

    public void setExtra(Map<String, List<String>> extra) {
        this.extra = extra;
    }

    public V1CertificateSigningRequestSpec groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public V1CertificateSigningRequestSpec addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="groups contains group membership of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.")
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public V1CertificateSigningRequestSpec request(byte[] request) {
        this.request = request;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="request contains an x509 certificate signing request encoded in a \"CERTIFICATE REQUEST\" PEM block. When serialized as JSON or YAML, the data is additionally base64-encoded.")
    public byte[] getRequest() {
        return this.request;
    }

    public void setRequest(byte[] request) {
        this.request = request;
    }

    public V1CertificateSigningRequestSpec signerName(String signerName) {
        this.signerName = signerName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="signerName indicates the requested signer, and is a qualified name.  List/watch requests for CertificateSigningRequests can filter on this field using a \"spec.signerName=NAME\" fieldSelector.  Well-known Kubernetes signers are:  1. \"kubernetes.io/kube-apiserver-client\": issues client certificates that can be used to authenticate to kube-apiserver.   Requests for this signer are never auto-approved by kube-controller-manager, can be issued by the \"csrsigning\" controller in kube-controller-manager.  2. \"kubernetes.io/kube-apiserver-client-kubelet\": issues client certificates that kubelets use to authenticate to kube-apiserver.   Requests for this signer can be auto-approved by the \"csrapproving\" controller in kube-controller-manager, and can be issued by the \"csrsigning\" controller in kube-controller-manager.  3. \"kubernetes.io/kubelet-serving\" issues serving certificates that kubelets use to serve TLS endpoints, which kube-apiserver can connect to securely.   Requests for this signer are never auto-approved by kube-controller-manager, and can be issued by the \"csrsigning\" controller in kube-controller-manager.  More details are available at https://k8s.io/docs/reference/access-authn-authz/certificate-signing-requests/#kubernetes-signers  Custom signerNames can also be specified. The signer defines:  1. Trust distribution: how trust (CA bundles) are distributed.  2. Permitted subjects: and behavior when a disallowed subject is requested.  3. Required, permitted, or forbidden x509 extensions in the request (including whether subjectAltNames are allowed, which types, restrictions on allowed values) and behavior when a disallowed extension is requested.  4. Required, permitted, or forbidden key usages / extended key usages.  5. Expiration/certificate lifetime: whether it is fixed by the signer, configurable by the admin.  6. Whether or not requests for CA certificates are allowed.")
    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public V1CertificateSigningRequestSpec uid(String uid) {
        this.uid = uid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="uid contains the uid of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.")
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public V1CertificateSigningRequestSpec usages(List<String> usages) {
        this.usages = usages;
        return this;
    }

    public V1CertificateSigningRequestSpec addUsagesItem(String usagesItem) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(usagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="usages specifies a set of key usages requested in the issued certificate.  Requests for TLS client certificates typically request: \"digital signature\", \"key encipherment\", \"client auth\".  Requests for TLS serving certificates typically request: \"key encipherment\", \"digital signature\", \"server auth\".  Valid values are:  \"signing\", \"digital signature\", \"content commitment\",  \"key encipherment\", \"key agreement\", \"data encipherment\",  \"cert sign\", \"crl sign\", \"encipher only\", \"decipher only\", \"any\",  \"server auth\", \"client auth\",  \"code signing\", \"email protection\", \"s/mime\",  \"ipsec end system\", \"ipsec tunnel\", \"ipsec user\",  \"timestamping\", \"ocsp signing\", \"microsoft sgc\", \"netscape sgc\"")
    public List<String> getUsages() {
        return this.usages;
    }

    public void setUsages(List<String> usages) {
        this.usages = usages;
    }

    public V1CertificateSigningRequestSpec username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="username contains the name of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CertificateSigningRequestSpec v1CertificateSigningRequestSpec = (V1CertificateSigningRequestSpec)o;
        return Objects.equals(this.expirationSeconds, v1CertificateSigningRequestSpec.expirationSeconds) && Objects.equals(this.extra, v1CertificateSigningRequestSpec.extra) && Objects.equals(this.groups, v1CertificateSigningRequestSpec.groups) && Arrays.equals(this.request, v1CertificateSigningRequestSpec.request) && Objects.equals(this.signerName, v1CertificateSigningRequestSpec.signerName) && Objects.equals(this.uid, v1CertificateSigningRequestSpec.uid) && Objects.equals(this.usages, v1CertificateSigningRequestSpec.usages) && Objects.equals(this.username, v1CertificateSigningRequestSpec.username);
    }

    public int hashCode() {
        return Objects.hash(this.expirationSeconds, this.extra, this.groups, Arrays.hashCode(this.request), this.signerName, this.uid, this.usages, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CertificateSigningRequestSpec {\n");
        sb.append("    expirationSeconds: ").append(this.toIndentedString(this.expirationSeconds)).append("\n");
        sb.append("    extra: ").append(this.toIndentedString(this.extra)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    signerName: ").append(this.toIndentedString(this.signerName)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("    usages: ").append(this.toIndentedString(this.usages)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1CertificateSigningRequestSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1CertificateSigningRequestSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_GROUPS) != null && !jsonObj.get(SERIALIZED_NAME_GROUPS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GROUPS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `groups` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUPS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SIGNER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `signerName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIGNER_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UID) != null && !jsonObj.get(SERIALIZED_NAME_UID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USAGES) != null && !jsonObj.get(SERIALIZED_NAME_USAGES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USAGES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `usages` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USAGES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
    }

    public static V1CertificateSigningRequestSpec fromJson(String jsonString) throws IOException {
        return (V1CertificateSigningRequestSpec)JSON.getGson().fromJson(jsonString, V1CertificateSigningRequestSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EXPIRATION_SECONDS);
        openapiFields.add(SERIALIZED_NAME_EXTRA);
        openapiFields.add(SERIALIZED_NAME_GROUPS);
        openapiFields.add(SERIALIZED_NAME_REQUEST);
        openapiFields.add(SERIALIZED_NAME_SIGNER_NAME);
        openapiFields.add(SERIALIZED_NAME_UID);
        openapiFields.add(SERIALIZED_NAME_USAGES);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_REQUEST);
        openapiRequiredFields.add(SERIALIZED_NAME_SIGNER_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1CertificateSigningRequestSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1CertificateSigningRequestSpec.class));
            return new TypeAdapter<V1CertificateSigningRequestSpec>(){

                public void write(JsonWriter out, V1CertificateSigningRequestSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1CertificateSigningRequestSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1CertificateSigningRequestSpec.validateJsonElement(jsonElement);
                    return (V1CertificateSigningRequestSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

