/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ContainerStateRunning;
import io.kubernetes.client.openapi.models.V1ContainerStateTerminated;
import io.kubernetes.client.openapi.models.V1ContainerStateWaiting;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ContainerState holds a possible state of container. Only one of its members may be specified. If none of them is specified, the default one is ContainerStateWaiting.")
public class V1ContainerState {
    public static final String SERIALIZED_NAME_RUNNING = "running";
    @SerializedName(value="running")
    private V1ContainerStateRunning running;
    public static final String SERIALIZED_NAME_TERMINATED = "terminated";
    @SerializedName(value="terminated")
    private V1ContainerStateTerminated terminated;
    public static final String SERIALIZED_NAME_WAITING = "waiting";
    @SerializedName(value="waiting")
    private V1ContainerStateWaiting waiting;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ContainerState running(V1ContainerStateRunning running) {
        this.running = running;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ContainerStateRunning getRunning() {
        return this.running;
    }

    public void setRunning(V1ContainerStateRunning running) {
        this.running = running;
    }

    public V1ContainerState terminated(V1ContainerStateTerminated terminated) {
        this.terminated = terminated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ContainerStateTerminated getTerminated() {
        return this.terminated;
    }

    public void setTerminated(V1ContainerStateTerminated terminated) {
        this.terminated = terminated;
    }

    public V1ContainerState waiting(V1ContainerStateWaiting waiting) {
        this.waiting = waiting;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ContainerStateWaiting getWaiting() {
        return this.waiting;
    }

    public void setWaiting(V1ContainerStateWaiting waiting) {
        this.waiting = waiting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerState v1ContainerState = (V1ContainerState)o;
        return Objects.equals(this.running, v1ContainerState.running) && Objects.equals(this.terminated, v1ContainerState.terminated) && Objects.equals(this.waiting, v1ContainerState.waiting);
    }

    public int hashCode() {
        return Objects.hash(this.running, this.terminated, this.waiting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ContainerState {\n");
        sb.append("    running: ").append(this.toIndentedString(this.running)).append("\n");
        sb.append("    terminated: ").append(this.toIndentedString(this.terminated)).append("\n");
        sb.append("    waiting: ").append(this.toIndentedString(this.waiting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ContainerState is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ContainerState` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_RUNNING) != null && !jsonObj.get(SERIALIZED_NAME_RUNNING).isJsonNull()) {
            V1ContainerStateRunning.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RUNNING));
        }
        if (jsonObj.get(SERIALIZED_NAME_TERMINATED) != null && !jsonObj.get(SERIALIZED_NAME_TERMINATED).isJsonNull()) {
            V1ContainerStateTerminated.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TERMINATED));
        }
        if (jsonObj.get(SERIALIZED_NAME_WAITING) != null && !jsonObj.get(SERIALIZED_NAME_WAITING).isJsonNull()) {
            V1ContainerStateWaiting.validateJsonElement(jsonObj.get(SERIALIZED_NAME_WAITING));
        }
    }

    public static V1ContainerState fromJson(String jsonString) throws IOException {
        return (V1ContainerState)JSON.getGson().fromJson(jsonString, V1ContainerState.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RUNNING);
        openapiFields.add(SERIALIZED_NAME_TERMINATED);
        openapiFields.add(SERIALIZED_NAME_WAITING);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ContainerState.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ContainerState.class));
            return new TypeAdapter<V1ContainerState>(){

                public void write(JsonWriter out, V1ContainerState value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ContainerState read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ContainerState.validateJsonElement(jsonElement);
                    return (V1ContainerState)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

