/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.CoreV1EndpointPort;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="EndpointSubset is a group of addresses with a common set of ports. The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:   {    Addresses: [{\"ip\": \"10.10.1.1\"}, {\"ip\": \"10.10.2.2\"}],    Ports:     [{\"name\": \"a\", \"port\": 8675}, {\"name\": \"b\", \"port\": 309}]  }  The resulting set of endpoints can be viewed as:   a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],  b: [ 10.10.1.1:309, 10.10.2.2:309 ]")
public class V1EndpointSubset {
    public static final String SERIALIZED_NAME_ADDRESSES = "addresses";
    @SerializedName(value="addresses")
    private List<V1EndpointAddress> addresses = new ArrayList<V1EndpointAddress>();
    public static final String SERIALIZED_NAME_NOT_READY_ADDRESSES = "notReadyAddresses";
    @SerializedName(value="notReadyAddresses")
    private List<V1EndpointAddress> notReadyAddresses = new ArrayList<V1EndpointAddress>();
    public static final String SERIALIZED_NAME_PORTS = "ports";
    @SerializedName(value="ports")
    private List<CoreV1EndpointPort> ports = new ArrayList<CoreV1EndpointPort>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1EndpointSubset addresses(List<V1EndpointAddress> addresses) {
        this.addresses = addresses;
        return this;
    }

    public V1EndpointSubset addAddressesItem(V1EndpointAddress addressesItem) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<V1EndpointAddress>();
        }
        this.addresses.add(addressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.")
    public List<V1EndpointAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<V1EndpointAddress> addresses) {
        this.addresses = addresses;
    }

    public V1EndpointSubset notReadyAddresses(List<V1EndpointAddress> notReadyAddresses) {
        this.notReadyAddresses = notReadyAddresses;
        return this;
    }

    public V1EndpointSubset addNotReadyAddressesItem(V1EndpointAddress notReadyAddressesItem) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList<V1EndpointAddress>();
        }
        this.notReadyAddresses.add(notReadyAddressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.")
    public List<V1EndpointAddress> getNotReadyAddresses() {
        return this.notReadyAddresses;
    }

    public void setNotReadyAddresses(List<V1EndpointAddress> notReadyAddresses) {
        this.notReadyAddresses = notReadyAddresses;
    }

    public V1EndpointSubset ports(List<CoreV1EndpointPort> ports) {
        this.ports = ports;
        return this;
    }

    public V1EndpointSubset addPortsItem(CoreV1EndpointPort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<CoreV1EndpointPort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Port numbers available on the related IP addresses.")
    public List<CoreV1EndpointPort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<CoreV1EndpointPort> ports) {
        this.ports = ports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EndpointSubset v1EndpointSubset = (V1EndpointSubset)o;
        return Objects.equals(this.addresses, v1EndpointSubset.addresses) && Objects.equals(this.notReadyAddresses, v1EndpointSubset.notReadyAddresses) && Objects.equals(this.ports, v1EndpointSubset.ports);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.notReadyAddresses, this.ports);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1EndpointSubset {\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    notReadyAddresses: ").append(this.toIndentedString(this.notReadyAddresses)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayports;
        JsonArray jsonArraynotReadyAddresses;
        int i;
        JsonArray jsonArrayaddresses;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1EndpointSubset is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1EndpointSubset` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ADDRESSES) != null && !jsonObj.get(SERIALIZED_NAME_ADDRESSES).isJsonNull() && (jsonArrayaddresses = jsonObj.getAsJsonArray(SERIALIZED_NAME_ADDRESSES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ADDRESSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `addresses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDRESSES).toString()));
            }
            for (i = 0; i < jsonArrayaddresses.size(); ++i) {
                V1EndpointAddress.validateJsonElement(jsonArrayaddresses.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_NOT_READY_ADDRESSES) != null && !jsonObj.get(SERIALIZED_NAME_NOT_READY_ADDRESSES).isJsonNull() && (jsonArraynotReadyAddresses = jsonObj.getAsJsonArray(SERIALIZED_NAME_NOT_READY_ADDRESSES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_NOT_READY_ADDRESSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `notReadyAddresses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOT_READY_ADDRESSES).toString()));
            }
            for (i = 0; i < jsonArraynotReadyAddresses.size(); ++i) {
                V1EndpointAddress.validateJsonElement(jsonArraynotReadyAddresses.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_PORTS) != null && !jsonObj.get(SERIALIZED_NAME_PORTS).isJsonNull() && (jsonArrayports = jsonObj.getAsJsonArray(SERIALIZED_NAME_PORTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PORTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `ports` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORTS).toString()));
            }
            for (i = 0; i < jsonArrayports.size(); ++i) {
                CoreV1EndpointPort.validateJsonElement(jsonArrayports.get(i));
            }
        }
    }

    public static V1EndpointSubset fromJson(String jsonString) throws IOException {
        return (V1EndpointSubset)JSON.getGson().fromJson(jsonString, V1EndpointSubset.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESSES);
        openapiFields.add(SERIALIZED_NAME_NOT_READY_ADDRESSES);
        openapiFields.add(SERIALIZED_NAME_PORTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1EndpointSubset.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1EndpointSubset.class));
            return new TypeAdapter<V1EndpointSubset>(){

                public void write(JsonWriter out, V1EndpointSubset value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1EndpointSubset read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1EndpointSubset.validateJsonElement(jsonElement);
                    return (V1EndpointSubset)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

