/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1IngressClassParametersReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="IngressClassSpec provides information about the class of an Ingress.")
public class V1IngressClassSpec {
    public static final String SERIALIZED_NAME_CONTROLLER = "controller";
    @SerializedName(value="controller")
    private String controller;
    public static final String SERIALIZED_NAME_PARAMETERS = "parameters";
    @SerializedName(value="parameters")
    private V1IngressClassParametersReference parameters;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1IngressClassSpec controller(String controller) {
        this.controller = controller;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="controller refers to the name of the controller that should handle this class. This allows for different \"flavors\" that are controlled by the same controller. For example, you may have different parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. \"acme.io/ingress-controller\". This field is immutable.")
    public String getController() {
        return this.controller;
    }

    public void setController(String controller) {
        this.controller = controller;
    }

    public V1IngressClassSpec parameters(V1IngressClassParametersReference parameters) {
        this.parameters = parameters;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1IngressClassParametersReference getParameters() {
        return this.parameters;
    }

    public void setParameters(V1IngressClassParametersReference parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1IngressClassSpec v1IngressClassSpec = (V1IngressClassSpec)o;
        return Objects.equals(this.controller, v1IngressClassSpec.controller) && Objects.equals(this.parameters, v1IngressClassSpec.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.controller, this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1IngressClassSpec {\n");
        sb.append("    controller: ").append(this.toIndentedString(this.controller)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1IngressClassSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1IngressClassSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONTROLLER) != null && !jsonObj.get(SERIALIZED_NAME_CONTROLLER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTROLLER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `controller` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTROLLER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PARAMETERS) != null && !jsonObj.get(SERIALIZED_NAME_PARAMETERS).isJsonNull()) {
            V1IngressClassParametersReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PARAMETERS));
        }
    }

    public static V1IngressClassSpec fromJson(String jsonString) throws IOException {
        return (V1IngressClassSpec)JSON.getGson().fromJson(jsonString, V1IngressClassSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTROLLER);
        openapiFields.add(SERIALIZED_NAME_PARAMETERS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1IngressClassSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1IngressClassSpec.class));
            return new TypeAdapter<V1IngressClassSpec>(){

                public void write(JsonWriter out, V1IngressClassSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1IngressClassSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1IngressClassSpec.validateJsonElement(jsonElement);
                    return (V1IngressClassSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

