/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1NodeRuntimeHandlerFeatures;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="NodeRuntimeHandler is a set of runtime handler information.")
public class V1NodeRuntimeHandler {
    public static final String SERIALIZED_NAME_FEATURES = "features";
    @SerializedName(value="features")
    private V1NodeRuntimeHandlerFeatures features;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1NodeRuntimeHandler features(V1NodeRuntimeHandlerFeatures features) {
        this.features = features;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeRuntimeHandlerFeatures getFeatures() {
        return this.features;
    }

    public void setFeatures(V1NodeRuntimeHandlerFeatures features) {
        this.features = features;
    }

    public V1NodeRuntimeHandler name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Runtime handler name. Empty for the default runtime handler.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NodeRuntimeHandler v1NodeRuntimeHandler = (V1NodeRuntimeHandler)o;
        return Objects.equals(this.features, v1NodeRuntimeHandler.features) && Objects.equals(this.name, v1NodeRuntimeHandler.name);
    }

    public int hashCode() {
        return Objects.hash(this.features, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NodeRuntimeHandler {\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1NodeRuntimeHandler is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1NodeRuntimeHandler` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_FEATURES) != null && !jsonObj.get(SERIALIZED_NAME_FEATURES).isJsonNull()) {
            V1NodeRuntimeHandlerFeatures.validateJsonElement(jsonObj.get(SERIALIZED_NAME_FEATURES));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
    }

    public static V1NodeRuntimeHandler fromJson(String jsonString) throws IOException {
        return (V1NodeRuntimeHandler)JSON.getGson().fromJson(jsonString, V1NodeRuntimeHandler.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FEATURES);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1NodeRuntimeHandler.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1NodeRuntimeHandler.class));
            return new TypeAdapter<V1NodeRuntimeHandler>(){

                public void write(JsonWriter out, V1NodeRuntimeHandler value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1NodeRuntimeHandler read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1NodeRuntimeHandler.validateJsonElement(jsonElement);
                    return (V1NodeRuntimeHandler)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

