/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.")
public class V1StatefulSetPersistentVolumeClaimRetentionPolicy {
    public static final String SERIALIZED_NAME_WHEN_DELETED = "whenDeleted";
    @SerializedName(value="whenDeleted")
    private String whenDeleted;
    public static final String SERIALIZED_NAME_WHEN_SCALED = "whenScaled";
    @SerializedName(value="whenScaled")
    private String whenScaled;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1StatefulSetPersistentVolumeClaimRetentionPolicy whenDeleted(String whenDeleted) {
        this.whenDeleted = whenDeleted;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.")
    public String getWhenDeleted() {
        return this.whenDeleted;
    }

    public void setWhenDeleted(String whenDeleted) {
        this.whenDeleted = whenDeleted;
    }

    public V1StatefulSetPersistentVolumeClaimRetentionPolicy whenScaled(String whenScaled) {
        this.whenScaled = whenScaled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.")
    public String getWhenScaled() {
        return this.whenScaled;
    }

    public void setWhenScaled(String whenScaled) {
        this.whenScaled = whenScaled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StatefulSetPersistentVolumeClaimRetentionPolicy v1StatefulSetPersistentVolumeClaimRetentionPolicy = (V1StatefulSetPersistentVolumeClaimRetentionPolicy)o;
        return Objects.equals(this.whenDeleted, v1StatefulSetPersistentVolumeClaimRetentionPolicy.whenDeleted) && Objects.equals(this.whenScaled, v1StatefulSetPersistentVolumeClaimRetentionPolicy.whenScaled);
    }

    public int hashCode() {
        return Objects.hash(this.whenDeleted, this.whenScaled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1StatefulSetPersistentVolumeClaimRetentionPolicy {\n");
        sb.append("    whenDeleted: ").append(this.toIndentedString(this.whenDeleted)).append("\n");
        sb.append("    whenScaled: ").append(this.toIndentedString(this.whenScaled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1StatefulSetPersistentVolumeClaimRetentionPolicy is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1StatefulSetPersistentVolumeClaimRetentionPolicy` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_WHEN_DELETED) != null && !jsonObj.get(SERIALIZED_NAME_WHEN_DELETED).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_WHEN_DELETED).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `whenDeleted` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WHEN_DELETED).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WHEN_SCALED) != null && !jsonObj.get(SERIALIZED_NAME_WHEN_SCALED).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_WHEN_SCALED).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `whenScaled` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WHEN_SCALED).toString()));
        }
    }

    public static V1StatefulSetPersistentVolumeClaimRetentionPolicy fromJson(String jsonString) throws IOException {
        return (V1StatefulSetPersistentVolumeClaimRetentionPolicy)JSON.getGson().fromJson(jsonString, V1StatefulSetPersistentVolumeClaimRetentionPolicy.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_WHEN_DELETED);
        openapiFields.add(SERIALIZED_NAME_WHEN_SCALED);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1StatefulSetPersistentVolumeClaimRetentionPolicy.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1StatefulSetPersistentVolumeClaimRetentionPolicy.class));
            return new TypeAdapter<V1StatefulSetPersistentVolumeClaimRetentionPolicy>(){

                public void write(JsonWriter out, V1StatefulSetPersistentVolumeClaimRetentionPolicy value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1StatefulSetPersistentVolumeClaimRetentionPolicy read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1StatefulSetPersistentVolumeClaimRetentionPolicy.validateJsonElement(jsonElement);
                    return (V1StatefulSetPersistentVolumeClaimRetentionPolicy)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

