/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.")
public class V1NamedRuleWithOperations {
    public static final String SERIALIZED_NAME_API_GROUPS = "apiGroups";
    @SerializedName(value="apiGroups")
    private List<String> apiGroups = null;
    public static final String SERIALIZED_NAME_API_VERSIONS = "apiVersions";
    @SerializedName(value="apiVersions")
    private List<String> apiVersions = null;
    public static final String SERIALIZED_NAME_OPERATIONS = "operations";
    @SerializedName(value="operations")
    private List<String> operations = null;
    public static final String SERIALIZED_NAME_RESOURCE_NAMES = "resourceNames";
    @SerializedName(value="resourceNames")
    private List<String> resourceNames = null;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private List<String> resources = null;
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    private String scope;

    public V1NamedRuleWithOperations apiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
        return this;
    }

    public V1NamedRuleWithOperations addApiGroupsItem(String apiGroupsItem) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(apiGroupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.")
    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    public void setApiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
    }

    public V1NamedRuleWithOperations apiVersions(List<String> apiVersions) {
        this.apiVersions = apiVersions;
        return this;
    }

    public V1NamedRuleWithOperations addApiVersionsItem(String apiVersionsItem) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        this.apiVersions.add(apiVersionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.")
    public List<String> getApiVersions() {
        return this.apiVersions;
    }

    public void setApiVersions(List<String> apiVersions) {
        this.apiVersions = apiVersions;
    }

    public V1NamedRuleWithOperations operations(List<String> operations) {
        this.operations = operations;
        return this;
    }

    public V1NamedRuleWithOperations addOperationsItem(String operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<String>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.")
    public List<String> getOperations() {
        return this.operations;
    }

    public void setOperations(List<String> operations) {
        this.operations = operations;
    }

    public V1NamedRuleWithOperations resourceNames(List<String> resourceNames) {
        this.resourceNames = resourceNames;
        return this;
    }

    public V1NamedRuleWithOperations addResourceNamesItem(String resourceNamesItem) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.add(resourceNamesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.")
    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    public void setResourceNames(List<String> resourceNames) {
        this.resourceNames = resourceNames;
    }

    public V1NamedRuleWithOperations resources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public V1NamedRuleWithOperations addResourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Resources is a list of resources this rule applies to.  For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/_*' means all subresources of pods. '*_/scale' means all scale subresources. '*_/_*' means all resources and their subresources.  If wildcard is present, the validation rule will ensure resources do not overlap with each other.  Depending on the enclosing object, subresources might not be allowed. Required.")
    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public V1NamedRuleWithOperations scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="scope specifies the scope of this rule. Valid values are \"Cluster\", \"Namespaced\", and \"*\" \"Cluster\" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. \"Namespaced\" means that only namespaced resources will match this rule. \"*\" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is \"*\".")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NamedRuleWithOperations v1NamedRuleWithOperations = (V1NamedRuleWithOperations)o;
        return Objects.equals(this.apiGroups, v1NamedRuleWithOperations.apiGroups) && Objects.equals(this.apiVersions, v1NamedRuleWithOperations.apiVersions) && Objects.equals(this.operations, v1NamedRuleWithOperations.operations) && Objects.equals(this.resourceNames, v1NamedRuleWithOperations.resourceNames) && Objects.equals(this.resources, v1NamedRuleWithOperations.resources) && Objects.equals(this.scope, v1NamedRuleWithOperations.scope);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroups, this.apiVersions, this.operations, this.resourceNames, this.resources, this.scope);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NamedRuleWithOperations {\n");
        sb.append("    apiGroups: ").append(this.toIndentedString(this.apiGroups)).append("\n");
        sb.append("    apiVersions: ").append(this.toIndentedString(this.apiVersions)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    resourceNames: ").append(this.toIndentedString(this.resourceNames)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

