/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1alpha3AllocatedDeviceStatus;
import io.kubernetes.client.openapi.models.V1alpha3AllocationResult;
import io.kubernetes.client.openapi.models.V1alpha3ResourceClaimConsumerReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.")
public class V1alpha3ResourceClaimStatus {
    public static final String SERIALIZED_NAME_ALLOCATION = "allocation";
    @SerializedName(value="allocation")
    private V1alpha3AllocationResult allocation;
    public static final String SERIALIZED_NAME_DEVICES = "devices";
    @SerializedName(value="devices")
    private List<V1alpha3AllocatedDeviceStatus> devices = null;
    public static final String SERIALIZED_NAME_RESERVED_FOR = "reservedFor";
    @SerializedName(value="reservedFor")
    private List<V1alpha3ResourceClaimConsumerReference> reservedFor = null;

    public V1alpha3ResourceClaimStatus allocation(V1alpha3AllocationResult allocation) {
        this.allocation = allocation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha3AllocationResult getAllocation() {
        return this.allocation;
    }

    public void setAllocation(V1alpha3AllocationResult allocation) {
        this.allocation = allocation;
    }

    public V1alpha3ResourceClaimStatus devices(List<V1alpha3AllocatedDeviceStatus> devices) {
        this.devices = devices;
        return this;
    }

    public V1alpha3ResourceClaimStatus addDevicesItem(V1alpha3AllocatedDeviceStatus devicesItem) {
        if (this.devices == null) {
            this.devices = new ArrayList<V1alpha3AllocatedDeviceStatus>();
        }
        this.devices.add(devicesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Devices contains the status of each device allocated for this claim, as reported by the driver. This can include driver-specific information. Entries are owned by their respective drivers.")
    public List<V1alpha3AllocatedDeviceStatus> getDevices() {
        return this.devices;
    }

    public void setDevices(List<V1alpha3AllocatedDeviceStatus> devices) {
        this.devices = devices;
    }

    public V1alpha3ResourceClaimStatus reservedFor(List<V1alpha3ResourceClaimConsumerReference> reservedFor) {
        this.reservedFor = reservedFor;
        return this;
    }

    public V1alpha3ResourceClaimStatus addReservedForItem(V1alpha3ResourceClaimConsumerReference reservedForItem) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList<V1alpha3ResourceClaimConsumerReference>();
        }
        this.reservedFor.add(reservedForItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.  In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.  Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.  There can be at most 256 such reservations. This may get increased in the future, but not reduced.")
    public List<V1alpha3ResourceClaimConsumerReference> getReservedFor() {
        return this.reservedFor;
    }

    public void setReservedFor(List<V1alpha3ResourceClaimConsumerReference> reservedFor) {
        this.reservedFor = reservedFor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3ResourceClaimStatus v1alpha3ResourceClaimStatus = (V1alpha3ResourceClaimStatus)o;
        return Objects.equals(this.allocation, v1alpha3ResourceClaimStatus.allocation) && Objects.equals(this.devices, v1alpha3ResourceClaimStatus.devices) && Objects.equals(this.reservedFor, v1alpha3ResourceClaimStatus.reservedFor);
    }

    public int hashCode() {
        return Objects.hash(this.allocation, this.devices, this.reservedFor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3ResourceClaimStatus {\n");
        sb.append("    allocation: ").append(this.toIndentedString(this.allocation)).append("\n");
        sb.append("    devices: ").append(this.toIndentedString(this.devices)).append("\n");
        sb.append("    reservedFor: ").append(this.toIndentedString(this.reservedFor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

