/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DeviceConstraint must have exactly one field set besides Requests.")
public class V1beta1DeviceConstraint {
    public static final String SERIALIZED_NAME_MATCH_ATTRIBUTE = "matchAttribute";
    @SerializedName(value="matchAttribute")
    private String matchAttribute;
    public static final String SERIALIZED_NAME_REQUESTS = "requests";
    @SerializedName(value="requests")
    private List<String> requests = null;

    public V1beta1DeviceConstraint matchAttribute(String matchAttribute) {
        this.matchAttribute = matchAttribute;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.  For example, if you specified \"dra.example.com/numa\" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.  Must include the domain qualifier.")
    public String getMatchAttribute() {
        return this.matchAttribute;
    }

    public void setMatchAttribute(String matchAttribute) {
        this.matchAttribute = matchAttribute;
    }

    public V1beta1DeviceConstraint requests(List<String> requests) {
        this.requests = requests;
        return this;
    }

    public V1beta1DeviceConstraint addRequestsItem(String requestsItem) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        this.requests.add(requestsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.  References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the constraint applies to all subrequests.")
    public List<String> getRequests() {
        return this.requests;
    }

    public void setRequests(List<String> requests) {
        this.requests = requests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1DeviceConstraint v1beta1DeviceConstraint = (V1beta1DeviceConstraint)o;
        return Objects.equals(this.matchAttribute, v1beta1DeviceConstraint.matchAttribute) && Objects.equals(this.requests, v1beta1DeviceConstraint.requests);
    }

    public int hashCode() {
        return Objects.hash(this.matchAttribute, this.requests);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1DeviceConstraint {\n");
        sb.append("    matchAttribute: ").append(this.toIndentedString(this.matchAttribute)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

