/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ModifyVolumeStatus represents the status object of ControllerModifyVolume operation")
public class V1ModifyVolumeStatus {
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    @Nonnull
    private String status;
    public static final String SERIALIZED_NAME_TARGET_VOLUME_ATTRIBUTES_CLASS_NAME = "targetVolumeAttributesClassName";
    @SerializedName(value="targetVolumeAttributesClassName")
    @Nullable
    private String targetVolumeAttributesClassName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ModifyVolumeStatus status(@Nonnull String status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="status is the status of the ControllerModifyVolume operation. It can be in any of following states:  - Pending    Pending indicates that the PersistentVolumeClaim cannot be modified due to unmet requirements, such as    the specified VolumeAttributesClass not existing.  - InProgress    InProgress indicates that the volume is being modified.  - Infeasible   Infeasible indicates that the request has been rejected as invalid by the CSI driver. To    resolve the error, a valid VolumeAttributesClass needs to be specified. Note: New statuses can be added in the future. Consumers should check for unknown statuses and fail appropriately.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(@Nonnull String status) {
        this.status = status;
    }

    public V1ModifyVolumeStatus targetVolumeAttributesClassName(@Nullable String targetVolumeAttributesClassName) {
        this.targetVolumeAttributesClassName = targetVolumeAttributesClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="targetVolumeAttributesClassName is the name of the VolumeAttributesClass the PVC currently being reconciled")
    public String getTargetVolumeAttributesClassName() {
        return this.targetVolumeAttributesClassName;
    }

    public void setTargetVolumeAttributesClassName(@Nullable String targetVolumeAttributesClassName) {
        this.targetVolumeAttributesClassName = targetVolumeAttributesClassName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ModifyVolumeStatus v1ModifyVolumeStatus = (V1ModifyVolumeStatus)o;
        return Objects.equals(this.status, v1ModifyVolumeStatus.status) && Objects.equals(this.targetVolumeAttributesClassName, v1ModifyVolumeStatus.targetVolumeAttributesClassName);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.targetVolumeAttributesClassName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ModifyVolumeStatus {\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    targetVolumeAttributesClassName: ").append(this.toIndentedString(this.targetVolumeAttributesClassName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ModifyVolumeStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ModifyVolumeStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGET_VOLUME_ATTRIBUTES_CLASS_NAME) != null && !jsonObj.get(SERIALIZED_NAME_TARGET_VOLUME_ATTRIBUTES_CLASS_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TARGET_VOLUME_ATTRIBUTES_CLASS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `targetVolumeAttributesClassName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TARGET_VOLUME_ATTRIBUTES_CLASS_NAME).toString()));
        }
    }

    public static V1ModifyVolumeStatus fromJson(String jsonString) throws IOException {
        return (V1ModifyVolumeStatus)JSON.getGson().fromJson(jsonString, V1ModifyVolumeStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TARGET_VOLUME_ATTRIBUTES_CLASS_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ModifyVolumeStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ModifyVolumeStatus.class));
            return new TypeAdapter<V1ModifyVolumeStatus>(){

                public void write(JsonWriter out, V1ModifyVolumeStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ModifyVolumeStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ModifyVolumeStatus.validateJsonElement(jsonElement);
                    return (V1ModifyVolumeStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

