/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1beta2DeviceAttribute;
import io.kubernetes.client.openapi.models.V1beta2DeviceCapacity;
import io.kubernetes.client.openapi.models.V1beta2DeviceCounterConsumption;
import io.kubernetes.client.openapi.models.V1beta2DeviceTaint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.")
public class V1beta2Device {
    public static final String SERIALIZED_NAME_ALL_NODES = "allNodes";
    @SerializedName(value="allNodes")
    @Nullable
    private Boolean allNodes;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    @Nullable
    private Map<String, V1beta2DeviceAttribute> attributes = new HashMap<String, V1beta2DeviceAttribute>();
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    @Nullable
    private Map<String, V1beta2DeviceCapacity> capacity = new HashMap<String, V1beta2DeviceCapacity>();
    public static final String SERIALIZED_NAME_CONSUMES_COUNTERS = "consumesCounters";
    @SerializedName(value="consumesCounters")
    @Nullable
    private List<V1beta2DeviceCounterConsumption> consumesCounters = new ArrayList<V1beta2DeviceCounterConsumption>();
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_NODE_NAME = "nodeName";
    @SerializedName(value="nodeName")
    @Nullable
    private String nodeName;
    public static final String SERIALIZED_NAME_NODE_SELECTOR = "nodeSelector";
    @SerializedName(value="nodeSelector")
    @Nullable
    private V1NodeSelector nodeSelector;
    public static final String SERIALIZED_NAME_TAINTS = "taints";
    @SerializedName(value="taints")
    @Nullable
    private List<V1beta2DeviceTaint> taints = new ArrayList<V1beta2DeviceTaint>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta2Device allNodes(@Nullable Boolean allNodes) {
        this.allNodes = allNodes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllNodes indicates that all nodes have access to the device.  Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.")
    public Boolean getAllNodes() {
        return this.allNodes;
    }

    public void setAllNodes(@Nullable Boolean allNodes) {
        this.allNodes = allNodes;
    }

    public V1beta2Device attributes(@Nullable Map<String, V1beta2DeviceAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public V1beta2Device putAttributesItem(String key, V1beta2DeviceAttribute attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, V1beta2DeviceAttribute>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.  The maximum number of attributes and capacities combined is 32.")
    public Map<String, V1beta2DeviceAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(@Nullable Map<String, V1beta2DeviceAttribute> attributes) {
        this.attributes = attributes;
    }

    public V1beta2Device capacity(@Nullable Map<String, V1beta2DeviceCapacity> capacity) {
        this.capacity = capacity;
        return this;
    }

    public V1beta2Device putCapacityItem(String key, V1beta2DeviceCapacity capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, V1beta2DeviceCapacity>();
        }
        this.capacity.put(key, capacityItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.  The maximum number of attributes and capacities combined is 32.")
    public Map<String, V1beta2DeviceCapacity> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(@Nullable Map<String, V1beta2DeviceCapacity> capacity) {
        this.capacity = capacity;
    }

    public V1beta2Device consumesCounters(@Nullable List<V1beta2DeviceCounterConsumption> consumesCounters) {
        this.consumesCounters = consumesCounters;
        return this;
    }

    public V1beta2Device addConsumesCountersItem(V1beta2DeviceCounterConsumption consumesCountersItem) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList<V1beta2DeviceCounterConsumption>();
        }
        this.consumesCounters.add(consumesCountersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ConsumesCounters defines a list of references to sharedCounters and the set of counters that the device will consume from those counter sets.  There can only be a single entry per counterSet.  The total number of device counter consumption entries must be <= 32. In addition, the total number in the entire ResourceSlice must be <= 1024 (for example, 64 devices with 16 counters each).")
    public List<V1beta2DeviceCounterConsumption> getConsumesCounters() {
        return this.consumesCounters;
    }

    public void setConsumesCounters(@Nullable List<V1beta2DeviceCounterConsumption> consumesCounters) {
        this.consumesCounters = consumesCounters;
    }

    public V1beta2Device name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public V1beta2Device nodeName(@Nullable String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NodeName identifies the node where the device is available.  Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(@Nullable String nodeName) {
        this.nodeName = nodeName;
    }

    public V1beta2Device nodeSelector(@Nullable V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(@Nullable V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public V1beta2Device taints(@Nullable List<V1beta2DeviceTaint> taints) {
        this.taints = taints;
        return this;
    }

    public V1beta2Device addTaintsItem(V1beta2DeviceTaint taintsItem) {
        if (this.taints == null) {
            this.taints = new ArrayList<V1beta2DeviceTaint>();
        }
        this.taints.add(taintsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, these are the driver-defined taints.  The maximum number of taints is 4.  This is an alpha field and requires enabling the DRADeviceTaints feature gate.")
    public List<V1beta2DeviceTaint> getTaints() {
        return this.taints;
    }

    public void setTaints(@Nullable List<V1beta2DeviceTaint> taints) {
        this.taints = taints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2Device v1beta2Device = (V1beta2Device)o;
        return Objects.equals(this.allNodes, v1beta2Device.allNodes) && Objects.equals(this.attributes, v1beta2Device.attributes) && Objects.equals(this.capacity, v1beta2Device.capacity) && Objects.equals(this.consumesCounters, v1beta2Device.consumesCounters) && Objects.equals(this.name, v1beta2Device.name) && Objects.equals(this.nodeName, v1beta2Device.nodeName) && Objects.equals(this.nodeSelector, v1beta2Device.nodeSelector) && Objects.equals(this.taints, v1beta2Device.taints);
    }

    public int hashCode() {
        return Objects.hash(this.allNodes, this.attributes, this.capacity, this.consumesCounters, this.name, this.nodeName, this.nodeSelector, this.taints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2Device {\n");
        sb.append("    allNodes: ").append(this.toIndentedString(this.allNodes)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    consumesCounters: ").append(this.toIndentedString(this.consumesCounters)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("    taints: ").append(this.toIndentedString(this.taints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraytaints;
        int i;
        JsonArray jsonArrayconsumesCounters;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta2Device is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta2Device` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONSUMES_COUNTERS) != null && !jsonObj.get(SERIALIZED_NAME_CONSUMES_COUNTERS).isJsonNull() && (jsonArrayconsumesCounters = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONSUMES_COUNTERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONSUMES_COUNTERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `consumesCounters` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONSUMES_COUNTERS).toString()));
            }
            for (i = 0; i < jsonArrayconsumesCounters.size(); ++i) {
                V1beta2DeviceCounterConsumption.validateJsonElement(jsonArrayconsumesCounters.get(i));
            }
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NODE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NODE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `nodeName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NODE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_NODE_SELECTOR).isJsonNull()) {
            V1NodeSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NODE_SELECTOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAINTS) != null && !jsonObj.get(SERIALIZED_NAME_TAINTS).isJsonNull() && (jsonArraytaints = jsonObj.getAsJsonArray(SERIALIZED_NAME_TAINTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TAINTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `taints` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAINTS).toString()));
            }
            for (i = 0; i < jsonArraytaints.size(); ++i) {
                V1beta2DeviceTaint.validateJsonElement(jsonArraytaints.get(i));
            }
        }
    }

    public static V1beta2Device fromJson(String jsonString) throws IOException {
        return (V1beta2Device)JSON.getGson().fromJson(jsonString, V1beta2Device.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALL_NODES);
        openapiFields.add(SERIALIZED_NAME_ATTRIBUTES);
        openapiFields.add(SERIALIZED_NAME_CAPACITY);
        openapiFields.add(SERIALIZED_NAME_CONSUMES_COUNTERS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NODE_NAME);
        openapiFields.add(SERIALIZED_NAME_NODE_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_TAINTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta2Device.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta2Device.class));
            return new TypeAdapter<V1beta2Device>(){

                public void write(JsonWriter out, V1beta2Device value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta2Device read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta2Device.validateJsonElement(jsonElement);
                    return (V1beta2Device)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

