/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1Counter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="DeviceCounterConsumption defines a set of counters that a device will consume from a CounterSet.")
public class V1DeviceCounterConsumption {
    public static final String SERIALIZED_NAME_COUNTER_SET = "counterSet";
    @SerializedName(value="counterSet")
    private String counterSet;
    public static final String SERIALIZED_NAME_COUNTERS = "counters";
    @SerializedName(value="counters")
    private Map<String, V1Counter> counters = new HashMap<String, V1Counter>();

    public V1DeviceCounterConsumption counterSet(String counterSet) {
        this.counterSet = counterSet;
        return this;
    }

    @ApiModelProperty(required=true, value="CounterSet is the name of the set from which the counters defined will be consumed.")
    public String getCounterSet() {
        return this.counterSet;
    }

    public void setCounterSet(String counterSet) {
        this.counterSet = counterSet;
    }

    public V1DeviceCounterConsumption counters(Map<String, V1Counter> counters) {
        this.counters = counters;
        return this;
    }

    public V1DeviceCounterConsumption putCountersItem(String key, V1Counter countersItem) {
        this.counters.put(key, countersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Counters defines the counters that will be consumed by the device.  The maximum number counters in a device is 32. In addition, the maximum number of all counters in all devices is 1024 (for example, 64 devices with 16 counters each).")
    public Map<String, V1Counter> getCounters() {
        return this.counters;
    }

    public void setCounters(Map<String, V1Counter> counters) {
        this.counters = counters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1DeviceCounterConsumption v1DeviceCounterConsumption = (V1DeviceCounterConsumption)o;
        return Objects.equals(this.counterSet, v1DeviceCounterConsumption.counterSet) && Objects.equals(this.counters, v1DeviceCounterConsumption.counters);
    }

    public int hashCode() {
        return Objects.hash(this.counterSet, this.counters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1DeviceCounterConsumption {\n");
        sb.append("    counterSet: ").append(this.toIndentedString(this.counterSet)).append("\n");
        sb.append("    counters: ").append(this.toIndentedString(this.counters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

