/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ContainerExtendedResourceRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="PodExtendedResourceClaimStatus is stored in the PodStatus for the extended resource requests backed by DRA. It stores the generated name for the corresponding special ResourceClaim created by the scheduler.")
public class V1PodExtendedResourceClaimStatus {
    public static final String SERIALIZED_NAME_REQUEST_MAPPINGS = "requestMappings";
    @SerializedName(value="requestMappings")
    private List<V1ContainerExtendedResourceRequest> requestMappings = new ArrayList<V1ContainerExtendedResourceRequest>();
    public static final String SERIALIZED_NAME_RESOURCE_CLAIM_NAME = "resourceClaimName";
    @SerializedName(value="resourceClaimName")
    private String resourceClaimName;

    public V1PodExtendedResourceClaimStatus requestMappings(List<V1ContainerExtendedResourceRequest> requestMappings) {
        this.requestMappings = requestMappings;
        return this;
    }

    public V1PodExtendedResourceClaimStatus addRequestMappingsItem(V1ContainerExtendedResourceRequest requestMappingsItem) {
        this.requestMappings.add(requestMappingsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="RequestMappings identifies the mapping of <container, extended resource backed by DRA> to  device request in the generated ResourceClaim.")
    public List<V1ContainerExtendedResourceRequest> getRequestMappings() {
        return this.requestMappings;
    }

    public void setRequestMappings(List<V1ContainerExtendedResourceRequest> requestMappings) {
        this.requestMappings = requestMappings;
    }

    public V1PodExtendedResourceClaimStatus resourceClaimName(String resourceClaimName) {
        this.resourceClaimName = resourceClaimName;
        return this;
    }

    @ApiModelProperty(required=true, value="ResourceClaimName is the name of the ResourceClaim that was generated for the Pod in the namespace of the Pod.")
    public String getResourceClaimName() {
        return this.resourceClaimName;
    }

    public void setResourceClaimName(String resourceClaimName) {
        this.resourceClaimName = resourceClaimName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodExtendedResourceClaimStatus v1PodExtendedResourceClaimStatus = (V1PodExtendedResourceClaimStatus)o;
        return Objects.equals(this.requestMappings, v1PodExtendedResourceClaimStatus.requestMappings) && Objects.equals(this.resourceClaimName, v1PodExtendedResourceClaimStatus.resourceClaimName);
    }

    public int hashCode() {
        return Objects.hash(this.requestMappings, this.resourceClaimName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodExtendedResourceClaimStatus {\n");
        sb.append("    requestMappings: ").append(this.toIndentedString(this.requestMappings)).append("\n");
        sb.append("    resourceClaimName: ").append(this.toIndentedString(this.resourceClaimName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

