/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceHealth represents the health of a resource. It has the latest device health information. This is a part of KEP https://kep.k8s.io/4680.")
public class V1ResourceHealth {
    public static final String SERIALIZED_NAME_HEALTH = "health";
    @SerializedName(value="health")
    private String health;
    public static final String SERIALIZED_NAME_RESOURCE_I_D = "resourceID";
    @SerializedName(value="resourceID")
    private String resourceID;

    public V1ResourceHealth health(String health) {
        this.health = health;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Health of the resource. can be one of:  - Healthy: operates as normal  - Unhealthy: reported unhealthy. We consider this a temporary health issue               since we do not have a mechanism today to distinguish               temporary and permanent issues.  - Unknown: The status cannot be determined.             For example, Device Plugin got unregistered and hasn't been re-registered since.  In future we may want to introduce the PermanentlyUnhealthy Status.")
    public String getHealth() {
        return this.health;
    }

    public void setHealth(String health) {
        this.health = health;
    }

    public V1ResourceHealth resourceID(String resourceID) {
        this.resourceID = resourceID;
        return this;
    }

    @ApiModelProperty(required=true, value="ResourceID is the unique identifier of the resource. See the ResourceID type for more information.")
    public String getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceHealth v1ResourceHealth = (V1ResourceHealth)o;
        return Objects.equals(this.health, v1ResourceHealth.health) && Objects.equals(this.resourceID, v1ResourceHealth.resourceID);
    }

    public int hashCode() {
        return Objects.hash(this.health, this.resourceID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceHealth {\n");
        sb.append("    health: ").append(this.toIndentedString(this.health)).append("\n");
        sb.append("    resourceID: ").append(this.toIndentedString(this.resourceID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

