/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node. This API is deprecated since 1.22: https://git.k8s.io/enhancements/keps/sig-node/281-dynamic-kubelet-configuration")
public class V1ConfigMapNodeConfigSource {
    public static final String SERIALIZED_NAME_KUBELET_CONFIG_KEY = "kubeletConfigKey";
    @SerializedName(value="kubeletConfigKey")
    @Nonnull
    private String kubeletConfigKey;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    @Nonnull
    private String namespace;
    public static final String SERIALIZED_NAME_RESOURCE_VERSION = "resourceVersion";
    @SerializedName(value="resourceVersion")
    @Nullable
    private String resourceVersion;
    public static final String SERIALIZED_NAME_UID = "uid";
    @SerializedName(value="uid")
    @Nullable
    private String uid;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ConfigMapNodeConfigSource kubeletConfigKey(@Nonnull String kubeletConfigKey) {
        this.kubeletConfigKey = kubeletConfigKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.")
    public String getKubeletConfigKey() {
        return this.kubeletConfigKey;
    }

    public void setKubeletConfigKey(@Nonnull String kubeletConfigKey) {
        this.kubeletConfigKey = kubeletConfigKey;
    }

    public V1ConfigMapNodeConfigSource name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public V1ConfigMapNodeConfigSource namespace(@Nonnull String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(@Nonnull String namespace) {
        this.namespace = namespace;
    }

    public V1ConfigMapNodeConfigSource resourceVersion(@Nullable String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.")
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(@Nullable String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public V1ConfigMapNodeConfigSource uid(@Nullable String uid) {
        this.uid = uid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.")
    public String getUid() {
        return this.uid;
    }

    public void setUid(@Nullable String uid) {
        this.uid = uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ConfigMapNodeConfigSource v1ConfigMapNodeConfigSource = (V1ConfigMapNodeConfigSource)o;
        return Objects.equals(this.kubeletConfigKey, v1ConfigMapNodeConfigSource.kubeletConfigKey) && Objects.equals(this.name, v1ConfigMapNodeConfigSource.name) && Objects.equals(this.namespace, v1ConfigMapNodeConfigSource.namespace) && Objects.equals(this.resourceVersion, v1ConfigMapNodeConfigSource.resourceVersion) && Objects.equals(this.uid, v1ConfigMapNodeConfigSource.uid);
    }

    public int hashCode() {
        return Objects.hash(this.kubeletConfigKey, this.name, this.namespace, this.resourceVersion, this.uid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ConfigMapNodeConfigSource {\n");
        sb.append("    kubeletConfigKey: ").append(this.toIndentedString(this.kubeletConfigKey)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    resourceVersion: ").append(this.toIndentedString(this.resourceVersion)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ConfigMapNodeConfigSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ConfigMapNodeConfigSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_KUBELET_CONFIG_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kubeletConfigKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KUBELET_CONFIG_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCE_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UID) != null && !jsonObj.get(SERIALIZED_NAME_UID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UID).toString()));
        }
    }

    public static V1ConfigMapNodeConfigSource fromJson(String jsonString) throws IOException {
        return (V1ConfigMapNodeConfigSource)JSON.getGson().fromJson(jsonString, V1ConfigMapNodeConfigSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_KUBELET_CONFIG_KEY);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_VERSION);
        openapiFields.add(SERIALIZED_NAME_UID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_KUBELET_CONFIG_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_NAMESPACE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ConfigMapNodeConfigSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ConfigMapNodeConfigSource.class));
            return new TypeAdapter<V1ConfigMapNodeConfigSource>(){

                public void write(JsonWriter out, V1ConfigMapNodeConfigSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ConfigMapNodeConfigSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ConfigMapNodeConfigSource.validateJsonElement(jsonElement);
                    return (V1ConfigMapNodeConfigSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

