/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ContainerRestartRuleOnExitCodes;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ContainerRestartRule describes how a container exit is handled.")
public class V1ContainerRestartRule {
    public static final String SERIALIZED_NAME_ACTION = "action";
    @SerializedName(value="action")
    @Nonnull
    private String action;
    public static final String SERIALIZED_NAME_EXIT_CODES = "exitCodes";
    @SerializedName(value="exitCodes")
    @Nullable
    private V1ContainerRestartRuleOnExitCodes exitCodes;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ContainerRestartRule action(@Nonnull String action) {
        this.action = action;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Specifies the action taken on a container exit if the requirements are satisfied. The only possible value is \"Restart\" to restart the container.")
    public String getAction() {
        return this.action;
    }

    public void setAction(@Nonnull String action) {
        this.action = action;
    }

    public V1ContainerRestartRule exitCodes(@Nullable V1ContainerRestartRuleOnExitCodes exitCodes) {
        this.exitCodes = exitCodes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ContainerRestartRuleOnExitCodes getExitCodes() {
        return this.exitCodes;
    }

    public void setExitCodes(@Nullable V1ContainerRestartRuleOnExitCodes exitCodes) {
        this.exitCodes = exitCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerRestartRule v1ContainerRestartRule = (V1ContainerRestartRule)o;
        return Objects.equals(this.action, v1ContainerRestartRule.action) && Objects.equals(this.exitCodes, v1ContainerRestartRule.exitCodes);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.exitCodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ContainerRestartRule {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    exitCodes: ").append(this.toIndentedString(this.exitCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ContainerRestartRule is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ContainerRestartRule` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ACTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `action` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXIT_CODES) != null && !jsonObj.get(SERIALIZED_NAME_EXIT_CODES).isJsonNull()) {
            V1ContainerRestartRuleOnExitCodes.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EXIT_CODES));
        }
    }

    public static V1ContainerRestartRule fromJson(String jsonString) throws IOException {
        return (V1ContainerRestartRule)JSON.getGson().fromJson(jsonString, V1ContainerRestartRule.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTION);
        openapiFields.add(SERIALIZED_NAME_EXIT_CODES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACTION);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ContainerRestartRule.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ContainerRestartRule.class));
            return new TypeAdapter<V1ContainerRestartRule>(){

                public void write(JsonWriter out, V1ContainerRestartRule value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ContainerRestartRule read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ContainerRestartRule.validateJsonElement(jsonElement);
                    return (V1ContainerRestartRule)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

