/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ContainerState;
import io.kubernetes.client.openapi.models.V1ContainerUser;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1ResourceStatus;
import io.kubernetes.client.openapi.models.V1VolumeMountStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ContainerStatus contains details for the current status of this container.")
public class V1ContainerStatus {
    public static final String SERIALIZED_NAME_ALLOCATED_RESOURCES = "allocatedResources";
    @SerializedName(value="allocatedResources")
    @Nullable
    private Map<String, Quantity> allocatedResources = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_ALLOCATED_RESOURCES_STATUS = "allocatedResourcesStatus";
    @SerializedName(value="allocatedResourcesStatus")
    @Nullable
    private List<V1ResourceStatus> allocatedResourcesStatus = new ArrayList<V1ResourceStatus>();
    public static final String SERIALIZED_NAME_CONTAINER_I_D = "containerID";
    @SerializedName(value="containerID")
    @Nullable
    private String containerID;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    @Nonnull
    private String image;
    public static final String SERIALIZED_NAME_IMAGE_I_D = "imageID";
    @SerializedName(value="imageID")
    @Nonnull
    private String imageID;
    public static final String SERIALIZED_NAME_LAST_STATE = "lastState";
    @SerializedName(value="lastState")
    @Nullable
    private V1ContainerState lastState;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_READY = "ready";
    @SerializedName(value="ready")
    @Nonnull
    private Boolean ready;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    @Nullable
    private V1ResourceRequirements resources;
    public static final String SERIALIZED_NAME_RESTART_COUNT = "restartCount";
    @SerializedName(value="restartCount")
    @Nonnull
    private Integer restartCount;
    public static final String SERIALIZED_NAME_STARTED = "started";
    @SerializedName(value="started")
    @Nullable
    private Boolean started;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    @Nullable
    private V1ContainerState state;
    public static final String SERIALIZED_NAME_STOP_SIGNAL = "stopSignal";
    @SerializedName(value="stopSignal")
    @Nullable
    private String stopSignal;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    @Nullable
    private V1ContainerUser user;
    public static final String SERIALIZED_NAME_VOLUME_MOUNTS = "volumeMounts";
    @SerializedName(value="volumeMounts")
    @Nullable
    private List<V1VolumeMountStatus> volumeMounts = new ArrayList<V1VolumeMountStatus>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ContainerStatus allocatedResources(@Nullable Map<String, Quantity> allocatedResources) {
        this.allocatedResources = allocatedResources;
        return this;
    }

    public V1ContainerStatus putAllocatedResourcesItem(String key, Quantity allocatedResourcesItem) {
        if (this.allocatedResources == null) {
            this.allocatedResources = new HashMap<String, Quantity>();
        }
        this.allocatedResources.put(key, allocatedResourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllocatedResources represents the compute resources allocated for this container by the node. Kubelet sets this value to Container.Resources.Requests upon successful pod admission and after successfully admitting desired pod resize.")
    public Map<String, Quantity> getAllocatedResources() {
        return this.allocatedResources;
    }

    public void setAllocatedResources(@Nullable Map<String, Quantity> allocatedResources) {
        this.allocatedResources = allocatedResources;
    }

    public V1ContainerStatus allocatedResourcesStatus(@Nullable List<V1ResourceStatus> allocatedResourcesStatus) {
        this.allocatedResourcesStatus = allocatedResourcesStatus;
        return this;
    }

    public V1ContainerStatus addAllocatedResourcesStatusItem(V1ResourceStatus allocatedResourcesStatusItem) {
        if (this.allocatedResourcesStatus == null) {
            this.allocatedResourcesStatus = new ArrayList<V1ResourceStatus>();
        }
        this.allocatedResourcesStatus.add(allocatedResourcesStatusItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllocatedResourcesStatus represents the status of various resources allocated for this Pod.")
    public List<V1ResourceStatus> getAllocatedResourcesStatus() {
        return this.allocatedResourcesStatus;
    }

    public void setAllocatedResourcesStatus(@Nullable List<V1ResourceStatus> allocatedResourcesStatus) {
        this.allocatedResourcesStatus = allocatedResourcesStatus;
    }

    public V1ContainerStatus containerID(@Nullable String containerID) {
        this.containerID = containerID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ContainerID is the ID of the container in the format '<type>://<container_id>'. Where type is a container runtime identifier, returned from Version call of CRI API (for example \"containerd\").")
    public String getContainerID() {
        return this.containerID;
    }

    public void setContainerID(@Nullable String containerID) {
        this.containerID = containerID;
    }

    public V1ContainerStatus image(@Nonnull String image) {
        this.image = image;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Image is the name of container image that the container is running. The container image may not match the image used in the PodSpec, as it may have been resolved by the runtime. More info: https://kubernetes.io/docs/concepts/containers/images.")
    public String getImage() {
        return this.image;
    }

    public void setImage(@Nonnull String image) {
        this.image = image;
    }

    public V1ContainerStatus imageID(@Nonnull String imageID) {
        this.imageID = imageID;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ImageID is the image ID of the container's image. The image ID may not match the image ID of the image used in the PodSpec, as it may have been resolved by the runtime.")
    public String getImageID() {
        return this.imageID;
    }

    public void setImageID(@Nonnull String imageID) {
        this.imageID = imageID;
    }

    public V1ContainerStatus lastState(@Nullable V1ContainerState lastState) {
        this.lastState = lastState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ContainerState getLastState() {
        return this.lastState;
    }

    public void setLastState(@Nullable V1ContainerState lastState) {
        this.lastState = lastState;
    }

    public V1ContainerStatus name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name is a DNS_LABEL representing the unique name of the container. Each container in a pod must have a unique name across all container types. Cannot be updated.")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public V1ContainerStatus ready(@Nonnull Boolean ready) {
        this.ready = ready;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Ready specifies whether the container is currently passing its readiness check. The value will change as readiness probes keep executing. If no readiness probes are specified, this field defaults to true once the container is fully started (see Started field).  The value is typically used to determine whether a container is ready to accept traffic.")
    public Boolean getReady() {
        return this.ready;
    }

    public void setReady(@Nonnull Boolean ready) {
        this.ready = ready;
    }

    public V1ContainerStatus resources(@Nullable V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(@Nullable V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public V1ContainerStatus restartCount(@Nonnull Integer restartCount) {
        this.restartCount = restartCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="RestartCount holds the number of times the container has been restarted. Kubelet makes an effort to always increment the value, but there are cases when the state may be lost due to node restarts and then the value may be reset to 0. The value is never negative.")
    public Integer getRestartCount() {
        return this.restartCount;
    }

    public void setRestartCount(@Nonnull Integer restartCount) {
        this.restartCount = restartCount;
    }

    public V1ContainerStatus started(@Nullable Boolean started) {
        this.started = started;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Started indicates whether the container has finished its postStart lifecycle hook and passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. In both cases, startup probes will run again. Is always true when no startupProbe is defined and container is running and has passed the postStart lifecycle hook. The null value must be treated the same as false.")
    public Boolean getStarted() {
        return this.started;
    }

    public void setStarted(@Nullable Boolean started) {
        this.started = started;
    }

    public V1ContainerStatus state(@Nullable V1ContainerState state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ContainerState getState() {
        return this.state;
    }

    public void setState(@Nullable V1ContainerState state) {
        this.state = state;
    }

    public V1ContainerStatus stopSignal(@Nullable String stopSignal) {
        this.stopSignal = stopSignal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="StopSignal reports the effective stop signal for this container")
    public String getStopSignal() {
        return this.stopSignal;
    }

    public void setStopSignal(@Nullable String stopSignal) {
        this.stopSignal = stopSignal;
    }

    public V1ContainerStatus user(@Nullable V1ContainerUser user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ContainerUser getUser() {
        return this.user;
    }

    public void setUser(@Nullable V1ContainerUser user) {
        this.user = user;
    }

    public V1ContainerStatus volumeMounts(@Nullable List<V1VolumeMountStatus> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public V1ContainerStatus addVolumeMountsItem(V1VolumeMountStatus volumeMountsItem) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<V1VolumeMountStatus>();
        }
        this.volumeMounts.add(volumeMountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Status of volume mounts.")
    public List<V1VolumeMountStatus> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(@Nullable List<V1VolumeMountStatus> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerStatus v1ContainerStatus = (V1ContainerStatus)o;
        return Objects.equals(this.allocatedResources, v1ContainerStatus.allocatedResources) && Objects.equals(this.allocatedResourcesStatus, v1ContainerStatus.allocatedResourcesStatus) && Objects.equals(this.containerID, v1ContainerStatus.containerID) && Objects.equals(this.image, v1ContainerStatus.image) && Objects.equals(this.imageID, v1ContainerStatus.imageID) && Objects.equals(this.lastState, v1ContainerStatus.lastState) && Objects.equals(this.name, v1ContainerStatus.name) && Objects.equals(this.ready, v1ContainerStatus.ready) && Objects.equals(this.resources, v1ContainerStatus.resources) && Objects.equals(this.restartCount, v1ContainerStatus.restartCount) && Objects.equals(this.started, v1ContainerStatus.started) && Objects.equals(this.state, v1ContainerStatus.state) && Objects.equals(this.stopSignal, v1ContainerStatus.stopSignal) && Objects.equals(this.user, v1ContainerStatus.user) && Objects.equals(this.volumeMounts, v1ContainerStatus.volumeMounts);
    }

    public int hashCode() {
        return Objects.hash(this.allocatedResources, this.allocatedResourcesStatus, this.containerID, this.image, this.imageID, this.lastState, this.name, this.ready, this.resources, this.restartCount, this.started, this.state, this.stopSignal, this.user, this.volumeMounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ContainerStatus {\n");
        sb.append("    allocatedResources: ").append(this.toIndentedString(this.allocatedResources)).append("\n");
        sb.append("    allocatedResourcesStatus: ").append(this.toIndentedString(this.allocatedResourcesStatus)).append("\n");
        sb.append("    containerID: ").append(this.toIndentedString(this.containerID)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    imageID: ").append(this.toIndentedString(this.imageID)).append("\n");
        sb.append("    lastState: ").append(this.toIndentedString(this.lastState)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ready: ").append(this.toIndentedString(this.ready)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    restartCount: ").append(this.toIndentedString(this.restartCount)).append("\n");
        sb.append("    started: ").append(this.toIndentedString(this.started)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    stopSignal: ").append(this.toIndentedString(this.stopSignal)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    volumeMounts: ").append(this.toIndentedString(this.volumeMounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayvolumeMounts;
        int i;
        JsonArray jsonArrayallocatedResourcesStatus;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ContainerStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ContainerStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ALLOCATED_RESOURCES_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_ALLOCATED_RESOURCES_STATUS).isJsonNull() && (jsonArrayallocatedResourcesStatus = jsonObj.getAsJsonArray(SERIALIZED_NAME_ALLOCATED_RESOURCES_STATUS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ALLOCATED_RESOURCES_STATUS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `allocatedResourcesStatus` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOCATED_RESOURCES_STATUS).toString()));
            }
            for (i = 0; i < jsonArrayallocatedResourcesStatus.size(); ++i) {
                V1ResourceStatus.validateJsonElement(jsonArrayallocatedResourcesStatus.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `containerID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_IMAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_IMAGE_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `imageID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_STATE) != null && !jsonObj.get(SERIALIZED_NAME_LAST_STATE).isJsonNull()) {
            V1ContainerState.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LAST_STATE));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonNull()) {
            V1ResourceRequirements.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCES));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE) != null && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonNull()) {
            V1ContainerState.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATE));
        }
        if (jsonObj.get(SERIALIZED_NAME_STOP_SIGNAL) != null && !jsonObj.get(SERIALIZED_NAME_STOP_SIGNAL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STOP_SIGNAL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `stopSignal` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STOP_SIGNAL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER) != null && !jsonObj.get(SERIALIZED_NAME_USER).isJsonNull()) {
            V1ContainerUser.validateJsonElement(jsonObj.get(SERIALIZED_NAME_USER));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUME_MOUNTS) != null && !jsonObj.get(SERIALIZED_NAME_VOLUME_MOUNTS).isJsonNull() && (jsonArrayvolumeMounts = jsonObj.getAsJsonArray(SERIALIZED_NAME_VOLUME_MOUNTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VOLUME_MOUNTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `volumeMounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_MOUNTS).toString()));
            }
            for (i = 0; i < jsonArrayvolumeMounts.size(); ++i) {
                V1VolumeMountStatus.validateJsonElement(jsonArrayvolumeMounts.get(i));
            }
        }
    }

    public static V1ContainerStatus fromJson(String jsonString) throws IOException {
        return (V1ContainerStatus)JSON.getGson().fromJson(jsonString, V1ContainerStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOCATED_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_ALLOCATED_RESOURCES_STATUS);
        openapiFields.add(SERIALIZED_NAME_CONTAINER_I_D);
        openapiFields.add(SERIALIZED_NAME_IMAGE);
        openapiFields.add(SERIALIZED_NAME_IMAGE_I_D);
        openapiFields.add(SERIALIZED_NAME_LAST_STATE);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_READY);
        openapiFields.add(SERIALIZED_NAME_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_RESTART_COUNT);
        openapiFields.add(SERIALIZED_NAME_STARTED);
        openapiFields.add(SERIALIZED_NAME_STATE);
        openapiFields.add(SERIALIZED_NAME_STOP_SIGNAL);
        openapiFields.add(SERIALIZED_NAME_USER);
        openapiFields.add(SERIALIZED_NAME_VOLUME_MOUNTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_IMAGE);
        openapiRequiredFields.add(SERIALIZED_NAME_IMAGE_I_D);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_READY);
        openapiRequiredFields.add(SERIALIZED_NAME_RESTART_COUNT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ContainerStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ContainerStatus.class));
            return new TypeAdapter<V1ContainerStatus>(){

                public void write(JsonWriter out, V1ContainerStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ContainerStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ContainerStatus.validateJsonElement(jsonElement);
                    return (V1ContainerStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

