/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1VolumeProjection;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Represents a projected volume source")
public class V1ProjectedVolumeSource {
    public static final String SERIALIZED_NAME_DEFAULT_MODE = "defaultMode";
    @SerializedName(value="defaultMode")
    @Nullable
    private Integer defaultMode;
    public static final String SERIALIZED_NAME_SOURCES = "sources";
    @SerializedName(value="sources")
    @Nullable
    private List<V1VolumeProjection> sources = new ArrayList<V1VolumeProjection>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ProjectedVolumeSource defaultMode(@Nullable Integer defaultMode) {
        this.defaultMode = defaultMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="defaultMode are the mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.")
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public void setDefaultMode(@Nullable Integer defaultMode) {
        this.defaultMode = defaultMode;
    }

    public V1ProjectedVolumeSource sources(@Nullable List<V1VolumeProjection> sources) {
        this.sources = sources;
        return this;
    }

    public V1ProjectedVolumeSource addSourcesItem(V1VolumeProjection sourcesItem) {
        if (this.sources == null) {
            this.sources = new ArrayList<V1VolumeProjection>();
        }
        this.sources.add(sourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="sources is the list of volume projections. Each entry in this list handles one source.")
    public List<V1VolumeProjection> getSources() {
        return this.sources;
    }

    public void setSources(@Nullable List<V1VolumeProjection> sources) {
        this.sources = sources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ProjectedVolumeSource v1ProjectedVolumeSource = (V1ProjectedVolumeSource)o;
        return Objects.equals(this.defaultMode, v1ProjectedVolumeSource.defaultMode) && Objects.equals(this.sources, v1ProjectedVolumeSource.sources);
    }

    public int hashCode() {
        return Objects.hash(this.defaultMode, this.sources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ProjectedVolumeSource {\n");
        sb.append("    defaultMode: ").append(this.toIndentedString(this.defaultMode)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraysources;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ProjectedVolumeSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ProjectedVolumeSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_SOURCES) != null && !jsonObj.get(SERIALIZED_NAME_SOURCES).isJsonNull() && (jsonArraysources = jsonObj.getAsJsonArray(SERIALIZED_NAME_SOURCES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SOURCES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `sources` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCES).toString()));
            }
            for (int i = 0; i < jsonArraysources.size(); ++i) {
                V1VolumeProjection.validateJsonElement(jsonArraysources.get(i));
            }
        }
    }

    public static V1ProjectedVolumeSource fromJson(String jsonString) throws IOException {
        return (V1ProjectedVolumeSource)JSON.getGson().fromJson(jsonString, V1ProjectedVolumeSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DEFAULT_MODE);
        openapiFields.add(SERIALIZED_NAME_SOURCES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ProjectedVolumeSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ProjectedVolumeSource.class));
            return new TypeAdapter<V1ProjectedVolumeSource>(){

                public void write(JsonWriter out, V1ProjectedVolumeSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ProjectedVolumeSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ProjectedVolumeSource.validateJsonElement(jsonElement);
                    return (V1ProjectedVolumeSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

