/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ReplicaSetCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ReplicaSetStatus represents the current status of a ReplicaSet.")
public class V1ReplicaSetStatus {
    public static final String SERIALIZED_NAME_AVAILABLE_REPLICAS = "availableReplicas";
    @SerializedName(value="availableReplicas")
    @Nullable
    private Integer availableReplicas;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    @Nullable
    private List<V1ReplicaSetCondition> conditions = new ArrayList<V1ReplicaSetCondition>();
    public static final String SERIALIZED_NAME_FULLY_LABELED_REPLICAS = "fullyLabeledReplicas";
    @SerializedName(value="fullyLabeledReplicas")
    @Nullable
    private Integer fullyLabeledReplicas;
    public static final String SERIALIZED_NAME_OBSERVED_GENERATION = "observedGeneration";
    @SerializedName(value="observedGeneration")
    @Nullable
    private Long observedGeneration;
    public static final String SERIALIZED_NAME_READY_REPLICAS = "readyReplicas";
    @SerializedName(value="readyReplicas")
    @Nullable
    private Integer readyReplicas;
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    @Nonnull
    private Integer replicas;
    public static final String SERIALIZED_NAME_TERMINATING_REPLICAS = "terminatingReplicas";
    @SerializedName(value="terminatingReplicas")
    @Nullable
    private Integer terminatingReplicas;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ReplicaSetStatus availableReplicas(@Nullable Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of available non-terminating pods (ready for at least minReadySeconds) for this replica set.")
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public void setAvailableReplicas(@Nullable Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    public V1ReplicaSetStatus conditions(@Nullable List<V1ReplicaSetCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1ReplicaSetStatus addConditionsItem(V1ReplicaSetCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1ReplicaSetCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the latest available observations of a replica set's current state.")
    public List<V1ReplicaSetCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(@Nullable List<V1ReplicaSetCondition> conditions) {
        this.conditions = conditions;
    }

    public V1ReplicaSetStatus fullyLabeledReplicas(@Nullable Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of non-terminating pods that have labels matching the labels of the pod template of the replicaset.")
    public Integer getFullyLabeledReplicas() {
        return this.fullyLabeledReplicas;
    }

    public void setFullyLabeledReplicas(@Nullable Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
    }

    public V1ReplicaSetStatus observedGeneration(@Nullable Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ObservedGeneration reflects the generation of the most recently observed ReplicaSet.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(@Nullable Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1ReplicaSetStatus readyReplicas(@Nullable Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of non-terminating pods targeted by this ReplicaSet with a Ready Condition.")
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(@Nullable Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public V1ReplicaSetStatus replicas(@Nonnull Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Replicas is the most recently observed number of non-terminating pods. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(@Nonnull Integer replicas) {
        this.replicas = replicas;
    }

    public V1ReplicaSetStatus terminatingReplicas(@Nullable Integer terminatingReplicas) {
        this.terminatingReplicas = terminatingReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of terminating pods for this replica set. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.  This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.")
    public Integer getTerminatingReplicas() {
        return this.terminatingReplicas;
    }

    public void setTerminatingReplicas(@Nullable Integer terminatingReplicas) {
        this.terminatingReplicas = terminatingReplicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ReplicaSetStatus v1ReplicaSetStatus = (V1ReplicaSetStatus)o;
        return Objects.equals(this.availableReplicas, v1ReplicaSetStatus.availableReplicas) && Objects.equals(this.conditions, v1ReplicaSetStatus.conditions) && Objects.equals(this.fullyLabeledReplicas, v1ReplicaSetStatus.fullyLabeledReplicas) && Objects.equals(this.observedGeneration, v1ReplicaSetStatus.observedGeneration) && Objects.equals(this.readyReplicas, v1ReplicaSetStatus.readyReplicas) && Objects.equals(this.replicas, v1ReplicaSetStatus.replicas) && Objects.equals(this.terminatingReplicas, v1ReplicaSetStatus.terminatingReplicas);
    }

    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.conditions, this.fullyLabeledReplicas, this.observedGeneration, this.readyReplicas, this.replicas, this.terminatingReplicas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ReplicaSetStatus {\n");
        sb.append("    availableReplicas: ").append(this.toIndentedString(this.availableReplicas)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    fullyLabeledReplicas: ").append(this.toIndentedString(this.fullyLabeledReplicas)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    readyReplicas: ").append(this.toIndentedString(this.readyReplicas)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    terminatingReplicas: ").append(this.toIndentedString(this.terminatingReplicas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayconditions;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ReplicaSetStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ReplicaSetStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull() && (jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (int i = 0; i < jsonArrayconditions.size(); ++i) {
                V1ReplicaSetCondition.validateJsonElement(jsonArrayconditions.get(i));
            }
        }
    }

    public static V1ReplicaSetStatus fromJson(String jsonString) throws IOException {
        return (V1ReplicaSetStatus)JSON.getGson().fromJson(jsonString, V1ReplicaSetStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AVAILABLE_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_FULLY_LABELED_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_OBSERVED_GENERATION);
        openapiFields.add(SERIALIZED_NAME_READY_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_TERMINATING_REPLICAS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_REPLICAS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ReplicaSetStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ReplicaSetStatus.class));
            return new TypeAdapter<V1ReplicaSetStatus>(){

                public void write(JsonWriter out, V1ReplicaSetStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ReplicaSetStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ReplicaSetStatus.validateJsonElement(jsonElement);
                    return (V1ReplicaSetStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

