/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PodCertificateRequestSpec describes the certificate request.  All fields are immutable after creation.")
public class V1alpha1PodCertificateRequestSpec {
    public static final String SERIALIZED_NAME_MAX_EXPIRATION_SECONDS = "maxExpirationSeconds";
    @SerializedName(value="maxExpirationSeconds")
    @Nullable
    private Integer maxExpirationSeconds;
    public static final String SERIALIZED_NAME_NODE_NAME = "nodeName";
    @SerializedName(value="nodeName")
    @Nonnull
    private String nodeName;
    public static final String SERIALIZED_NAME_NODE_U_I_D = "nodeUID";
    @SerializedName(value="nodeUID")
    @Nonnull
    private String nodeUID;
    public static final String SERIALIZED_NAME_PKIX_PUBLIC_KEY = "pkixPublicKey";
    @SerializedName(value="pkixPublicKey")
    @Nonnull
    private byte[] pkixPublicKey;
    public static final String SERIALIZED_NAME_POD_NAME = "podName";
    @SerializedName(value="podName")
    @Nonnull
    private String podName;
    public static final String SERIALIZED_NAME_POD_U_I_D = "podUID";
    @SerializedName(value="podUID")
    @Nonnull
    private String podUID;
    public static final String SERIALIZED_NAME_PROOF_OF_POSSESSION = "proofOfPossession";
    @SerializedName(value="proofOfPossession")
    @Nonnull
    private byte[] proofOfPossession;
    public static final String SERIALIZED_NAME_SERVICE_ACCOUNT_NAME = "serviceAccountName";
    @SerializedName(value="serviceAccountName")
    @Nonnull
    private String serviceAccountName;
    public static final String SERIALIZED_NAME_SERVICE_ACCOUNT_U_I_D = "serviceAccountUID";
    @SerializedName(value="serviceAccountUID")
    @Nonnull
    private String serviceAccountUID;
    public static final String SERIALIZED_NAME_SIGNER_NAME = "signerName";
    @SerializedName(value="signerName")
    @Nonnull
    private String signerName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha1PodCertificateRequestSpec maxExpirationSeconds(@Nullable Integer maxExpirationSeconds) {
        this.maxExpirationSeconds = maxExpirationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="maxExpirationSeconds is the maximum lifetime permitted for the certificate.  If omitted, kube-apiserver will set it to 86400(24 hours). kube-apiserver will reject values shorter than 3600 (1 hour).  The maximum allowable value is 7862400 (91 days).  The signer implementation is then free to issue a certificate with any lifetime *shorter* than MaxExpirationSeconds, but no shorter than 3600 seconds (1 hour).  This constraint is enforced by kube-apiserver. `kubernetes.io` signers will never issue certificates with a lifetime longer than 24 hours.")
    public Integer getMaxExpirationSeconds() {
        return this.maxExpirationSeconds;
    }

    public void setMaxExpirationSeconds(@Nullable Integer maxExpirationSeconds) {
        this.maxExpirationSeconds = maxExpirationSeconds;
    }

    public V1alpha1PodCertificateRequestSpec nodeName(@Nonnull String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="nodeName is the name of the node the pod is assigned to.")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(@Nonnull String nodeName) {
        this.nodeName = nodeName;
    }

    public V1alpha1PodCertificateRequestSpec nodeUID(@Nonnull String nodeUID) {
        this.nodeUID = nodeUID;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="nodeUID is the UID of the node the pod is assigned to.")
    public String getNodeUID() {
        return this.nodeUID;
    }

    public void setNodeUID(@Nonnull String nodeUID) {
        this.nodeUID = nodeUID;
    }

    public V1alpha1PodCertificateRequestSpec pkixPublicKey(@Nonnull byte[] pkixPublicKey) {
        this.pkixPublicKey = pkixPublicKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="pkixPublicKey is the PKIX-serialized public key the signer will issue the certificate to.  The key must be one of RSA3072, RSA4096, ECDSAP256, ECDSAP384, ECDSAP521, or ED25519. Note that this list may be expanded in the future.  Signer implementations do not need to support all key types supported by kube-apiserver and kubelet.  If a signer does not support the key type used for a given PodCertificateRequest, it must deny the request by setting a status.conditions entry with a type of \"Denied\" and a reason of \"UnsupportedKeyType\". It may also suggest a key type that it does support in the message field.")
    public byte[] getPkixPublicKey() {
        return this.pkixPublicKey;
    }

    public void setPkixPublicKey(@Nonnull byte[] pkixPublicKey) {
        this.pkixPublicKey = pkixPublicKey;
    }

    public V1alpha1PodCertificateRequestSpec podName(@Nonnull String podName) {
        this.podName = podName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="podName is the name of the pod into which the certificate will be mounted.")
    public String getPodName() {
        return this.podName;
    }

    public void setPodName(@Nonnull String podName) {
        this.podName = podName;
    }

    public V1alpha1PodCertificateRequestSpec podUID(@Nonnull String podUID) {
        this.podUID = podUID;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="podUID is the UID of the pod into which the certificate will be mounted.")
    public String getPodUID() {
        return this.podUID;
    }

    public void setPodUID(@Nonnull String podUID) {
        this.podUID = podUID;
    }

    public V1alpha1PodCertificateRequestSpec proofOfPossession(@Nonnull byte[] proofOfPossession) {
        this.proofOfPossession = proofOfPossession;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="proofOfPossession proves that the requesting kubelet holds the private key corresponding to pkixPublicKey.  It is contructed by signing the ASCII bytes of the pod's UID using `pkixPublicKey`.  kube-apiserver validates the proof of possession during creation of the PodCertificateRequest.  If the key is an RSA key, then the signature is over the ASCII bytes of the pod UID, using RSASSA-PSS from RFC 8017 (as implemented by the golang function crypto/rsa.SignPSS with nil options).  If the key is an ECDSA key, then the signature is as described by [SEC 1, Version 2.0](https://www.secg.org/sec1-v2.pdf) (as implemented by the golang library function crypto/ecdsa.SignASN1)  If the key is an ED25519 key, the the signature is as described by the [ED25519 Specification](https://ed25519.cr.yp.to/) (as implemented by the golang library crypto/ed25519.Sign).")
    public byte[] getProofOfPossession() {
        return this.proofOfPossession;
    }

    public void setProofOfPossession(@Nonnull byte[] proofOfPossession) {
        this.proofOfPossession = proofOfPossession;
    }

    public V1alpha1PodCertificateRequestSpec serviceAccountName(@Nonnull String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="serviceAccountName is the name of the service account the pod is running as.")
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public void setServiceAccountName(@Nonnull String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    public V1alpha1PodCertificateRequestSpec serviceAccountUID(@Nonnull String serviceAccountUID) {
        this.serviceAccountUID = serviceAccountUID;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="serviceAccountUID is the UID of the service account the pod is running as.")
    public String getServiceAccountUID() {
        return this.serviceAccountUID;
    }

    public void setServiceAccountUID(@Nonnull String serviceAccountUID) {
        this.serviceAccountUID = serviceAccountUID;
    }

    public V1alpha1PodCertificateRequestSpec signerName(@Nonnull String signerName) {
        this.signerName = signerName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="signerName indicates the requested signer.  All signer names beginning with `kubernetes.io` are reserved for use by the Kubernetes project.  There is currently one well-known signer documented by the Kubernetes project, `kubernetes.io/kube-apiserver-client-pod`, which will issue client certificates understood by kube-apiserver.  It is currently unimplemented.")
    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(@Nonnull String signerName) {
        this.signerName = signerName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1PodCertificateRequestSpec v1alpha1PodCertificateRequestSpec = (V1alpha1PodCertificateRequestSpec)o;
        return Objects.equals(this.maxExpirationSeconds, v1alpha1PodCertificateRequestSpec.maxExpirationSeconds) && Objects.equals(this.nodeName, v1alpha1PodCertificateRequestSpec.nodeName) && Objects.equals(this.nodeUID, v1alpha1PodCertificateRequestSpec.nodeUID) && Arrays.equals(this.pkixPublicKey, v1alpha1PodCertificateRequestSpec.pkixPublicKey) && Objects.equals(this.podName, v1alpha1PodCertificateRequestSpec.podName) && Objects.equals(this.podUID, v1alpha1PodCertificateRequestSpec.podUID) && Arrays.equals(this.proofOfPossession, v1alpha1PodCertificateRequestSpec.proofOfPossession) && Objects.equals(this.serviceAccountName, v1alpha1PodCertificateRequestSpec.serviceAccountName) && Objects.equals(this.serviceAccountUID, v1alpha1PodCertificateRequestSpec.serviceAccountUID) && Objects.equals(this.signerName, v1alpha1PodCertificateRequestSpec.signerName);
    }

    public int hashCode() {
        return Objects.hash(this.maxExpirationSeconds, this.nodeName, this.nodeUID, Arrays.hashCode(this.pkixPublicKey), this.podName, this.podUID, Arrays.hashCode(this.proofOfPossession), this.serviceAccountName, this.serviceAccountUID, this.signerName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1PodCertificateRequestSpec {\n");
        sb.append("    maxExpirationSeconds: ").append(this.toIndentedString(this.maxExpirationSeconds)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    nodeUID: ").append(this.toIndentedString(this.nodeUID)).append("\n");
        sb.append("    pkixPublicKey: ").append(this.toIndentedString(this.pkixPublicKey)).append("\n");
        sb.append("    podName: ").append(this.toIndentedString(this.podName)).append("\n");
        sb.append("    podUID: ").append(this.toIndentedString(this.podUID)).append("\n");
        sb.append("    proofOfPossession: ").append(this.toIndentedString(this.proofOfPossession)).append("\n");
        sb.append("    serviceAccountName: ").append(this.toIndentedString(this.serviceAccountName)).append("\n");
        sb.append("    serviceAccountUID: ").append(this.toIndentedString(this.serviceAccountUID)).append("\n");
        sb.append("    signerName: ").append(this.toIndentedString(this.signerName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha1PodCertificateRequestSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha1PodCertificateRequestSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_NODE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `nodeName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NODE_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NODE_U_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `nodeUID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NODE_U_I_D).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_POD_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `podName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POD_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_POD_U_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `podUID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POD_U_I_D).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SERVICE_ACCOUNT_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `serviceAccountName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERVICE_ACCOUNT_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SERVICE_ACCOUNT_U_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `serviceAccountUID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERVICE_ACCOUNT_U_I_D).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SIGNER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `signerName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIGNER_NAME).toString()));
        }
    }

    public static V1alpha1PodCertificateRequestSpec fromJson(String jsonString) throws IOException {
        return (V1alpha1PodCertificateRequestSpec)JSON.getGson().fromJson(jsonString, V1alpha1PodCertificateRequestSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MAX_EXPIRATION_SECONDS);
        openapiFields.add(SERIALIZED_NAME_NODE_NAME);
        openapiFields.add(SERIALIZED_NAME_NODE_U_I_D);
        openapiFields.add(SERIALIZED_NAME_PKIX_PUBLIC_KEY);
        openapiFields.add(SERIALIZED_NAME_POD_NAME);
        openapiFields.add(SERIALIZED_NAME_POD_U_I_D);
        openapiFields.add(SERIALIZED_NAME_PROOF_OF_POSSESSION);
        openapiFields.add(SERIALIZED_NAME_SERVICE_ACCOUNT_NAME);
        openapiFields.add(SERIALIZED_NAME_SERVICE_ACCOUNT_U_I_D);
        openapiFields.add(SERIALIZED_NAME_SIGNER_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NODE_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_NODE_U_I_D);
        openapiRequiredFields.add(SERIALIZED_NAME_PKIX_PUBLIC_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_POD_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_POD_U_I_D);
        openapiRequiredFields.add(SERIALIZED_NAME_PROOF_OF_POSSESSION);
        openapiRequiredFields.add(SERIALIZED_NAME_SERVICE_ACCOUNT_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_SERVICE_ACCOUNT_U_I_D);
        openapiRequiredFields.add(SERIALIZED_NAME_SIGNER_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha1PodCertificateRequestSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha1PodCertificateRequestSpec.class));
            return new TypeAdapter<V1alpha1PodCertificateRequestSpec>(){

                public void write(JsonWriter out, V1alpha1PodCertificateRequestSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha1PodCertificateRequestSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1alpha1PodCertificateRequestSpec.validateJsonElement(jsonElement);
                    return (V1alpha1PodCertificateRequestSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

