/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1beta1DeviceAllocationResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="AllocationResult contains attributes of an allocated resource.")
public class V1beta1AllocationResult {
    public static final String SERIALIZED_NAME_ALLOCATION_TIMESTAMP = "allocationTimestamp";
    @SerializedName(value="allocationTimestamp")
    @Nullable
    private OffsetDateTime allocationTimestamp;
    public static final String SERIALIZED_NAME_DEVICES = "devices";
    @SerializedName(value="devices")
    @Nullable
    private V1beta1DeviceAllocationResult devices;
    public static final String SERIALIZED_NAME_NODE_SELECTOR = "nodeSelector";
    @SerializedName(value="nodeSelector")
    @Nullable
    private V1NodeSelector nodeSelector;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta1AllocationResult allocationTimestamp(@Nullable OffsetDateTime allocationTimestamp) {
        this.allocationTimestamp = allocationTimestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllocationTimestamp stores the time when the resources were allocated. This field is not guaranteed to be set, in which case that time is unknown.  This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus feature gate.")
    public OffsetDateTime getAllocationTimestamp() {
        return this.allocationTimestamp;
    }

    public void setAllocationTimestamp(@Nullable OffsetDateTime allocationTimestamp) {
        this.allocationTimestamp = allocationTimestamp;
    }

    public V1beta1AllocationResult devices(@Nullable V1beta1DeviceAllocationResult devices) {
        this.devices = devices;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1DeviceAllocationResult getDevices() {
        return this.devices;
    }

    public void setDevices(@Nullable V1beta1DeviceAllocationResult devices) {
        this.devices = devices;
    }

    public V1beta1AllocationResult nodeSelector(@Nullable V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(@Nullable V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1AllocationResult v1beta1AllocationResult = (V1beta1AllocationResult)o;
        return Objects.equals(this.allocationTimestamp, v1beta1AllocationResult.allocationTimestamp) && Objects.equals(this.devices, v1beta1AllocationResult.devices) && Objects.equals(this.nodeSelector, v1beta1AllocationResult.nodeSelector);
    }

    public int hashCode() {
        return Objects.hash(this.allocationTimestamp, this.devices, this.nodeSelector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1AllocationResult {\n");
        sb.append("    allocationTimestamp: ").append(this.toIndentedString(this.allocationTimestamp)).append("\n");
        sb.append("    devices: ").append(this.toIndentedString(this.devices)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta1AllocationResult is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta1AllocationResult` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_DEVICES) != null && !jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonNull()) {
            V1beta1DeviceAllocationResult.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DEVICES));
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_NODE_SELECTOR).isJsonNull()) {
            V1NodeSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NODE_SELECTOR));
        }
    }

    public static V1beta1AllocationResult fromJson(String jsonString) throws IOException {
        return (V1beta1AllocationResult)JSON.getGson().fromJson(jsonString, V1beta1AllocationResult.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOCATION_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_DEVICES);
        openapiFields.add(SERIALIZED_NAME_NODE_SELECTOR);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta1AllocationResult.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta1AllocationResult.class));
            return new TypeAdapter<V1beta1AllocationResult>(){

                public void write(JsonWriter out, V1beta1AllocationResult value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta1AllocationResult read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta1AllocationResult.validateJsonElement(jsonElement);
                    return (V1beta1AllocationResult)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

