/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1beta2CapacityRequirements;
import io.kubernetes.client.openapi.models.V1beta2DeviceSelector;
import io.kubernetes.client.openapi.models.V1beta2DeviceToleration;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ExactDeviceRequest is a request for one or more identical devices.")
public class V1beta2ExactDeviceRequest {
    public static final String SERIALIZED_NAME_ADMIN_ACCESS = "adminAccess";
    @SerializedName(value="adminAccess")
    @Nullable
    private Boolean adminAccess;
    public static final String SERIALIZED_NAME_ALLOCATION_MODE = "allocationMode";
    @SerializedName(value="allocationMode")
    @Nullable
    private String allocationMode;
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    @Nullable
    private V1beta2CapacityRequirements capacity;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    @Nullable
    private Long count;
    public static final String SERIALIZED_NAME_DEVICE_CLASS_NAME = "deviceClassName";
    @SerializedName(value="deviceClassName")
    @Nonnull
    private String deviceClassName;
    public static final String SERIALIZED_NAME_SELECTORS = "selectors";
    @SerializedName(value="selectors")
    @Nullable
    private List<V1beta2DeviceSelector> selectors = new ArrayList<V1beta2DeviceSelector>();
    public static final String SERIALIZED_NAME_TOLERATIONS = "tolerations";
    @SerializedName(value="tolerations")
    @Nullable
    private List<V1beta2DeviceToleration> tolerations = new ArrayList<V1beta2DeviceToleration>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta2ExactDeviceRequest adminAccess(@Nullable Boolean adminAccess) {
        this.adminAccess = adminAccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.  This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.")
    public Boolean getAdminAccess() {
        return this.adminAccess;
    }

    public void setAdminAccess(@Nullable Boolean adminAccess) {
        this.adminAccess = adminAccess;
    }

    public V1beta2ExactDeviceRequest allocationMode(@Nullable String allocationMode) {
        this.allocationMode = allocationMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:  - ExactCount: This request is for a specific number of devices.   This is the default. The exact number is provided in the   count field.  - All: This request is for all of the matching devices in a pool.   At least one device must exist on the node for the allocation to succeed.   Allocation will fail if some devices are already allocated,   unless adminAccess is requested.  If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.  More modes may get added in the future. Clients must refuse to handle requests with unknown modes.")
    public String getAllocationMode() {
        return this.allocationMode;
    }

    public void setAllocationMode(@Nullable String allocationMode) {
        this.allocationMode = allocationMode;
    }

    public V1beta2ExactDeviceRequest capacity(@Nullable V1beta2CapacityRequirements capacity) {
        this.capacity = capacity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta2CapacityRequirements getCapacity() {
        return this.capacity;
    }

    public void setCapacity(@Nullable V1beta2CapacityRequirements capacity) {
        this.capacity = capacity;
    }

    public V1beta2ExactDeviceRequest count(@Nullable Long count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Count is used only when the count mode is \"ExactCount\". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.")
    public Long getCount() {
        return this.count;
    }

    public void setCount(@Nullable Long count) {
        this.count = count;
    }

    public V1beta2ExactDeviceRequest deviceClassName(@Nonnull String deviceClassName) {
        this.deviceClassName = deviceClassName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.  A DeviceClassName is required.  Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.")
    public String getDeviceClassName() {
        return this.deviceClassName;
    }

    public void setDeviceClassName(@Nonnull String deviceClassName) {
        this.deviceClassName = deviceClassName;
    }

    public V1beta2ExactDeviceRequest selectors(@Nullable List<V1beta2DeviceSelector> selectors) {
        this.selectors = selectors;
        return this;
    }

    public V1beta2ExactDeviceRequest addSelectorsItem(V1beta2DeviceSelector selectorsItem) {
        if (this.selectors == null) {
            this.selectors = new ArrayList<V1beta2DeviceSelector>();
        }
        this.selectors.add(selectorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.")
    public List<V1beta2DeviceSelector> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(@Nullable List<V1beta2DeviceSelector> selectors) {
        this.selectors = selectors;
    }

    public V1beta2ExactDeviceRequest tolerations(@Nullable List<V1beta2DeviceToleration> tolerations) {
        this.tolerations = tolerations;
        return this;
    }

    public V1beta2ExactDeviceRequest addTolerationsItem(V1beta2DeviceToleration tolerationsItem) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1beta2DeviceToleration>();
        }
        this.tolerations.add(tolerationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, the request's tolerations.  Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.  In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.  The maximum number of tolerations is 16.  This is an alpha field and requires enabling the DRADeviceTaints feature gate.")
    public List<V1beta2DeviceToleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(@Nullable List<V1beta2DeviceToleration> tolerations) {
        this.tolerations = tolerations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2ExactDeviceRequest v1beta2ExactDeviceRequest = (V1beta2ExactDeviceRequest)o;
        return Objects.equals(this.adminAccess, v1beta2ExactDeviceRequest.adminAccess) && Objects.equals(this.allocationMode, v1beta2ExactDeviceRequest.allocationMode) && Objects.equals(this.capacity, v1beta2ExactDeviceRequest.capacity) && Objects.equals(this.count, v1beta2ExactDeviceRequest.count) && Objects.equals(this.deviceClassName, v1beta2ExactDeviceRequest.deviceClassName) && Objects.equals(this.selectors, v1beta2ExactDeviceRequest.selectors) && Objects.equals(this.tolerations, v1beta2ExactDeviceRequest.tolerations);
    }

    public int hashCode() {
        return Objects.hash(this.adminAccess, this.allocationMode, this.capacity, this.count, this.deviceClassName, this.selectors, this.tolerations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2ExactDeviceRequest {\n");
        sb.append("    adminAccess: ").append(this.toIndentedString(this.adminAccess)).append("\n");
        sb.append("    allocationMode: ").append(this.toIndentedString(this.allocationMode)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    deviceClassName: ").append(this.toIndentedString(this.deviceClassName)).append("\n");
        sb.append("    selectors: ").append(this.toIndentedString(this.selectors)).append("\n");
        sb.append("    tolerations: ").append(this.toIndentedString(this.tolerations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraytolerations;
        int i;
        JsonArray jsonArrayselectors;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta2ExactDeviceRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta2ExactDeviceRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ALLOCATION_MODE) != null && !jsonObj.get(SERIALIZED_NAME_ALLOCATION_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ALLOCATION_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `allocationMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOCATION_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAPACITY) != null && !jsonObj.get(SERIALIZED_NAME_CAPACITY).isJsonNull()) {
            V1beta2CapacityRequirements.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CAPACITY));
        }
        if (!jsonObj.get(SERIALIZED_NAME_DEVICE_CLASS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `deviceClassName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE_CLASS_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELECTORS) != null && !jsonObj.get(SERIALIZED_NAME_SELECTORS).isJsonNull() && (jsonArrayselectors = jsonObj.getAsJsonArray(SERIALIZED_NAME_SELECTORS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SELECTORS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `selectors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SELECTORS).toString()));
            }
            for (i = 0; i < jsonArrayselectors.size(); ++i) {
                V1beta2DeviceSelector.validateJsonElement(jsonArrayselectors.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TOLERATIONS) != null && !jsonObj.get(SERIALIZED_NAME_TOLERATIONS).isJsonNull() && (jsonArraytolerations = jsonObj.getAsJsonArray(SERIALIZED_NAME_TOLERATIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TOLERATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `tolerations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOLERATIONS).toString()));
            }
            for (i = 0; i < jsonArraytolerations.size(); ++i) {
                V1beta2DeviceToleration.validateJsonElement(jsonArraytolerations.get(i));
            }
        }
    }

    public static V1beta2ExactDeviceRequest fromJson(String jsonString) throws IOException {
        return (V1beta2ExactDeviceRequest)JSON.getGson().fromJson(jsonString, V1beta2ExactDeviceRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADMIN_ACCESS);
        openapiFields.add(SERIALIZED_NAME_ALLOCATION_MODE);
        openapiFields.add(SERIALIZED_NAME_CAPACITY);
        openapiFields.add(SERIALIZED_NAME_COUNT);
        openapiFields.add(SERIALIZED_NAME_DEVICE_CLASS_NAME);
        openapiFields.add(SERIALIZED_NAME_SELECTORS);
        openapiFields.add(SERIALIZED_NAME_TOLERATIONS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DEVICE_CLASS_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta2ExactDeviceRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta2ExactDeviceRequest.class));
            return new TypeAdapter<V1beta2ExactDeviceRequest>(){

                public void write(JsonWriter out, V1beta2ExactDeviceRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta2ExactDeviceRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta2ExactDeviceRequest.validateJsonElement(jsonElement);
                    return (V1beta2ExactDeviceRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

