/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1Initializers;
import io.kubernetes.client.models.V1InitializersBuilder;
import io.kubernetes.client.models.V1InitializersFluentImpl;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ObjectMetaFluent;
import io.kubernetes.client.models.V1OwnerReference;
import io.kubernetes.client.models.V1OwnerReferenceBuilder;
import io.kubernetes.client.models.V1OwnerReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class V1ObjectMetaFluentImpl<A extends V1ObjectMetaFluent<A>>
extends BaseFluent<A>
implements V1ObjectMetaFluent<A> {
    private Map<String, String> annotations;
    private String clusterName;
    private DateTime creationTimestamp;
    private Long deletionGracePeriodSeconds;
    private DateTime deletionTimestamp;
    private List<String> finalizers;
    private String generateName;
    private Long generation;
    private V1InitializersBuilder initializers;
    private Map<String, String> labels;
    private String name;
    private String namespace;
    private List<V1OwnerReferenceBuilder> ownerReferences;
    private String resourceVersion;
    private String selfLink;
    private String uid;

    public V1ObjectMetaFluentImpl() {
    }

    public V1ObjectMetaFluentImpl(V1ObjectMeta instance) {
        this.withAnnotations(instance.getAnnotations());
        this.withClusterName(instance.getClusterName());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        this.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds());
        this.withDeletionTimestamp(instance.getDeletionTimestamp());
        this.withFinalizers(instance.getFinalizers());
        this.withGenerateName(instance.getGenerateName());
        this.withGeneration(instance.getGeneration());
        this.withInitializers(instance.getInitializers());
        this.withLabels(instance.getLabels());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withOwnerReferences(instance.getOwnerReferences());
        this.withResourceVersion(instance.getResourceVersion());
        this.withSelfLink(instance.getSelfLink());
        this.withUid(instance.getUid());
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public A withClusterName(String clusterName) {
        this.clusterName = clusterName;
        return (A)this;
    }

    @Override
    public Boolean hasClusterName() {
        return this.clusterName != null;
    }

    @Override
    public A withNewClusterName(String arg1) {
        return this.withClusterName(new String(arg1));
    }

    @Override
    public A withNewClusterName(StringBuilder arg1) {
        return this.withClusterName(new String(arg1));
    }

    @Override
    public A withNewClusterName(StringBuffer arg1) {
        return this.withClusterName(new String(arg1));
    }

    @Override
    public DateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Override
    public A withCreationTimestamp(DateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasCreationTimestamp() {
        return this.creationTimestamp != null;
    }

    @Override
    public A withNewCreationTimestamp(int arg0, int arg1, int arg2, int arg3, int arg4) {
        return this.withCreationTimestamp(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewCreationTimestamp(Object arg0) {
        return this.withCreationTimestamp(new DateTime(arg0));
    }

    @Override
    public A withNewCreationTimestamp(long arg0) {
        return this.withCreationTimestamp(new DateTime(arg0));
    }

    @Override
    public Long getDeletionGracePeriodSeconds() {
        return this.deletionGracePeriodSeconds;
    }

    @Override
    public A withDeletionGracePeriodSeconds(Long deletionGracePeriodSeconds) {
        this.deletionGracePeriodSeconds = deletionGracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasDeletionGracePeriodSeconds() {
        return this.deletionGracePeriodSeconds != null;
    }

    @Override
    public DateTime getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    @Override
    public A withDeletionTimestamp(DateTime deletionTimestamp) {
        this.deletionTimestamp = deletionTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasDeletionTimestamp() {
        return this.deletionTimestamp != null;
    }

    @Override
    public A withNewDeletionTimestamp(int arg0, int arg1, int arg2, int arg3, int arg4) {
        return this.withDeletionTimestamp(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewDeletionTimestamp(Object arg0) {
        return this.withDeletionTimestamp(new DateTime(arg0));
    }

    @Override
    public A withNewDeletionTimestamp(long arg0) {
        return this.withDeletionTimestamp(new DateTime(arg0));
    }

    @Override
    public A addToFinalizers(int index, String item) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToFinalizers(int index, String item) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToFinalizers(String ... items) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToFinalizers(Collection<String> items) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromFinalizers(String ... items) {
        for (String item : items) {
            if (this.finalizers == null) continue;
            this.finalizers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFinalizers(Collection<String> items) {
        for (String item : items) {
            if (this.finalizers == null) continue;
            this.finalizers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getFinalizers() {
        return this.finalizers;
    }

    @Override
    public String getFinalizer(int index) {
        return this.finalizers.get(index);
    }

    @Override
    public String getFirstFinalizer() {
        return this.finalizers.get(0);
    }

    @Override
    public String getLastFinalizer() {
        return this.finalizers.get(this.finalizers.size() - 1);
    }

    @Override
    public String getMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFinalizers(List<String> finalizers) {
        if (this.finalizers != null) {
            this._visitables.get("finalizers").removeAll(this.finalizers);
        }
        if (finalizers != null) {
            this.finalizers = new ArrayList<String>();
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        } else {
            this.finalizers = null;
        }
        return (A)this;
    }

    @Override
    public A withFinalizers(String ... finalizers) {
        if (this.finalizers != null) {
            this.finalizers.clear();
        }
        if (finalizers != null) {
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFinalizers() {
        return this.finalizers != null && !this.finalizers.isEmpty();
    }

    @Override
    public A addNewFinalizer(String arg1) {
        return this.addToFinalizers(new String(arg1));
    }

    @Override
    public A addNewFinalizer(StringBuilder arg1) {
        return this.addToFinalizers(new String(arg1));
    }

    @Override
    public A addNewFinalizer(StringBuffer arg1) {
        return this.addToFinalizers(new String(arg1));
    }

    @Override
    public String getGenerateName() {
        return this.generateName;
    }

    @Override
    public A withGenerateName(String generateName) {
        this.generateName = generateName;
        return (A)this;
    }

    @Override
    public Boolean hasGenerateName() {
        return this.generateName != null;
    }

    @Override
    public A withNewGenerateName(String arg1) {
        return this.withGenerateName(new String(arg1));
    }

    @Override
    public A withNewGenerateName(StringBuilder arg1) {
        return this.withGenerateName(new String(arg1));
    }

    @Override
    public A withNewGenerateName(StringBuffer arg1) {
        return this.withGenerateName(new String(arg1));
    }

    @Override
    public Long getGeneration() {
        return this.generation;
    }

    @Override
    public A withGeneration(Long generation) {
        this.generation = generation;
        return (A)this;
    }

    @Override
    public Boolean hasGeneration() {
        return this.generation != null;
    }

    @Override
    @Deprecated
    public V1Initializers getInitializers() {
        return this.initializers != null ? this.initializers.build() : null;
    }

    @Override
    public V1Initializers buildInitializers() {
        return this.initializers != null ? this.initializers.build() : null;
    }

    @Override
    public A withInitializers(V1Initializers initializers) {
        this._visitables.get("initializers").remove(this.initializers);
        if (initializers != null) {
            this.initializers = new V1InitializersBuilder(initializers);
            this._visitables.get("initializers").add(this.initializers);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitializers() {
        return this.initializers != null;
    }

    @Override
    public V1ObjectMetaFluent.InitializersNested<A> withNewInitializers() {
        return new InitializersNestedImpl();
    }

    @Override
    public V1ObjectMetaFluent.InitializersNested<A> withNewInitializersLike(V1Initializers item) {
        return new InitializersNestedImpl(item);
    }

    @Override
    public V1ObjectMetaFluent.InitializersNested<A> editInitializers() {
        return this.withNewInitializersLike(this.getInitializers());
    }

    @Override
    public V1ObjectMetaFluent.InitializersNested<A> editOrNewInitializers() {
        return this.withNewInitializersLike(this.getInitializers() != null ? this.getInitializers() : new V1InitializersBuilder().build());
    }

    @Override
    public V1ObjectMetaFluent.InitializersNested<A> editOrNewInitializersLike(V1Initializers item) {
        return this.withNewInitializersLike(this.getInitializers() != null ? this.getInitializers() : item);
    }

    @Override
    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    public A withNewNamespace(String arg1) {
        return this.withNamespace(new String(arg1));
    }

    @Override
    public A withNewNamespace(StringBuilder arg1) {
        return this.withNamespace(new String(arg1));
    }

    @Override
    public A withNewNamespace(StringBuffer arg1) {
        return this.withNamespace(new String(arg1));
    }

    @Override
    public A addToOwnerReferences(int index, V1OwnerReference item) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<V1OwnerReferenceBuilder>();
        }
        V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);
        this._visitables.get("ownerReferences").add(index >= 0 ? index : this._visitables.get("ownerReferences").size(), builder);
        this.ownerReferences.add(index >= 0 ? index : this.ownerReferences.size(), builder);
        return (A)this;
    }

    @Override
    public A setToOwnerReferences(int index, V1OwnerReference item) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<V1OwnerReferenceBuilder>();
        }
        V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get("ownerReferences").size()) {
            this._visitables.get("ownerReferences").add(builder);
        } else {
            this._visitables.get("ownerReferences").set(index, builder);
        }
        if (index < 0 || index >= this.ownerReferences.size()) {
            this.ownerReferences.add(builder);
        } else {
            this.ownerReferences.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToOwnerReferences(V1OwnerReference ... items) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<V1OwnerReferenceBuilder>();
        }
        for (V1OwnerReference item : items) {
            V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);
            this._visitables.get("ownerReferences").add(builder);
            this.ownerReferences.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToOwnerReferences(Collection<V1OwnerReference> items) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<V1OwnerReferenceBuilder>();
        }
        for (V1OwnerReference item : items) {
            V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);
            this._visitables.get("ownerReferences").add(builder);
            this.ownerReferences.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromOwnerReferences(V1OwnerReference ... items) {
        for (V1OwnerReference item : items) {
            V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);
            this._visitables.get("ownerReferences").remove(builder);
            if (this.ownerReferences == null) continue;
            this.ownerReferences.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOwnerReferences(Collection<V1OwnerReference> items) {
        for (V1OwnerReference item : items) {
            V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);
            this._visitables.get("ownerReferences").remove(builder);
            if (this.ownerReferences == null) continue;
            this.ownerReferences.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1OwnerReference> getOwnerReferences() {
        return V1ObjectMetaFluentImpl.build(this.ownerReferences);
    }

    @Override
    public List<V1OwnerReference> buildOwnerReferences() {
        return V1ObjectMetaFluentImpl.build(this.ownerReferences);
    }

    @Override
    public V1OwnerReference buildOwnerReference(int index) {
        return this.ownerReferences.get(index).build();
    }

    @Override
    public V1OwnerReference buildFirstOwnerReference() {
        return this.ownerReferences.get(0).build();
    }

    @Override
    public V1OwnerReference buildLastOwnerReference() {
        return this.ownerReferences.get(this.ownerReferences.size() - 1).build();
    }

    @Override
    public V1OwnerReference buildMatchingOwnerReference(Predicate<V1OwnerReferenceBuilder> predicate) {
        for (V1OwnerReferenceBuilder item : this.ownerReferences) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOwnerReference(Predicate<V1OwnerReferenceBuilder> predicate) {
        for (V1OwnerReferenceBuilder item : this.ownerReferences) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOwnerReferences(List<V1OwnerReference> ownerReferences) {
        if (this.ownerReferences != null) {
            this._visitables.get("ownerReferences").removeAll(this.ownerReferences);
        }
        if (ownerReferences != null) {
            this.ownerReferences = new ArrayList<V1OwnerReferenceBuilder>();
            for (V1OwnerReference item : ownerReferences) {
                this.addToOwnerReferences(item);
            }
        } else {
            this.ownerReferences = null;
        }
        return (A)this;
    }

    @Override
    public A withOwnerReferences(V1OwnerReference ... ownerReferences) {
        if (this.ownerReferences != null) {
            this.ownerReferences.clear();
        }
        if (ownerReferences != null) {
            for (V1OwnerReference item : ownerReferences) {
                this.addToOwnerReferences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOwnerReferences() {
        return this.ownerReferences != null && !this.ownerReferences.isEmpty();
    }

    @Override
    public V1ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReference() {
        return new OwnerReferencesNestedImpl();
    }

    @Override
    public V1ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReferenceLike(V1OwnerReference item) {
        return new OwnerReferencesNestedImpl(-1, item);
    }

    @Override
    public V1ObjectMetaFluent.OwnerReferencesNested<A> setNewOwnerReferenceLike(int index, V1OwnerReference item) {
        return new OwnerReferencesNestedImpl(index, item);
    }

    @Override
    public V1ObjectMetaFluent.OwnerReferencesNested<A> editOwnerReference(int index) {
        if (this.ownerReferences.size() <= index) {
            throw new RuntimeException("Can't edit ownerReferences. Index exceeds size.");
        }
        return this.setNewOwnerReferenceLike(index, this.buildOwnerReference(index));
    }

    @Override
    public V1ObjectMetaFluent.OwnerReferencesNested<A> editFirstOwnerReference() {
        if (this.ownerReferences.size() == 0) {
            throw new RuntimeException("Can't edit first ownerReferences. The list is empty.");
        }
        return this.setNewOwnerReferenceLike(0, this.buildOwnerReference(0));
    }

    @Override
    public V1ObjectMetaFluent.OwnerReferencesNested<A> editLastOwnerReference() {
        int index = this.ownerReferences.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ownerReferences. The list is empty.");
        }
        return this.setNewOwnerReferenceLike(index, this.buildOwnerReference(index));
    }

    @Override
    public V1ObjectMetaFluent.OwnerReferencesNested<A> editMatchingOwnerReference(Predicate<V1OwnerReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ownerReferences.size(); ++i) {
            if (!predicate.apply(this.ownerReferences.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ownerReferences. No match found.");
        }
        return this.setNewOwnerReferenceLike(index, this.buildOwnerReference(index));
    }

    @Override
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    @Override
    public A withResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return (A)this;
    }

    @Override
    public Boolean hasResourceVersion() {
        return this.resourceVersion != null;
    }

    @Override
    public A withNewResourceVersion(String arg1) {
        return this.withResourceVersion(new String(arg1));
    }

    @Override
    public A withNewResourceVersion(StringBuilder arg1) {
        return this.withResourceVersion(new String(arg1));
    }

    @Override
    public A withNewResourceVersion(StringBuffer arg1) {
        return this.withResourceVersion(new String(arg1));
    }

    @Override
    public String getSelfLink() {
        return this.selfLink;
    }

    @Override
    public A withSelfLink(String selfLink) {
        this.selfLink = selfLink;
        return (A)this;
    }

    @Override
    public Boolean hasSelfLink() {
        return this.selfLink != null;
    }

    @Override
    public A withNewSelfLink(String arg1) {
        return this.withSelfLink(new String(arg1));
    }

    @Override
    public A withNewSelfLink(StringBuilder arg1) {
        return this.withSelfLink(new String(arg1));
    }

    @Override
    public A withNewSelfLink(StringBuffer arg1) {
        return this.withSelfLink(new String(arg1));
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    @Override
    public A withNewUid(String arg1) {
        return this.withUid(new String(arg1));
    }

    @Override
    public A withNewUid(StringBuilder arg1) {
        return this.withUid(new String(arg1));
    }

    @Override
    public A withNewUid(StringBuffer arg1) {
        return this.withUid(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ObjectMetaFluentImpl that = (V1ObjectMetaFluentImpl)o;
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        if (this.creationTimestamp != null ? !this.creationTimestamp.equals((Object)that.creationTimestamp) : that.creationTimestamp != null) {
            return false;
        }
        if (this.deletionGracePeriodSeconds != null ? !this.deletionGracePeriodSeconds.equals(that.deletionGracePeriodSeconds) : that.deletionGracePeriodSeconds != null) {
            return false;
        }
        if (this.deletionTimestamp != null ? !this.deletionTimestamp.equals((Object)that.deletionTimestamp) : that.deletionTimestamp != null) {
            return false;
        }
        if (this.finalizers != null ? !this.finalizers.equals(that.finalizers) : that.finalizers != null) {
            return false;
        }
        if (this.generateName != null ? !this.generateName.equals(that.generateName) : that.generateName != null) {
            return false;
        }
        if (this.generation != null ? !this.generation.equals(that.generation) : that.generation != null) {
            return false;
        }
        if (this.initializers != null ? !this.initializers.equals(that.initializers) : that.initializers != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.ownerReferences != null ? !this.ownerReferences.equals(that.ownerReferences) : that.ownerReferences != null) {
            return false;
        }
        if (this.resourceVersion != null ? !this.resourceVersion.equals(that.resourceVersion) : that.resourceVersion != null) {
            return false;
        }
        if (this.selfLink != null ? !this.selfLink.equals(that.selfLink) : that.selfLink != null) {
            return false;
        }
        return !(this.uid != null ? !this.uid.equals(that.uid) : that.uid != null);
    }

    public class OwnerReferencesNestedImpl<N>
    extends V1OwnerReferenceFluentImpl<V1ObjectMetaFluent.OwnerReferencesNested<N>>
    implements V1ObjectMetaFluent.OwnerReferencesNested<N>,
    Nested<N> {
        private final V1OwnerReferenceBuilder builder;
        private final int index;

        OwnerReferencesNestedImpl(int index, V1OwnerReference item) {
            this.index = index;
            this.builder = new V1OwnerReferenceBuilder(this, item);
        }

        OwnerReferencesNestedImpl() {
            this.index = -1;
            this.builder = new V1OwnerReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ObjectMetaFluentImpl.this.setToOwnerReferences(this.index, this.builder.build());
        }

        @Override
        public N endOwnerReference() {
            return this.and();
        }
    }

    public class InitializersNestedImpl<N>
    extends V1InitializersFluentImpl<V1ObjectMetaFluent.InitializersNested<N>>
    implements V1ObjectMetaFluent.InitializersNested<N>,
    Nested<N> {
        private final V1InitializersBuilder builder;

        InitializersNestedImpl(V1Initializers item) {
            this.builder = new V1InitializersBuilder(this, item);
        }

        InitializersNestedImpl() {
            this.builder = new V1InitializersBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ObjectMetaFluentImpl.this.withInitializers(this.builder.build());
        }

        @Override
        public N endInitializers() {
            return this.and();
        }
    }
}

