/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1LabelSelector;
import io.kubernetes.client.models.V1LabelSelectorBuilder;
import io.kubernetes.client.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.models.V1PersistentVolumeClaimSpec;
import io.kubernetes.client.models.V1PersistentVolumeClaimSpecFluent;
import io.kubernetes.client.models.V1ResourceRequirements;
import io.kubernetes.client.models.V1ResourceRequirementsBuilder;
import io.kubernetes.client.models.V1ResourceRequirementsFluentImpl;
import io.kubernetes.client.models.V1TypedLocalObjectReference;
import io.kubernetes.client.models.V1TypedLocalObjectReferenceBuilder;
import io.kubernetes.client.models.V1TypedLocalObjectReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1PersistentVolumeClaimSpecFluentImpl<A extends V1PersistentVolumeClaimSpecFluent<A>>
extends BaseFluent<A>
implements V1PersistentVolumeClaimSpecFluent<A> {
    private List<String> accessModes;
    private V1TypedLocalObjectReferenceBuilder dataSource;
    private V1ResourceRequirementsBuilder resources;
    private V1LabelSelectorBuilder selector;
    private String storageClassName;
    private String volumeMode;
    private String volumeName;

    public V1PersistentVolumeClaimSpecFluentImpl() {
    }

    public V1PersistentVolumeClaimSpecFluentImpl(V1PersistentVolumeClaimSpec instance) {
        this.withAccessModes(instance.getAccessModes());
        this.withDataSource(instance.getDataSource());
        this.withResources(instance.getResources());
        this.withSelector(instance.getSelector());
        this.withStorageClassName(instance.getStorageClassName());
        this.withVolumeMode(instance.getVolumeMode());
        this.withVolumeName(instance.getVolumeName());
    }

    @Override
    public A addToAccessModes(int index, String item) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAccessModes(int index, String item) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAccessModes(String ... items) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAccessModes(Collection<String> items) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAccessModes(String ... items) {
        for (String item : items) {
            if (this.accessModes == null) continue;
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAccessModes(Collection<String> items) {
        for (String item : items) {
            if (this.accessModes == null) continue;
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    @Override
    public String getAccessMode(int index) {
        return this.accessModes.get(index);
    }

    @Override
    public String getFirstAccessMode() {
        return this.accessModes.get(0);
    }

    @Override
    public String getLastAccessMode() {
        return this.accessModes.get(this.accessModes.size() - 1);
    }

    @Override
    public String getMatchingAccessMode(Predicate<String> predicate) {
        for (String item : this.accessModes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAccessMode(Predicate<String> predicate) {
        for (String item : this.accessModes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAccessModes(List<String> accessModes) {
        if (this.accessModes != null) {
            this._visitables.get("accessModes").removeAll(this.accessModes);
        }
        if (accessModes != null) {
            this.accessModes = new ArrayList<String>();
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        } else {
            this.accessModes = null;
        }
        return (A)this;
    }

    @Override
    public A withAccessModes(String ... accessModes) {
        if (this.accessModes != null) {
            this.accessModes.clear();
        }
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAccessModes() {
        return this.accessModes != null && !this.accessModes.isEmpty();
    }

    @Override
    public A addNewAccessMode(String arg1) {
        return this.addToAccessModes(new String(arg1));
    }

    @Override
    public A addNewAccessMode(StringBuilder arg1) {
        return this.addToAccessModes(new String(arg1));
    }

    @Override
    public A addNewAccessMode(StringBuffer arg1) {
        return this.addToAccessModes(new String(arg1));
    }

    @Override
    @Deprecated
    public V1TypedLocalObjectReference getDataSource() {
        return this.dataSource != null ? this.dataSource.build() : null;
    }

    @Override
    public V1TypedLocalObjectReference buildDataSource() {
        return this.dataSource != null ? this.dataSource.build() : null;
    }

    @Override
    public A withDataSource(V1TypedLocalObjectReference dataSource) {
        this._visitables.get("dataSource").remove(this.dataSource);
        if (dataSource != null) {
            this.dataSource = new V1TypedLocalObjectReferenceBuilder(dataSource);
            this._visitables.get("dataSource").add(this.dataSource);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDataSource() {
        return this.dataSource != null;
    }

    @Override
    public V1PersistentVolumeClaimSpecFluent.DataSourceNested<A> withNewDataSource() {
        return new DataSourceNestedImpl();
    }

    @Override
    public V1PersistentVolumeClaimSpecFluent.DataSourceNested<A> withNewDataSourceLike(V1TypedLocalObjectReference item) {
        return new DataSourceNestedImpl(item);
    }

    @Override
    public V1PersistentVolumeClaimSpecFluent.DataSourceNested<A> editDataSource() {
        return this.withNewDataSourceLike(this.getDataSource());
    }

    @Override
    public V1PersistentVolumeClaimSpecFluent.DataSourceNested<A> editOrNewDataSource() {
        return this.withNewDataSourceLike(this.getDataSource() != null ? this.getDataSource() : new V1TypedLocalObjectReferenceBuilder().build());
    }

    @Override
    public V1PersistentVolumeClaimSpecFluent.DataSourceNested<A> editOrNewDataSourceLike(V1TypedLocalObjectReference item) {
        return this.withNewDataSourceLike(this.getDataSource() != null ? this.getDataSource() : item);
    }

    @Override
    @Deprecated
    public V1ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public V1ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(V1ResourceRequirements resources) {
        this._visitables.get("resources").remove(this.resources);
        if (resources != null) {
            this.resources = new V1ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public V1PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public V1PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResourcesLike(V1ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public V1PersistentVolumeClaimSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public V1PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new V1ResourceRequirementsBuilder().build());
    }

    @Override
    public V1PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResourcesLike(V1ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    @Deprecated
    public V1LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public V1LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(V1LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new V1LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public V1PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public V1PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public V1PersistentVolumeClaimSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public V1PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V1PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public String getStorageClassName() {
        return this.storageClassName;
    }

    @Override
    public A withStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return (A)this;
    }

    @Override
    public Boolean hasStorageClassName() {
        return this.storageClassName != null;
    }

    @Override
    public A withNewStorageClassName(String arg1) {
        return this.withStorageClassName(new String(arg1));
    }

    @Override
    public A withNewStorageClassName(StringBuilder arg1) {
        return this.withStorageClassName(new String(arg1));
    }

    @Override
    public A withNewStorageClassName(StringBuffer arg1) {
        return this.withStorageClassName(new String(arg1));
    }

    @Override
    public String getVolumeMode() {
        return this.volumeMode;
    }

    @Override
    public A withVolumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeMode() {
        return this.volumeMode != null;
    }

    @Override
    public A withNewVolumeMode(String arg1) {
        return this.withVolumeMode(new String(arg1));
    }

    @Override
    public A withNewVolumeMode(StringBuilder arg1) {
        return this.withVolumeMode(new String(arg1));
    }

    @Override
    public A withNewVolumeMode(StringBuffer arg1) {
        return this.withVolumeMode(new String(arg1));
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeName() {
        return this.volumeName != null;
    }

    @Override
    public A withNewVolumeName(String arg1) {
        return this.withVolumeName(new String(arg1));
    }

    @Override
    public A withNewVolumeName(StringBuilder arg1) {
        return this.withVolumeName(new String(arg1));
    }

    @Override
    public A withNewVolumeName(StringBuffer arg1) {
        return this.withVolumeName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PersistentVolumeClaimSpecFluentImpl that = (V1PersistentVolumeClaimSpecFluentImpl)o;
        if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) {
            return false;
        }
        if (this.dataSource != null ? !this.dataSource.equals(that.dataSource) : that.dataSource != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.storageClassName != null ? !this.storageClassName.equals(that.storageClassName) : that.storageClassName != null) {
            return false;
        }
        if (this.volumeMode != null ? !this.volumeMode.equals(that.volumeMode) : that.volumeMode != null) {
            return false;
        }
        return !(this.volumeName != null ? !this.volumeName.equals(that.volumeName) : that.volumeName != null);
    }

    public class SelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1PersistentVolumeClaimSpecFluent.SelectorNested<N>>
    implements V1PersistentVolumeClaimSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final V1LabelSelectorBuilder builder;

        SelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PersistentVolumeClaimSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends V1ResourceRequirementsFluentImpl<V1PersistentVolumeClaimSpecFluent.ResourcesNested<N>>
    implements V1PersistentVolumeClaimSpecFluent.ResourcesNested<N>,
    Nested<N> {
        private final V1ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(V1ResourceRequirements item) {
            this.builder = new V1ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new V1ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PersistentVolumeClaimSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class DataSourceNestedImpl<N>
    extends V1TypedLocalObjectReferenceFluentImpl<V1PersistentVolumeClaimSpecFluent.DataSourceNested<N>>
    implements V1PersistentVolumeClaimSpecFluent.DataSourceNested<N>,
    Nested<N> {
        private final V1TypedLocalObjectReferenceBuilder builder;

        DataSourceNestedImpl(V1TypedLocalObjectReference item) {
            this.builder = new V1TypedLocalObjectReferenceBuilder(this, item);
        }

        DataSourceNestedImpl() {
            this.builder = new V1TypedLocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PersistentVolumeClaimSpecFluentImpl.this.withDataSource(this.builder.build());
        }

        @Override
        public N endDataSource() {
            return this.and();
        }
    }
}

