/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1KeyToPath;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Adapts a Secret into a volume.  The contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names. Secret volumes support ownership management and SELinux relabeling.")
public class V1SecretVolumeSource {
    @SerializedName(value="defaultMode")
    private Integer defaultMode = null;
    @SerializedName(value="items")
    private List<V1KeyToPath> items = null;
    @SerializedName(value="optional")
    private Boolean optional = null;
    @SerializedName(value="secretName")
    private String secretName = null;

    public V1SecretVolumeSource defaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return this;
    }

    @ApiModelProperty(value="Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.")
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public void setDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
    }

    public V1SecretVolumeSource items(List<V1KeyToPath> items) {
        this.items = items;
        return this;
    }

    public V1SecretVolumeSource addItemsItem(V1KeyToPath itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<V1KeyToPath>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.")
    public List<V1KeyToPath> getItems() {
        return this.items;
    }

    public void setItems(List<V1KeyToPath> items) {
        this.items = items;
    }

    public V1SecretVolumeSource optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @ApiModelProperty(value="Specify whether the Secret or it's keys must be defined")
    public Boolean isOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public V1SecretVolumeSource secretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    @ApiModelProperty(value="Name of the secret in the pod's namespace to use. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret")
    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SecretVolumeSource v1SecretVolumeSource = (V1SecretVolumeSource)o;
        return Objects.equals(this.defaultMode, v1SecretVolumeSource.defaultMode) && Objects.equals(this.items, v1SecretVolumeSource.items) && Objects.equals(this.optional, v1SecretVolumeSource.optional) && Objects.equals(this.secretName, v1SecretVolumeSource.secretName);
    }

    public int hashCode() {
        return Objects.hash(this.defaultMode, this.items, this.optional, this.secretName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1SecretVolumeSource {\n");
        sb.append("    defaultMode: ").append(this.toIndentedString(this.defaultMode)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("    secretName: ").append(this.toIndentedString(this.secretName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

