/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ObjectMetaBuilder;
import io.kubernetes.client.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.models.V1StorageClass;
import io.kubernetes.client.models.V1StorageClassFluent;
import io.kubernetes.client.models.V1TopologySelectorTerm;
import io.kubernetes.client.models.V1TopologySelectorTermBuilder;
import io.kubernetes.client.models.V1TopologySelectorTermFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class V1StorageClassFluentImpl<A extends V1StorageClassFluent<A>>
extends BaseFluent<A>
implements V1StorageClassFluent<A> {
    private Boolean allowVolumeExpansion;
    private List<V1TopologySelectorTermBuilder> allowedTopologies;
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private List<String> mountOptions;
    private Map<String, String> parameters;
    private String provisioner;
    private String reclaimPolicy;
    private String volumeBindingMode;

    public V1StorageClassFluentImpl() {
    }

    public V1StorageClassFluentImpl(V1StorageClass instance) {
        this.withAllowVolumeExpansion(instance.isAllowVolumeExpansion());
        this.withAllowedTopologies(instance.getAllowedTopologies());
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withMountOptions(instance.getMountOptions());
        this.withParameters(instance.getParameters());
        this.withProvisioner(instance.getProvisioner());
        this.withReclaimPolicy(instance.getReclaimPolicy());
        this.withVolumeBindingMode(instance.getVolumeBindingMode());
    }

    @Override
    public Boolean isAllowVolumeExpansion() {
        return this.allowVolumeExpansion;
    }

    @Override
    public A withAllowVolumeExpansion(Boolean allowVolumeExpansion) {
        this.allowVolumeExpansion = allowVolumeExpansion;
        return (A)this;
    }

    @Override
    public Boolean hasAllowVolumeExpansion() {
        return this.allowVolumeExpansion != null;
    }

    @Override
    public A withNewAllowVolumeExpansion(String arg1) {
        return this.withAllowVolumeExpansion(new Boolean(arg1));
    }

    @Override
    public A withNewAllowVolumeExpansion(boolean arg1) {
        return this.withAllowVolumeExpansion(new Boolean(arg1));
    }

    @Override
    public A addToAllowedTopologies(int index, V1TopologySelectorTerm item) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<V1TopologySelectorTermBuilder>();
        }
        V1TopologySelectorTermBuilder builder = new V1TopologySelectorTermBuilder(item);
        this._visitables.get("allowedTopologies").add(index >= 0 ? index : this._visitables.get("allowedTopologies").size(), builder);
        this.allowedTopologies.add(index >= 0 ? index : this.allowedTopologies.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAllowedTopologies(int index, V1TopologySelectorTerm item) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<V1TopologySelectorTermBuilder>();
        }
        V1TopologySelectorTermBuilder builder = new V1TopologySelectorTermBuilder(item);
        if (index < 0 || index >= this._visitables.get("allowedTopologies").size()) {
            this._visitables.get("allowedTopologies").add(builder);
        } else {
            this._visitables.get("allowedTopologies").set(index, builder);
        }
        if (index < 0 || index >= this.allowedTopologies.size()) {
            this.allowedTopologies.add(builder);
        } else {
            this.allowedTopologies.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAllowedTopologies(V1TopologySelectorTerm ... items) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<V1TopologySelectorTermBuilder>();
        }
        for (V1TopologySelectorTerm item : items) {
            V1TopologySelectorTermBuilder builder = new V1TopologySelectorTermBuilder(item);
            this._visitables.get("allowedTopologies").add(builder);
            this.allowedTopologies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedTopologies(Collection<V1TopologySelectorTerm> items) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<V1TopologySelectorTermBuilder>();
        }
        for (V1TopologySelectorTerm item : items) {
            V1TopologySelectorTermBuilder builder = new V1TopologySelectorTermBuilder(item);
            this._visitables.get("allowedTopologies").add(builder);
            this.allowedTopologies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedTopologies(V1TopologySelectorTerm ... items) {
        for (V1TopologySelectorTerm item : items) {
            V1TopologySelectorTermBuilder builder = new V1TopologySelectorTermBuilder(item);
            this._visitables.get("allowedTopologies").remove(builder);
            if (this.allowedTopologies == null) continue;
            this.allowedTopologies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedTopologies(Collection<V1TopologySelectorTerm> items) {
        for (V1TopologySelectorTerm item : items) {
            V1TopologySelectorTermBuilder builder = new V1TopologySelectorTermBuilder(item);
            this._visitables.get("allowedTopologies").remove(builder);
            if (this.allowedTopologies == null) continue;
            this.allowedTopologies.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1TopologySelectorTerm> getAllowedTopologies() {
        return V1StorageClassFluentImpl.build(this.allowedTopologies);
    }

    @Override
    public List<V1TopologySelectorTerm> buildAllowedTopologies() {
        return V1StorageClassFluentImpl.build(this.allowedTopologies);
    }

    @Override
    public V1TopologySelectorTerm buildAllowedTopology(int index) {
        return this.allowedTopologies.get(index).build();
    }

    @Override
    public V1TopologySelectorTerm buildFirstAllowedTopology() {
        return this.allowedTopologies.get(0).build();
    }

    @Override
    public V1TopologySelectorTerm buildLastAllowedTopology() {
        return this.allowedTopologies.get(this.allowedTopologies.size() - 1).build();
    }

    @Override
    public V1TopologySelectorTerm buildMatchingAllowedTopology(Predicate<V1TopologySelectorTermBuilder> predicate) {
        for (V1TopologySelectorTermBuilder item : this.allowedTopologies) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedTopology(Predicate<V1TopologySelectorTermBuilder> predicate) {
        for (V1TopologySelectorTermBuilder item : this.allowedTopologies) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedTopologies(List<V1TopologySelectorTerm> allowedTopologies) {
        if (this.allowedTopologies != null) {
            this._visitables.get("allowedTopologies").removeAll(this.allowedTopologies);
        }
        if (allowedTopologies != null) {
            this.allowedTopologies = new ArrayList<V1TopologySelectorTermBuilder>();
            for (V1TopologySelectorTerm item : allowedTopologies) {
                this.addToAllowedTopologies(item);
            }
        } else {
            this.allowedTopologies = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedTopologies(V1TopologySelectorTerm ... allowedTopologies) {
        if (this.allowedTopologies != null) {
            this.allowedTopologies.clear();
        }
        if (allowedTopologies != null) {
            for (V1TopologySelectorTerm item : allowedTopologies) {
                this.addToAllowedTopologies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedTopologies() {
        return this.allowedTopologies != null && !this.allowedTopologies.isEmpty();
    }

    @Override
    public V1StorageClassFluent.AllowedTopologiesNested<A> addNewAllowedTopology() {
        return new AllowedTopologiesNestedImpl();
    }

    @Override
    public V1StorageClassFluent.AllowedTopologiesNested<A> addNewAllowedTopologyLike(V1TopologySelectorTerm item) {
        return new AllowedTopologiesNestedImpl(-1, item);
    }

    @Override
    public V1StorageClassFluent.AllowedTopologiesNested<A> setNewAllowedTopologyLike(int index, V1TopologySelectorTerm item) {
        return new AllowedTopologiesNestedImpl(index, item);
    }

    @Override
    public V1StorageClassFluent.AllowedTopologiesNested<A> editAllowedTopology(int index) {
        if (this.allowedTopologies.size() <= index) {
            throw new RuntimeException("Can't edit allowedTopologies. Index exceeds size.");
        }
        return this.setNewAllowedTopologyLike(index, this.buildAllowedTopology(index));
    }

    @Override
    public V1StorageClassFluent.AllowedTopologiesNested<A> editFirstAllowedTopology() {
        if (this.allowedTopologies.size() == 0) {
            throw new RuntimeException("Can't edit first allowedTopologies. The list is empty.");
        }
        return this.setNewAllowedTopologyLike(0, this.buildAllowedTopology(0));
    }

    @Override
    public V1StorageClassFluent.AllowedTopologiesNested<A> editLastAllowedTopology() {
        int index = this.allowedTopologies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allowedTopologies. The list is empty.");
        }
        return this.setNewAllowedTopologyLike(index, this.buildAllowedTopology(index));
    }

    @Override
    public V1StorageClassFluent.AllowedTopologiesNested<A> editMatchingAllowedTopology(Predicate<V1TopologySelectorTermBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allowedTopologies.size(); ++i) {
            if (!predicate.apply(this.allowedTopologies.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allowedTopologies. No match found.");
        }
        return this.setNewAllowedTopologyLike(index, this.buildAllowedTopology(index));
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1StorageClassFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1StorageClassFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1StorageClassFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1StorageClassFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1StorageClassFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToMountOptions(int index, String item) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        this.mountOptions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMountOptions(int index, String item) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        this.mountOptions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMountOptions(String ... items) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.mountOptions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMountOptions(Collection<String> items) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.mountOptions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMountOptions(String ... items) {
        for (String item : items) {
            if (this.mountOptions == null) continue;
            this.mountOptions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMountOptions(Collection<String> items) {
        for (String item : items) {
            if (this.mountOptions == null) continue;
            this.mountOptions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMountOptions() {
        return this.mountOptions;
    }

    @Override
    public String getMountOption(int index) {
        return this.mountOptions.get(index);
    }

    @Override
    public String getFirstMountOption() {
        return this.mountOptions.get(0);
    }

    @Override
    public String getLastMountOption() {
        return this.mountOptions.get(this.mountOptions.size() - 1);
    }

    @Override
    public String getMatchingMountOption(Predicate<String> predicate) {
        for (String item : this.mountOptions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMountOption(Predicate<String> predicate) {
        for (String item : this.mountOptions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMountOptions(List<String> mountOptions) {
        if (this.mountOptions != null) {
            this._visitables.get("mountOptions").removeAll(this.mountOptions);
        }
        if (mountOptions != null) {
            this.mountOptions = new ArrayList<String>();
            for (String item : mountOptions) {
                this.addToMountOptions(item);
            }
        } else {
            this.mountOptions = null;
        }
        return (A)this;
    }

    @Override
    public A withMountOptions(String ... mountOptions) {
        if (this.mountOptions != null) {
            this.mountOptions.clear();
        }
        if (mountOptions != null) {
            for (String item : mountOptions) {
                this.addToMountOptions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMountOptions() {
        return this.mountOptions != null && !this.mountOptions.isEmpty();
    }

    @Override
    public A addNewMountOption(String arg1) {
        return this.addToMountOptions(new String(arg1));
    }

    @Override
    public A addNewMountOption(StringBuilder arg1) {
        return this.addToMountOptions(new String(arg1));
    }

    @Override
    public A addNewMountOption(StringBuffer arg1) {
        return this.addToMountOptions(new String(arg1));
    }

    @Override
    public A addToParameters(String key, String value) {
        if (this.parameters == null && key != null && value != null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.parameters.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToParameters(Map<String, String> map) {
        if (this.parameters == null && map != null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.parameters.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromParameters(String key) {
        if (this.parameters == null) {
            return (A)this;
        }
        if (key != null && this.parameters != null) {
            this.parameters.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromParameters(Map<String, String> map) {
        if (this.parameters == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.parameters == null) continue;
                this.parameters.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public A withParameters(Map<String, String> parameters) {
        this.parameters = parameters == null ? null : new LinkedHashMap<String, String>(parameters);
        return (A)this;
    }

    @Override
    public Boolean hasParameters() {
        return this.parameters != null;
    }

    @Override
    public String getProvisioner() {
        return this.provisioner;
    }

    @Override
    public A withProvisioner(String provisioner) {
        this.provisioner = provisioner;
        return (A)this;
    }

    @Override
    public Boolean hasProvisioner() {
        return this.provisioner != null;
    }

    @Override
    public A withNewProvisioner(String arg1) {
        return this.withProvisioner(new String(arg1));
    }

    @Override
    public A withNewProvisioner(StringBuilder arg1) {
        return this.withProvisioner(new String(arg1));
    }

    @Override
    public A withNewProvisioner(StringBuffer arg1) {
        return this.withProvisioner(new String(arg1));
    }

    @Override
    public String getReclaimPolicy() {
        return this.reclaimPolicy;
    }

    @Override
    public A withReclaimPolicy(String reclaimPolicy) {
        this.reclaimPolicy = reclaimPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasReclaimPolicy() {
        return this.reclaimPolicy != null;
    }

    @Override
    public A withNewReclaimPolicy(String arg1) {
        return this.withReclaimPolicy(new String(arg1));
    }

    @Override
    public A withNewReclaimPolicy(StringBuilder arg1) {
        return this.withReclaimPolicy(new String(arg1));
    }

    @Override
    public A withNewReclaimPolicy(StringBuffer arg1) {
        return this.withReclaimPolicy(new String(arg1));
    }

    @Override
    public String getVolumeBindingMode() {
        return this.volumeBindingMode;
    }

    @Override
    public A withVolumeBindingMode(String volumeBindingMode) {
        this.volumeBindingMode = volumeBindingMode;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeBindingMode() {
        return this.volumeBindingMode != null;
    }

    @Override
    public A withNewVolumeBindingMode(String arg1) {
        return this.withVolumeBindingMode(new String(arg1));
    }

    @Override
    public A withNewVolumeBindingMode(StringBuilder arg1) {
        return this.withVolumeBindingMode(new String(arg1));
    }

    @Override
    public A withNewVolumeBindingMode(StringBuffer arg1) {
        return this.withVolumeBindingMode(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1StorageClassFluentImpl that = (V1StorageClassFluentImpl)o;
        if (this.allowVolumeExpansion != null ? !this.allowVolumeExpansion.equals(that.allowVolumeExpansion) : that.allowVolumeExpansion != null) {
            return false;
        }
        if (this.allowedTopologies != null ? !this.allowedTopologies.equals(that.allowedTopologies) : that.allowedTopologies != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.mountOptions != null ? !this.mountOptions.equals(that.mountOptions) : that.mountOptions != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        if (this.provisioner != null ? !this.provisioner.equals(that.provisioner) : that.provisioner != null) {
            return false;
        }
        if (this.reclaimPolicy != null ? !this.reclaimPolicy.equals(that.reclaimPolicy) : that.reclaimPolicy != null) {
            return false;
        }
        return !(this.volumeBindingMode != null ? !this.volumeBindingMode.equals(that.volumeBindingMode) : that.volumeBindingMode != null);
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1StorageClassFluent.MetadataNested<N>>
    implements V1StorageClassFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1StorageClassFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class AllowedTopologiesNestedImpl<N>
    extends V1TopologySelectorTermFluentImpl<V1StorageClassFluent.AllowedTopologiesNested<N>>
    implements V1StorageClassFluent.AllowedTopologiesNested<N>,
    Nested<N> {
        private final V1TopologySelectorTermBuilder builder;
        private final int index;

        AllowedTopologiesNestedImpl(int index, V1TopologySelectorTerm item) {
            this.index = index;
            this.builder = new V1TopologySelectorTermBuilder(this, item);
        }

        AllowedTopologiesNestedImpl() {
            this.index = -1;
            this.builder = new V1TopologySelectorTermBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1StorageClassFluentImpl.this.setToAllowedTopologies(this.index, this.builder.build());
        }

        @Override
        public N endAllowedTopology() {
            return this.and();
        }
    }
}

