/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1beta1JobTemplateSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="CronJobSpec describes how the job execution will look like and when it will actually run.")
public class V1beta1CronJobSpec {
    @SerializedName(value="concurrencyPolicy")
    private String concurrencyPolicy = null;
    @SerializedName(value="failedJobsHistoryLimit")
    private Integer failedJobsHistoryLimit = null;
    @SerializedName(value="jobTemplate")
    private V1beta1JobTemplateSpec jobTemplate = null;
    @SerializedName(value="schedule")
    private String schedule = null;
    @SerializedName(value="startingDeadlineSeconds")
    private Long startingDeadlineSeconds = null;
    @SerializedName(value="successfulJobsHistoryLimit")
    private Integer successfulJobsHistoryLimit = null;
    @SerializedName(value="suspend")
    private Boolean suspend = null;

    public V1beta1CronJobSpec concurrencyPolicy(String concurrencyPolicy) {
        this.concurrencyPolicy = concurrencyPolicy;
        return this;
    }

    @ApiModelProperty(value="Specifies how to treat concurrent executions of a Job. Valid values are: - \"Allow\" (default): allows CronJobs to run concurrently; - \"Forbid\": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - \"Replace\": cancels currently running job and replaces it with a new one")
    public String getConcurrencyPolicy() {
        return this.concurrencyPolicy;
    }

    public void setConcurrencyPolicy(String concurrencyPolicy) {
        this.concurrencyPolicy = concurrencyPolicy;
    }

    public V1beta1CronJobSpec failedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
        this.failedJobsHistoryLimit = failedJobsHistoryLimit;
        return this;
    }

    @ApiModelProperty(value="The number of failed finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.")
    public Integer getFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit;
    }

    public void setFailedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
        this.failedJobsHistoryLimit = failedJobsHistoryLimit;
    }

    public V1beta1CronJobSpec jobTemplate(V1beta1JobTemplateSpec jobTemplate) {
        this.jobTemplate = jobTemplate;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the job that will be created when executing a CronJob.")
    public V1beta1JobTemplateSpec getJobTemplate() {
        return this.jobTemplate;
    }

    public void setJobTemplate(V1beta1JobTemplateSpec jobTemplate) {
        this.jobTemplate = jobTemplate;
    }

    public V1beta1CronJobSpec schedule(String schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(required=true, value="The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.")
    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public V1beta1CronJobSpec startingDeadlineSeconds(Long startingDeadlineSeconds) {
        this.startingDeadlineSeconds = startingDeadlineSeconds;
        return this;
    }

    @ApiModelProperty(value="Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.")
    public Long getStartingDeadlineSeconds() {
        return this.startingDeadlineSeconds;
    }

    public void setStartingDeadlineSeconds(Long startingDeadlineSeconds) {
        this.startingDeadlineSeconds = startingDeadlineSeconds;
    }

    public V1beta1CronJobSpec successfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
        this.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
        return this;
    }

    @ApiModelProperty(value="The number of successful finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified. Defaults to 3.")
    public Integer getSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit;
    }

    public void setSuccessfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
        this.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
    }

    public V1beta1CronJobSpec suspend(Boolean suspend) {
        this.suspend = suspend;
        return this;
    }

    @ApiModelProperty(value="This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.")
    public Boolean isSuspend() {
        return this.suspend;
    }

    public void setSuspend(Boolean suspend) {
        this.suspend = suspend;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CronJobSpec v1beta1CronJobSpec = (V1beta1CronJobSpec)o;
        return Objects.equals(this.concurrencyPolicy, v1beta1CronJobSpec.concurrencyPolicy) && Objects.equals(this.failedJobsHistoryLimit, v1beta1CronJobSpec.failedJobsHistoryLimit) && Objects.equals(this.jobTemplate, v1beta1CronJobSpec.jobTemplate) && Objects.equals(this.schedule, v1beta1CronJobSpec.schedule) && Objects.equals(this.startingDeadlineSeconds, v1beta1CronJobSpec.startingDeadlineSeconds) && Objects.equals(this.successfulJobsHistoryLimit, v1beta1CronJobSpec.successfulJobsHistoryLimit) && Objects.equals(this.suspend, v1beta1CronJobSpec.suspend);
    }

    public int hashCode() {
        return Objects.hash(this.concurrencyPolicy, this.failedJobsHistoryLimit, this.jobTemplate, this.schedule, this.startingDeadlineSeconds, this.successfulJobsHistoryLimit, this.suspend);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CronJobSpec {\n");
        sb.append("    concurrencyPolicy: ").append(this.toIndentedString(this.concurrencyPolicy)).append("\n");
        sb.append("    failedJobsHistoryLimit: ").append(this.toIndentedString(this.failedJobsHistoryLimit)).append("\n");
        sb.append("    jobTemplate: ").append(this.toIndentedString(this.jobTemplate)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    startingDeadlineSeconds: ").append(this.toIndentedString(this.startingDeadlineSeconds)).append("\n");
        sb.append("    successfulJobsHistoryLimit: ").append(this.toIndentedString(this.successfulJobsHistoryLimit)).append("\n");
        sb.append("    suspend: ").append(this.toIndentedString(this.suspend)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

