/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1LabelSelector;
import io.kubernetes.client.models.V2beta1CrossVersionObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).")
public class V2beta1ObjectMetricStatus {
    @SerializedName(value="averageValue")
    private String averageValue = null;
    @SerializedName(value="currentValue")
    private String currentValue = null;
    @SerializedName(value="metricName")
    private String metricName = null;
    @SerializedName(value="selector")
    private V1LabelSelector selector = null;
    @SerializedName(value="target")
    private V2beta1CrossVersionObjectReference target = null;

    public V2beta1ObjectMetricStatus averageValue(String averageValue) {
        this.averageValue = averageValue;
        return this;
    }

    @ApiModelProperty(value="averageValue is the current value of the average of the metric across all relevant pods (as a quantity)")
    public String getAverageValue() {
        return this.averageValue;
    }

    public void setAverageValue(String averageValue) {
        this.averageValue = averageValue;
    }

    public V2beta1ObjectMetricStatus currentValue(String currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    @ApiModelProperty(required=true, value="currentValue is the current value of the metric (as a quantity).")
    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
    }

    public V2beta1ObjectMetricStatus metricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    @ApiModelProperty(required=true, value="metricName is the name of the metric in question.")
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public V2beta1ObjectMetricStatus selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @ApiModelProperty(value="selector is the string-encoded form of a standard kubernetes label selector for the given metric When set in the ObjectMetricSource, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V2beta1ObjectMetricStatus target(V2beta1CrossVersionObjectReference target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(required=true, value="target is the described Kubernetes object.")
    public V2beta1CrossVersionObjectReference getTarget() {
        return this.target;
    }

    public void setTarget(V2beta1CrossVersionObjectReference target) {
        this.target = target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1ObjectMetricStatus v2beta1ObjectMetricStatus = (V2beta1ObjectMetricStatus)o;
        return Objects.equals(this.averageValue, v2beta1ObjectMetricStatus.averageValue) && Objects.equals(this.currentValue, v2beta1ObjectMetricStatus.currentValue) && Objects.equals(this.metricName, v2beta1ObjectMetricStatus.metricName) && Objects.equals(this.selector, v2beta1ObjectMetricStatus.selector) && Objects.equals(this.target, v2beta1ObjectMetricStatus.target);
    }

    public int hashCode() {
        return Objects.hash(this.averageValue, this.currentValue, this.metricName, this.selector, this.target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2beta1ObjectMetricStatus {\n");
        sb.append("    averageValue: ").append(this.toIndentedString(this.averageValue)).append("\n");
        sb.append("    currentValue: ").append(this.toIndentedString(this.currentValue)).append("\n");
        sb.append("    metricName: ").append(this.toIndentedString(this.metricName)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

