package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1DeploymentConditionBuilder extends ExtensionsV1beta1DeploymentConditionFluentImpl<ExtensionsV1beta1DeploymentConditionBuilder> implements VisitableBuilder<ExtensionsV1beta1DeploymentCondition,ExtensionsV1beta1DeploymentConditionBuilder>{

    ExtensionsV1beta1DeploymentConditionFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1DeploymentConditionBuilder(){
            this(true);
    }
    public ExtensionsV1beta1DeploymentConditionBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1DeploymentCondition(), validationEnabled);
    }
    public ExtensionsV1beta1DeploymentConditionBuilder(ExtensionsV1beta1DeploymentConditionFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1DeploymentConditionBuilder(ExtensionsV1beta1DeploymentConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1DeploymentCondition(), validationEnabled);
    }
    public ExtensionsV1beta1DeploymentConditionBuilder(ExtensionsV1beta1DeploymentConditionFluent<?> fluent,ExtensionsV1beta1DeploymentCondition instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1DeploymentConditionBuilder(ExtensionsV1beta1DeploymentConditionFluent<?> fluent,ExtensionsV1beta1DeploymentCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLastTransitionTime(instance.getLastTransitionTime());

            fluent.withLastUpdateTime(instance.getLastUpdateTime());

            fluent.withMessage(instance.getMessage());

            fluent.withReason(instance.getReason());

            fluent.withStatus(instance.getStatus());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1DeploymentConditionBuilder(ExtensionsV1beta1DeploymentCondition instance){
            this(instance,true);
    }
    public ExtensionsV1beta1DeploymentConditionBuilder(ExtensionsV1beta1DeploymentCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLastTransitionTime(instance.getLastTransitionTime());

            this.withLastUpdateTime(instance.getLastUpdateTime());

            this.withMessage(instance.getMessage());

            this.withReason(instance.getReason());

            this.withStatus(instance.getStatus());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1DeploymentCondition build(){
            ExtensionsV1beta1DeploymentCondition buildable = new ExtensionsV1beta1DeploymentCondition();
            buildable.setLastTransitionTime(fluent.getLastTransitionTime());
            buildable.setLastUpdateTime(fluent.getLastUpdateTime());
            buildable.setMessage(fluent.getMessage());
            buildable.setReason(fluent.getReason());
            buildable.setStatus(fluent.getStatus());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1DeploymentConditionBuilder that = (ExtensionsV1beta1DeploymentConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
