package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1FlexVolumeSourceBuilder extends V1FlexVolumeSourceFluentImpl<V1FlexVolumeSourceBuilder> implements VisitableBuilder<V1FlexVolumeSource,V1FlexVolumeSourceBuilder>{

    V1FlexVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1FlexVolumeSourceBuilder(){
            this(true);
    }
    public V1FlexVolumeSourceBuilder(Boolean validationEnabled){
            this(new V1FlexVolumeSource(), validationEnabled);
    }
    public V1FlexVolumeSourceBuilder(V1FlexVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public V1FlexVolumeSourceBuilder(V1FlexVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1FlexVolumeSource(), validationEnabled);
    }
    public V1FlexVolumeSourceBuilder(V1FlexVolumeSourceFluent<?> fluent,V1FlexVolumeSource instance){
            this(fluent, instance, true);
    }
    public V1FlexVolumeSourceBuilder(V1FlexVolumeSourceFluent<?> fluent,V1FlexVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDriver(instance.getDriver());

            fluent.withFsType(instance.getFsType());

            fluent.withOptions(instance.getOptions());

            fluent.withReadOnly(instance.getReadOnly());

            fluent.withSecretRef(instance.getSecretRef());

            this.validationEnabled = validationEnabled; 
    }
    public V1FlexVolumeSourceBuilder(V1FlexVolumeSource instance){
            this(instance,true);
    }
    public V1FlexVolumeSourceBuilder(V1FlexVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDriver(instance.getDriver());

            this.withFsType(instance.getFsType());

            this.withOptions(instance.getOptions());

            this.withReadOnly(instance.getReadOnly());

            this.withSecretRef(instance.getSecretRef());

            this.validationEnabled = validationEnabled; 
    }

    public V1FlexVolumeSource build(){
            V1FlexVolumeSource buildable = new V1FlexVolumeSource();
            buildable.setDriver(fluent.getDriver());
            buildable.setFsType(fluent.getFsType());
            buildable.setOptions(fluent.getOptions());
            buildable.setReadOnly(fluent.isReadOnly());
            buildable.setSecretRef(fluent.getSecretRef());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1FlexVolumeSourceBuilder that = (V1FlexVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
