package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1LoadBalancerStatusFluentImpl<A extends V1LoadBalancerStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1LoadBalancerStatusFluent<A>{

    private List<V1LoadBalancerIngressBuilder> ingress;

    public V1LoadBalancerStatusFluentImpl(){
    }
    public V1LoadBalancerStatusFluentImpl(V1LoadBalancerStatus instance){
            this.withIngress(instance.getIngress());

    }

    public A addToIngress(int index,V1LoadBalancerIngress item){
            if (this.ingress == null) {this.ingress = new ArrayList<V1LoadBalancerIngressBuilder>();}
            V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);_visitables.get("ingress").add(index >= 0 ? index : _visitables.get("ingress").size(), builder);this.ingress.add(index >= 0 ? index : ingress.size(), builder); return (A)this;
    }

    public A setToIngress(int index,V1LoadBalancerIngress item){
            if (this.ingress == null) {this.ingress = new ArrayList<V1LoadBalancerIngressBuilder>();}
            V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);
            if (index < 0 || index >= _visitables.get("ingress").size()) { _visitables.get("ingress").add(builder); } else { _visitables.get("ingress").set(index, builder);}
            if (index < 0 || index >= ingress.size()) { ingress.add(builder); } else { ingress.set(index, builder);}
             return (A)this;
    }

    public A addToIngress(V1LoadBalancerIngress... items){
            if (this.ingress == null) {this.ingress = new ArrayList<V1LoadBalancerIngressBuilder>();}
            for (V1LoadBalancerIngress item : items) {V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
    }

    public A addAllToIngress(Collection<V1LoadBalancerIngress> items){
            if (this.ingress == null) {this.ingress = new ArrayList<V1LoadBalancerIngressBuilder>();}
            for (V1LoadBalancerIngress item : items) {V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
    }

    public A removeFromIngress(V1LoadBalancerIngress... items){
            for (V1LoadBalancerIngress item : items) {V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
    }

    public A removeAllFromIngress(Collection<V1LoadBalancerIngress> items){
            for (V1LoadBalancerIngress item : items) {V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromIngress(io.kubernetes.client.fluent.Predicate<V1LoadBalancerIngressBuilder> predicate){
            if (ingress == null) return (A) this;
            final Iterator<V1LoadBalancerIngressBuilder> each = ingress.iterator();
            final List visitables = _visitables.get("ingress");
            while (each.hasNext()) {
              V1LoadBalancerIngressBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIngress instead.
 * @return The buildable object.
 */
@Deprecated public List<V1LoadBalancerIngress> getIngress(){
            return build(ingress);
    }

    public List<V1LoadBalancerIngress> buildIngress(){
            return build(ingress);
    }

    public V1LoadBalancerIngress buildIngress(int index){
            return this.ingress.get(index).build();
    }

    public V1LoadBalancerIngress buildFirstIngress(){
            return this.ingress.get(0).build();
    }

    public V1LoadBalancerIngress buildLastIngress(){
            return this.ingress.get(ingress.size() - 1).build();
    }

    public V1LoadBalancerIngress buildMatchingIngress(io.kubernetes.client.fluent.Predicate<V1LoadBalancerIngressBuilder> predicate){
            for (V1LoadBalancerIngressBuilder item: ingress) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingIngress(io.kubernetes.client.fluent.Predicate<V1LoadBalancerIngressBuilder> predicate){
            for (V1LoadBalancerIngressBuilder item: ingress) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withIngress(List<V1LoadBalancerIngress> ingress){
            if (this.ingress != null) { _visitables.get("ingress").removeAll(this.ingress);}
            if (ingress != null) {this.ingress = new ArrayList<V1LoadBalancerIngressBuilder>(); for (V1LoadBalancerIngress item : ingress){this.addToIngress(item);}} else { this.ingress = null;} return (A) this;
    }

    public A withIngress(V1LoadBalancerIngress... ingress){
            if (this.ingress != null) {this.ingress.clear();}
            if (ingress != null) {for (V1LoadBalancerIngress item :ingress){ this.addToIngress(item);}} return (A) this;
    }

    public Boolean hasIngress(){
            return ingress != null && !ingress.isEmpty();
    }

    public V1LoadBalancerStatusFluent.IngressNested<A> addNewIngress(){
            return new IngressNestedImpl();
    }

    public V1LoadBalancerStatusFluent.IngressNested<A> addNewIngressLike(V1LoadBalancerIngress item){
            return new IngressNestedImpl(-1, item);
    }

    public V1LoadBalancerStatusFluent.IngressNested<A> setNewIngressLike(int index,V1LoadBalancerIngress item){
            return new IngressNestedImpl(index, item);
    }

    public V1LoadBalancerStatusFluent.IngressNested<A> editIngress(int index){
            if (ingress.size() <= index) throw new RuntimeException("Can't edit ingress. Index exceeds size.");
            return setNewIngressLike(index, buildIngress(index));
    }

    public V1LoadBalancerStatusFluent.IngressNested<A> editFirstIngress(){
            if (ingress.size() == 0) throw new RuntimeException("Can't edit first ingress. The list is empty.");
            return setNewIngressLike(0, buildIngress(0));
    }

    public V1LoadBalancerStatusFluent.IngressNested<A> editLastIngress(){
            int index = ingress.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ingress. The list is empty.");
            return setNewIngressLike(index, buildIngress(index));
    }

    public V1LoadBalancerStatusFluent.IngressNested<A> editMatchingIngress(io.kubernetes.client.fluent.Predicate<V1LoadBalancerIngressBuilder> predicate){
            int index = -1;
            for (int i=0;i<ingress.size();i++) { 
            if (predicate.apply(ingress.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ingress. No match found.");
            return setNewIngressLike(index, buildIngress(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1LoadBalancerStatusFluentImpl that = (V1LoadBalancerStatusFluentImpl) o;
            if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
            return true;
    }


    public class IngressNestedImpl<N> extends V1LoadBalancerIngressFluentImpl<V1LoadBalancerStatusFluent.IngressNested<N>> implements V1LoadBalancerStatusFluent.IngressNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LoadBalancerIngressBuilder builder;
        private final int index;
    
            IngressNestedImpl(int index,V1LoadBalancerIngress item){
                    this.index = index;
                    this.builder = new V1LoadBalancerIngressBuilder(this, item);
            }
            IngressNestedImpl(){
                    this.index = -1;
                    this.builder = new V1LoadBalancerIngressBuilder(this);
            }
    
    public N and(){
            return (N) V1LoadBalancerStatusFluentImpl.this.setToIngress(index, builder.build());
    }
    public N endIngress(){
            return and();
    }

}


}
