package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1SecretVolumeSourceFluentImpl<A extends V1SecretVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1SecretVolumeSourceFluent<A>{

    private Integer defaultMode;
    private List<V1KeyToPathBuilder> items;
    private Boolean optional;
    private String secretName;

    public V1SecretVolumeSourceFluentImpl(){
    }
    public V1SecretVolumeSourceFluentImpl(V1SecretVolumeSource instance){
            this.withDefaultMode(instance.getDefaultMode());

            this.withItems(instance.getItems());

            this.withOptional(instance.getOptional());

            this.withSecretName(instance.getSecretName());

    }

    public Integer getDefaultMode(){
            return this.defaultMode;
    }

    public A withDefaultMode(Integer defaultMode){
            this.defaultMode=defaultMode; return (A) this;
    }

    public Boolean hasDefaultMode(){
            return this.defaultMode != null;
    }

    public A addToItems(int index,V1KeyToPath item){
            if (this.items == null) {this.items = new ArrayList<V1KeyToPathBuilder>();}
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,V1KeyToPath item){
            if (this.items == null) {this.items = new ArrayList<V1KeyToPathBuilder>();}
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
            if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(V1KeyToPath... items){
            if (this.items == null) {this.items = new ArrayList<V1KeyToPathBuilder>();}
            for (V1KeyToPath item : items) {V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<V1KeyToPath> items){
            if (this.items == null) {this.items = new ArrayList<V1KeyToPathBuilder>();}
            for (V1KeyToPath item : items) {V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(V1KeyToPath... items){
            for (V1KeyToPath item : items) {V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<V1KeyToPath> items){
            for (V1KeyToPath item : items) {V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromItems(io.kubernetes.client.fluent.Predicate<V1KeyToPathBuilder> predicate){
            if (items == null) return (A) this;
            final Iterator<V1KeyToPathBuilder> each = items.iterator();
            final List visitables = _visitables.get("items");
            while (each.hasNext()) {
              V1KeyToPathBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1KeyToPath> getItems(){
            return build(items);
    }

    public List<V1KeyToPath> buildItems(){
            return build(items);
    }

    public V1KeyToPath buildItem(int index){
            return this.items.get(index).build();
    }

    public V1KeyToPath buildFirstItem(){
            return this.items.get(0).build();
    }

    public V1KeyToPath buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public V1KeyToPath buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1KeyToPathBuilder> predicate){
            for (V1KeyToPathBuilder item: items) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingItem(io.kubernetes.client.fluent.Predicate<V1KeyToPathBuilder> predicate){
            for (V1KeyToPathBuilder item: items) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withItems(List<V1KeyToPath> items){
            if (this.items != null) { _visitables.get("items").removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<V1KeyToPathBuilder>(); for (V1KeyToPath item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(V1KeyToPath... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (V1KeyToPath item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public V1SecretVolumeSourceFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public V1SecretVolumeSourceFluent.ItemsNested<A> addNewItemLike(V1KeyToPath item){
            return new ItemsNestedImpl(-1, item);
    }

    public V1SecretVolumeSourceFluent.ItemsNested<A> setNewItemLike(int index,V1KeyToPath item){
            return new ItemsNestedImpl(index, item);
    }

    public V1SecretVolumeSourceFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1SecretVolumeSourceFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public V1SecretVolumeSourceFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1SecretVolumeSourceFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1KeyToPathBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public Boolean isOptional(){
            return this.optional;
    }

    public A withOptional(Boolean optional){
            this.optional=optional; return (A) this;
    }

    public Boolean hasOptional(){
            return this.optional != null;
    }

    public A withNewOptional(String arg1){
            return (A)withOptional(new Boolean(arg1));
    }

    public A withNewOptional(boolean arg1){
            return (A)withOptional(new Boolean(arg1));
    }

    public String getSecretName(){
            return this.secretName;
    }

    public A withSecretName(String secretName){
            this.secretName=secretName; return (A) this;
    }

    public Boolean hasSecretName(){
            return this.secretName != null;
    }

    public A withNewSecretName(String arg1){
            return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(StringBuilder arg1){
            return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(StringBuffer arg1){
            return (A)withSecretName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1SecretVolumeSourceFluentImpl that = (V1SecretVolumeSourceFluentImpl) o;
            if (defaultMode != null ? !defaultMode.equals(that.defaultMode) :that.defaultMode != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (optional != null ? !optional.equals(that.optional) :that.optional != null) return false;
            if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends V1KeyToPathFluentImpl<V1SecretVolumeSourceFluent.ItemsNested<N>> implements V1SecretVolumeSourceFluent.ItemsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1KeyToPathBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,V1KeyToPath item){
                    this.index = index;
                    this.builder = new V1KeyToPathBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1KeyToPathBuilder(this);
            }
    
    public N and(){
            return (N) V1SecretVolumeSourceFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
