package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1beta1CSINodeSpecFluentImpl<A extends V1beta1CSINodeSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1CSINodeSpecFluent<A>{

    private List<V1beta1CSINodeDriverBuilder> drivers;

    public V1beta1CSINodeSpecFluentImpl(){
    }
    public V1beta1CSINodeSpecFluentImpl(V1beta1CSINodeSpec instance){
            this.withDrivers(instance.getDrivers());

    }

    public A addToDrivers(int index,V1beta1CSINodeDriver item){
            if (this.drivers == null) {this.drivers = new ArrayList<V1beta1CSINodeDriverBuilder>();}
            V1beta1CSINodeDriverBuilder builder = new V1beta1CSINodeDriverBuilder(item);_visitables.get("drivers").add(index >= 0 ? index : _visitables.get("drivers").size(), builder);this.drivers.add(index >= 0 ? index : drivers.size(), builder); return (A)this;
    }

    public A setToDrivers(int index,V1beta1CSINodeDriver item){
            if (this.drivers == null) {this.drivers = new ArrayList<V1beta1CSINodeDriverBuilder>();}
            V1beta1CSINodeDriverBuilder builder = new V1beta1CSINodeDriverBuilder(item);
            if (index < 0 || index >= _visitables.get("drivers").size()) { _visitables.get("drivers").add(builder); } else { _visitables.get("drivers").set(index, builder);}
            if (index < 0 || index >= drivers.size()) { drivers.add(builder); } else { drivers.set(index, builder);}
             return (A)this;
    }

    public A addToDrivers(V1beta1CSINodeDriver... items){
            if (this.drivers == null) {this.drivers = new ArrayList<V1beta1CSINodeDriverBuilder>();}
            for (V1beta1CSINodeDriver item : items) {V1beta1CSINodeDriverBuilder builder = new V1beta1CSINodeDriverBuilder(item);_visitables.get("drivers").add(builder);this.drivers.add(builder);} return (A)this;
    }

    public A addAllToDrivers(Collection<V1beta1CSINodeDriver> items){
            if (this.drivers == null) {this.drivers = new ArrayList<V1beta1CSINodeDriverBuilder>();}
            for (V1beta1CSINodeDriver item : items) {V1beta1CSINodeDriverBuilder builder = new V1beta1CSINodeDriverBuilder(item);_visitables.get("drivers").add(builder);this.drivers.add(builder);} return (A)this;
    }

    public A removeFromDrivers(V1beta1CSINodeDriver... items){
            for (V1beta1CSINodeDriver item : items) {V1beta1CSINodeDriverBuilder builder = new V1beta1CSINodeDriverBuilder(item);_visitables.get("drivers").remove(builder);if (this.drivers != null) {this.drivers.remove(builder);}} return (A)this;
    }

    public A removeAllFromDrivers(Collection<V1beta1CSINodeDriver> items){
            for (V1beta1CSINodeDriver item : items) {V1beta1CSINodeDriverBuilder builder = new V1beta1CSINodeDriverBuilder(item);_visitables.get("drivers").remove(builder);if (this.drivers != null) {this.drivers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromDrivers(io.kubernetes.client.fluent.Predicate<V1beta1CSINodeDriverBuilder> predicate){
            if (drivers == null) return (A) this;
            final Iterator<V1beta1CSINodeDriverBuilder> each = drivers.iterator();
            final List visitables = _visitables.get("drivers");
            while (each.hasNext()) {
              V1beta1CSINodeDriverBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildDrivers instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1CSINodeDriver> getDrivers(){
            return build(drivers);
    }

    public List<V1beta1CSINodeDriver> buildDrivers(){
            return build(drivers);
    }

    public V1beta1CSINodeDriver buildDriver(int index){
            return this.drivers.get(index).build();
    }

    public V1beta1CSINodeDriver buildFirstDriver(){
            return this.drivers.get(0).build();
    }

    public V1beta1CSINodeDriver buildLastDriver(){
            return this.drivers.get(drivers.size() - 1).build();
    }

    public V1beta1CSINodeDriver buildMatchingDriver(io.kubernetes.client.fluent.Predicate<V1beta1CSINodeDriverBuilder> predicate){
            for (V1beta1CSINodeDriverBuilder item: drivers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingDriver(io.kubernetes.client.fluent.Predicate<V1beta1CSINodeDriverBuilder> predicate){
            for (V1beta1CSINodeDriverBuilder item: drivers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withDrivers(List<V1beta1CSINodeDriver> drivers){
            if (this.drivers != null) { _visitables.get("drivers").removeAll(this.drivers);}
            if (drivers != null) {this.drivers = new ArrayList<V1beta1CSINodeDriverBuilder>(); for (V1beta1CSINodeDriver item : drivers){this.addToDrivers(item);}} else { this.drivers = null;} return (A) this;
    }

    public A withDrivers(V1beta1CSINodeDriver... drivers){
            if (this.drivers != null) {this.drivers.clear();}
            if (drivers != null) {for (V1beta1CSINodeDriver item :drivers){ this.addToDrivers(item);}} return (A) this;
    }

    public Boolean hasDrivers(){
            return drivers != null && !drivers.isEmpty();
    }

    public V1beta1CSINodeSpecFluent.DriversNested<A> addNewDriver(){
            return new DriversNestedImpl();
    }

    public V1beta1CSINodeSpecFluent.DriversNested<A> addNewDriverLike(V1beta1CSINodeDriver item){
            return new DriversNestedImpl(-1, item);
    }

    public V1beta1CSINodeSpecFluent.DriversNested<A> setNewDriverLike(int index,V1beta1CSINodeDriver item){
            return new DriversNestedImpl(index, item);
    }

    public V1beta1CSINodeSpecFluent.DriversNested<A> editDriver(int index){
            if (drivers.size() <= index) throw new RuntimeException("Can't edit drivers. Index exceeds size.");
            return setNewDriverLike(index, buildDriver(index));
    }

    public V1beta1CSINodeSpecFluent.DriversNested<A> editFirstDriver(){
            if (drivers.size() == 0) throw new RuntimeException("Can't edit first drivers. The list is empty.");
            return setNewDriverLike(0, buildDriver(0));
    }

    public V1beta1CSINodeSpecFluent.DriversNested<A> editLastDriver(){
            int index = drivers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last drivers. The list is empty.");
            return setNewDriverLike(index, buildDriver(index));
    }

    public V1beta1CSINodeSpecFluent.DriversNested<A> editMatchingDriver(io.kubernetes.client.fluent.Predicate<V1beta1CSINodeDriverBuilder> predicate){
            int index = -1;
            for (int i=0;i<drivers.size();i++) { 
            if (predicate.apply(drivers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching drivers. No match found.");
            return setNewDriverLike(index, buildDriver(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1beta1CSINodeSpecFluentImpl that = (V1beta1CSINodeSpecFluentImpl) o;
            if (drivers != null ? !drivers.equals(that.drivers) :that.drivers != null) return false;
            return true;
    }


    public class DriversNestedImpl<N> extends V1beta1CSINodeDriverFluentImpl<V1beta1CSINodeSpecFluent.DriversNested<N>> implements V1beta1CSINodeSpecFluent.DriversNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1CSINodeDriverBuilder builder;
        private final int index;
    
            DriversNestedImpl(int index,V1beta1CSINodeDriver item){
                    this.index = index;
                    this.builder = new V1beta1CSINodeDriverBuilder(this, item);
            }
            DriversNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1CSINodeDriverBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1CSINodeSpecFluentImpl.this.setToDrivers(index, builder.build());
    }
    public N endDriver(){
            return and();
    }

}


}
