/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1NodeConfigSource;
import io.kubernetes.client.openapi.models.V1Taint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="NodeSpec describes the attributes that a node is created with.")
public class V1NodeSpec {
    public static final String SERIALIZED_NAME_CONFIG_SOURCE = "configSource";
    @SerializedName(value="configSource")
    private V1NodeConfigSource configSource;
    public static final String SERIALIZED_NAME_EXTERNAL_I_D = "externalID";
    @SerializedName(value="externalID")
    private String externalID;
    public static final String SERIALIZED_NAME_POD_C_I_D_R = "podCIDR";
    @SerializedName(value="podCIDR")
    private String podCIDR;
    public static final String SERIALIZED_NAME_PROVIDER_I_D = "providerID";
    @SerializedName(value="providerID")
    private String providerID;
    public static final String SERIALIZED_NAME_TAINTS = "taints";
    @SerializedName(value="taints")
    private List<V1Taint> taints = null;
    public static final String SERIALIZED_NAME_UNSCHEDULABLE = "unschedulable";
    @SerializedName(value="unschedulable")
    private Boolean unschedulable;

    public V1NodeSpec configSource(V1NodeConfigSource configSource) {
        this.configSource = configSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeConfigSource getConfigSource() {
        return this.configSource;
    }

    public void setConfigSource(V1NodeConfigSource configSource) {
        this.configSource = configSource;
    }

    public V1NodeSpec externalID(String externalID) {
        this.externalID = externalID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated. Not all kubelets will set this field. Remove field after 1.13. see: https://issues.k8s.io/61966")
    public String getExternalID() {
        return this.externalID;
    }

    public void setExternalID(String externalID) {
        this.externalID = externalID;
    }

    public V1NodeSpec podCIDR(String podCIDR) {
        this.podCIDR = podCIDR;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PodCIDR represents the pod IP range assigned to the node.")
    public String getPodCIDR() {
        return this.podCIDR;
    }

    public void setPodCIDR(String podCIDR) {
        this.podCIDR = podCIDR;
    }

    public V1NodeSpec providerID(String providerID) {
        this.providerID = providerID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>")
    public String getProviderID() {
        return this.providerID;
    }

    public void setProviderID(String providerID) {
        this.providerID = providerID;
    }

    public V1NodeSpec taints(List<V1Taint> taints) {
        this.taints = taints;
        return this;
    }

    public V1NodeSpec addTaintsItem(V1Taint taintsItem) {
        if (this.taints == null) {
            this.taints = new ArrayList<V1Taint>();
        }
        this.taints.add(taintsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, the node's taints.")
    public List<V1Taint> getTaints() {
        return this.taints;
    }

    public void setTaints(List<V1Taint> taints) {
        this.taints = taints;
    }

    public V1NodeSpec unschedulable(Boolean unschedulable) {
        this.unschedulable = unschedulable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration")
    public Boolean getUnschedulable() {
        return this.unschedulable;
    }

    public void setUnschedulable(Boolean unschedulable) {
        this.unschedulable = unschedulable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NodeSpec v1NodeSpec = (V1NodeSpec)o;
        return Objects.equals(this.configSource, v1NodeSpec.configSource) && Objects.equals(this.externalID, v1NodeSpec.externalID) && Objects.equals(this.podCIDR, v1NodeSpec.podCIDR) && Objects.equals(this.providerID, v1NodeSpec.providerID) && Objects.equals(this.taints, v1NodeSpec.taints) && Objects.equals(this.unschedulable, v1NodeSpec.unschedulable);
    }

    public int hashCode() {
        return Objects.hash(this.configSource, this.externalID, this.podCIDR, this.providerID, this.taints, this.unschedulable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NodeSpec {\n");
        sb.append("    configSource: ").append(this.toIndentedString(this.configSource)).append("\n");
        sb.append("    externalID: ").append(this.toIndentedString(this.externalID)).append("\n");
        sb.append("    podCIDR: ").append(this.toIndentedString(this.podCIDR)).append("\n");
        sb.append("    providerID: ").append(this.toIndentedString(this.providerID)).append("\n");
        sb.append("    taints: ").append(this.toIndentedString(this.taints)).append("\n");
        sb.append("    unschedulable: ").append(this.toIndentedString(this.unschedulable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

