/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CSIDriverSpec is the specification of a CSIDriver.")
public class V1beta1CSIDriverSpec {
    public static final String SERIALIZED_NAME_ATTACH_REQUIRED = "attachRequired";
    @SerializedName(value="attachRequired")
    private Boolean attachRequired;
    public static final String SERIALIZED_NAME_POD_INFO_ON_MOUNT = "podInfoOnMount";
    @SerializedName(value="podInfoOnMount")
    private Boolean podInfoOnMount;

    public V1beta1CSIDriverSpec attachRequired(Boolean attachRequired) {
        this.attachRequired = attachRequired;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting. The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.")
    public Boolean getAttachRequired() {
        return this.attachRequired;
    }

    public void setAttachRequired(Boolean attachRequired) {
        this.attachRequired = attachRequired;
    }

    public V1beta1CSIDriverSpec podInfoOnMount(Boolean podInfoOnMount) {
        this.podInfoOnMount = podInfoOnMount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to true, podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations. If set to false, pod information will not be passed on mount. Default is false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. \"csi.storage.k8s.io/pod.name\": pod.Name \"csi.storage.k8s.io/pod.namespace\": pod.Namespace \"csi.storage.k8s.io/pod.uid\": string(pod.UID)")
    public Boolean getPodInfoOnMount() {
        return this.podInfoOnMount;
    }

    public void setPodInfoOnMount(Boolean podInfoOnMount) {
        this.podInfoOnMount = podInfoOnMount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CSIDriverSpec v1beta1CSIDriverSpec = (V1beta1CSIDriverSpec)o;
        return Objects.equals(this.attachRequired, v1beta1CSIDriverSpec.attachRequired) && Objects.equals(this.podInfoOnMount, v1beta1CSIDriverSpec.podInfoOnMount);
    }

    public int hashCode() {
        return Objects.hash(this.attachRequired, this.podInfoOnMount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CSIDriverSpec {\n");
        sb.append("    attachRequired: ").append(this.toIndentedString(this.attachRequired)).append("\n");
        sb.append("    podInfoOnMount: ").append(this.toIndentedString(this.podInfoOnMount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

