package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AdmissionregistrationV1beta1ServiceReferenceBuilder extends AdmissionregistrationV1beta1ServiceReferenceFluentImpl<AdmissionregistrationV1beta1ServiceReferenceBuilder> implements VisitableBuilder<AdmissionregistrationV1beta1ServiceReference,AdmissionregistrationV1beta1ServiceReferenceBuilder>{

    AdmissionregistrationV1beta1ServiceReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public AdmissionregistrationV1beta1ServiceReferenceBuilder(){
            this(true);
    }
    public AdmissionregistrationV1beta1ServiceReferenceBuilder(Boolean validationEnabled){
            this(new AdmissionregistrationV1beta1ServiceReference(), validationEnabled);
    }
    public AdmissionregistrationV1beta1ServiceReferenceBuilder(AdmissionregistrationV1beta1ServiceReferenceFluent<?> fluent){
            this(fluent, true);
    }
    public AdmissionregistrationV1beta1ServiceReferenceBuilder(AdmissionregistrationV1beta1ServiceReferenceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AdmissionregistrationV1beta1ServiceReference(), validationEnabled);
    }
    public AdmissionregistrationV1beta1ServiceReferenceBuilder(AdmissionregistrationV1beta1ServiceReferenceFluent<?> fluent,AdmissionregistrationV1beta1ServiceReference instance){
            this(fluent, instance, true);
    }
    public AdmissionregistrationV1beta1ServiceReferenceBuilder(AdmissionregistrationV1beta1ServiceReferenceFluent<?> fluent,AdmissionregistrationV1beta1ServiceReference instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withNamespace(instance.getNamespace());

            fluent.withPath(instance.getPath());

            fluent.withPort(instance.getPort());

            this.validationEnabled = validationEnabled; 
    }
    public AdmissionregistrationV1beta1ServiceReferenceBuilder(AdmissionregistrationV1beta1ServiceReference instance){
            this(instance,true);
    }
    public AdmissionregistrationV1beta1ServiceReferenceBuilder(AdmissionregistrationV1beta1ServiceReference instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withNamespace(instance.getNamespace());

            this.withPath(instance.getPath());

            this.withPort(instance.getPort());

            this.validationEnabled = validationEnabled; 
    }

    public AdmissionregistrationV1beta1ServiceReference build(){
            AdmissionregistrationV1beta1ServiceReference buildable = new AdmissionregistrationV1beta1ServiceReference();
            buildable.setName(fluent.getName());
            buildable.setNamespace(fluent.getNamespace());
            buildable.setPath(fluent.getPath());
            buildable.setPort(fluent.getPort());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AdmissionregistrationV1beta1ServiceReferenceBuilder that = (AdmissionregistrationV1beta1ServiceReferenceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
