package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface AppsV1beta1DeploymentSpecFluent<A extends AppsV1beta1DeploymentSpecFluent<A>> extends Fluent<A>{


    public Integer getMinReadySeconds();
    public A withMinReadySeconds(Integer minReadySeconds);
    public Boolean hasMinReadySeconds();
    public Boolean isPaused();
    public A withPaused(Boolean paused);
    public Boolean hasPaused();
    public A withNewPaused(String arg1);
    public A withNewPaused(boolean arg1);
    public Integer getProgressDeadlineSeconds();
    public A withProgressDeadlineSeconds(Integer progressDeadlineSeconds);
    public Boolean hasProgressDeadlineSeconds();
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public Integer getRevisionHistoryLimit();
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit);
    public Boolean hasRevisionHistoryLimit();
    
/**
 * This method has been deprecated, please use method buildRollbackTo instead.
 * @return The buildable object.
 */
@Deprecated public AppsV1beta1RollbackConfig getRollbackTo();
    public AppsV1beta1RollbackConfig buildRollbackTo();
    public A withRollbackTo(AppsV1beta1RollbackConfig rollbackTo);
    public Boolean hasRollbackTo();
    public AppsV1beta1DeploymentSpecFluent.RollbackToNested<A> withNewRollbackTo();
    public AppsV1beta1DeploymentSpecFluent.RollbackToNested<A> withNewRollbackToLike(AppsV1beta1RollbackConfig item);
    public AppsV1beta1DeploymentSpecFluent.RollbackToNested<A> editRollbackTo();
    public AppsV1beta1DeploymentSpecFluent.RollbackToNested<A> editOrNewRollbackTo();
    public AppsV1beta1DeploymentSpecFluent.RollbackToNested<A> editOrNewRollbackToLike(AppsV1beta1RollbackConfig item);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector();
    public V1LabelSelector buildSelector();
    public A withSelector(V1LabelSelector selector);
    public Boolean hasSelector();
    public AppsV1beta1DeploymentSpecFluent.SelectorNested<A> withNewSelector();
    public AppsV1beta1DeploymentSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item);
    public AppsV1beta1DeploymentSpecFluent.SelectorNested<A> editSelector();
    public AppsV1beta1DeploymentSpecFluent.SelectorNested<A> editOrNewSelector();
    public AppsV1beta1DeploymentSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item);
    
/**
 * This method has been deprecated, please use method buildStrategy instead.
 * @return The buildable object.
 */
@Deprecated public AppsV1beta1DeploymentStrategy getStrategy();
    public AppsV1beta1DeploymentStrategy buildStrategy();
    public A withStrategy(AppsV1beta1DeploymentStrategy strategy);
    public Boolean hasStrategy();
    public AppsV1beta1DeploymentSpecFluent.StrategyNested<A> withNewStrategy();
    public AppsV1beta1DeploymentSpecFluent.StrategyNested<A> withNewStrategyLike(AppsV1beta1DeploymentStrategy item);
    public AppsV1beta1DeploymentSpecFluent.StrategyNested<A> editStrategy();
    public AppsV1beta1DeploymentSpecFluent.StrategyNested<A> editOrNewStrategy();
    public AppsV1beta1DeploymentSpecFluent.StrategyNested<A> editOrNewStrategyLike(AppsV1beta1DeploymentStrategy item);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1PodTemplateSpec getTemplate();
    public V1PodTemplateSpec buildTemplate();
    public A withTemplate(V1PodTemplateSpec template);
    public Boolean hasTemplate();
    public AppsV1beta1DeploymentSpecFluent.TemplateNested<A> withNewTemplate();
    public AppsV1beta1DeploymentSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item);
    public AppsV1beta1DeploymentSpecFluent.TemplateNested<A> editTemplate();
    public AppsV1beta1DeploymentSpecFluent.TemplateNested<A> editOrNewTemplate();
    public AppsV1beta1DeploymentSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item);

    public interface RollbackToNested<N> extends io.kubernetes.client.fluent.Nested<N>,AppsV1beta1RollbackConfigFluent<AppsV1beta1DeploymentSpecFluent.RollbackToNested<N>>{

        
    public N and();    public N endRollbackTo();
}
    public interface SelectorNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1LabelSelectorFluent<AppsV1beta1DeploymentSpecFluent.SelectorNested<N>>{

        
    public N and();    public N endSelector();
}
    public interface StrategyNested<N> extends io.kubernetes.client.fluent.Nested<N>,AppsV1beta1DeploymentStrategyFluent<AppsV1beta1DeploymentSpecFluent.StrategyNested<N>>{

        
    public N and();    public N endStrategy();
}
    public interface TemplateNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PodTemplateSpecFluent<AppsV1beta1DeploymentSpecFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}


}
