package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AppsV1beta1RollingUpdateDeploymentBuilder extends AppsV1beta1RollingUpdateDeploymentFluentImpl<AppsV1beta1RollingUpdateDeploymentBuilder> implements VisitableBuilder<AppsV1beta1RollingUpdateDeployment,AppsV1beta1RollingUpdateDeploymentBuilder>{

    AppsV1beta1RollingUpdateDeploymentFluent<?> fluent;
    Boolean validationEnabled;

    public AppsV1beta1RollingUpdateDeploymentBuilder(){
            this(true);
    }
    public AppsV1beta1RollingUpdateDeploymentBuilder(Boolean validationEnabled){
            this(new AppsV1beta1RollingUpdateDeployment(), validationEnabled);
    }
    public AppsV1beta1RollingUpdateDeploymentBuilder(AppsV1beta1RollingUpdateDeploymentFluent<?> fluent){
            this(fluent, true);
    }
    public AppsV1beta1RollingUpdateDeploymentBuilder(AppsV1beta1RollingUpdateDeploymentFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AppsV1beta1RollingUpdateDeployment(), validationEnabled);
    }
    public AppsV1beta1RollingUpdateDeploymentBuilder(AppsV1beta1RollingUpdateDeploymentFluent<?> fluent,AppsV1beta1RollingUpdateDeployment instance){
            this(fluent, instance, true);
    }
    public AppsV1beta1RollingUpdateDeploymentBuilder(AppsV1beta1RollingUpdateDeploymentFluent<?> fluent,AppsV1beta1RollingUpdateDeployment instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMaxSurge(instance.getMaxSurge());

            fluent.withMaxUnavailable(instance.getMaxUnavailable());

            this.validationEnabled = validationEnabled; 
    }
    public AppsV1beta1RollingUpdateDeploymentBuilder(AppsV1beta1RollingUpdateDeployment instance){
            this(instance,true);
    }
    public AppsV1beta1RollingUpdateDeploymentBuilder(AppsV1beta1RollingUpdateDeployment instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMaxSurge(instance.getMaxSurge());

            this.withMaxUnavailable(instance.getMaxUnavailable());

            this.validationEnabled = validationEnabled; 
    }

    public AppsV1beta1RollingUpdateDeployment build(){
            AppsV1beta1RollingUpdateDeployment buildable = new AppsV1beta1RollingUpdateDeployment();
            buildable.setMaxSurge(fluent.getMaxSurge());
            buildable.setMaxUnavailable(fluent.getMaxUnavailable());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AppsV1beta1RollingUpdateDeploymentBuilder that = (AppsV1beta1RollingUpdateDeploymentBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
