package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1IDRangeBuilder extends ExtensionsV1beta1IDRangeFluentImpl<ExtensionsV1beta1IDRangeBuilder> implements VisitableBuilder<ExtensionsV1beta1IDRange,ExtensionsV1beta1IDRangeBuilder>{

    ExtensionsV1beta1IDRangeFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1IDRangeBuilder(){
            this(true);
    }
    public ExtensionsV1beta1IDRangeBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1IDRange(), validationEnabled);
    }
    public ExtensionsV1beta1IDRangeBuilder(ExtensionsV1beta1IDRangeFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1IDRangeBuilder(ExtensionsV1beta1IDRangeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1IDRange(), validationEnabled);
    }
    public ExtensionsV1beta1IDRangeBuilder(ExtensionsV1beta1IDRangeFluent<?> fluent,ExtensionsV1beta1IDRange instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1IDRangeBuilder(ExtensionsV1beta1IDRangeFluent<?> fluent,ExtensionsV1beta1IDRange instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMax(instance.getMax());

            fluent.withMin(instance.getMin());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1IDRangeBuilder(ExtensionsV1beta1IDRange instance){
            this(instance,true);
    }
    public ExtensionsV1beta1IDRangeBuilder(ExtensionsV1beta1IDRange instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMax(instance.getMax());

            this.withMin(instance.getMin());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1IDRange build(){
            ExtensionsV1beta1IDRange buildable = new ExtensionsV1beta1IDRange();
            buildable.setMax(fluent.getMax());
            buildable.setMin(fluent.getMin());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1IDRangeBuilder that = (ExtensionsV1beta1IDRangeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
