package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.lang.StringBuilder;
import io.kubernetes.client.fluent.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.StringBuffer;

public class ExtensionsV1beta1PodSecurityPolicySpecFluentImpl<A extends ExtensionsV1beta1PodSecurityPolicySpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements ExtensionsV1beta1PodSecurityPolicySpecFluent<A>{

    private Boolean allowPrivilegeEscalation;
    private List<ExtensionsV1beta1AllowedCSIDriverBuilder> allowedCSIDrivers;
    private List<String> allowedCapabilities;
    private List<ExtensionsV1beta1AllowedFlexVolumeBuilder> allowedFlexVolumes;
    private List<ExtensionsV1beta1AllowedHostPathBuilder> allowedHostPaths;
    private List<String> allowedProcMountTypes;
    private List<String> allowedUnsafeSysctls;
    private List<String> defaultAddCapabilities;
    private Boolean defaultAllowPrivilegeEscalation;
    private List<String> forbiddenSysctls;
    private ExtensionsV1beta1FSGroupStrategyOptionsBuilder fsGroup;
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private List<ExtensionsV1beta1HostPortRangeBuilder> hostPorts;
    private Boolean privileged;
    private Boolean readOnlyRootFilesystem;
    private List<String> requiredDropCapabilities;
    private ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder runAsGroup;
    private ExtensionsV1beta1RunAsUserStrategyOptionsBuilder runAsUser;
    private ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder runtimeClass;
    private ExtensionsV1beta1SELinuxStrategyOptionsBuilder seLinux;
    private ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder supplementalGroups;
    private List<String> volumes;

    public ExtensionsV1beta1PodSecurityPolicySpecFluentImpl(){
    }
    public ExtensionsV1beta1PodSecurityPolicySpecFluentImpl(ExtensionsV1beta1PodSecurityPolicySpec instance){
            this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());

            this.withAllowedCSIDrivers(instance.getAllowedCSIDrivers());

            this.withAllowedCapabilities(instance.getAllowedCapabilities());

            this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes());

            this.withAllowedHostPaths(instance.getAllowedHostPaths());

            this.withAllowedProcMountTypes(instance.getAllowedProcMountTypes());

            this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls());

            this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());

            this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation());

            this.withForbiddenSysctls(instance.getForbiddenSysctls());

            this.withFsGroup(instance.getFsGroup());

            this.withHostIPC(instance.getHostIPC());

            this.withHostNetwork(instance.getHostNetwork());

            this.withHostPID(instance.getHostPID());

            this.withHostPorts(instance.getHostPorts());

            this.withPrivileged(instance.getPrivileged());

            this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());

            this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());

            this.withRunAsGroup(instance.getRunAsGroup());

            this.withRunAsUser(instance.getRunAsUser());

            this.withRuntimeClass(instance.getRuntimeClass());

            this.withSeLinux(instance.getSeLinux());

            this.withSupplementalGroups(instance.getSupplementalGroups());

            this.withVolumes(instance.getVolumes());

    }

    public Boolean isAllowPrivilegeEscalation(){
            return this.allowPrivilegeEscalation;
    }

    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation){
            this.allowPrivilegeEscalation=allowPrivilegeEscalation; return (A) this;
    }

    public Boolean hasAllowPrivilegeEscalation(){
            return this.allowPrivilegeEscalation != null;
    }

    public A withNewAllowPrivilegeEscalation(String arg1){
            return (A)withAllowPrivilegeEscalation(new Boolean(arg1));
    }

    public A withNewAllowPrivilegeEscalation(boolean arg1){
            return (A)withAllowPrivilegeEscalation(new Boolean(arg1));
    }

    public A addToAllowedCSIDrivers(int index,ExtensionsV1beta1AllowedCSIDriver item){
            if (this.allowedCSIDrivers == null) {this.allowedCSIDrivers = new ArrayList<ExtensionsV1beta1AllowedCSIDriverBuilder>();}
            ExtensionsV1beta1AllowedCSIDriverBuilder builder = new ExtensionsV1beta1AllowedCSIDriverBuilder(item);_visitables.get("allowedCSIDrivers").add(index >= 0 ? index : _visitables.get("allowedCSIDrivers").size(), builder);this.allowedCSIDrivers.add(index >= 0 ? index : allowedCSIDrivers.size(), builder); return (A)this;
    }

    public A setToAllowedCSIDrivers(int index,ExtensionsV1beta1AllowedCSIDriver item){
            if (this.allowedCSIDrivers == null) {this.allowedCSIDrivers = new ArrayList<ExtensionsV1beta1AllowedCSIDriverBuilder>();}
            ExtensionsV1beta1AllowedCSIDriverBuilder builder = new ExtensionsV1beta1AllowedCSIDriverBuilder(item);
            if (index < 0 || index >= _visitables.get("allowedCSIDrivers").size()) { _visitables.get("allowedCSIDrivers").add(builder); } else { _visitables.get("allowedCSIDrivers").set(index, builder);}
            if (index < 0 || index >= allowedCSIDrivers.size()) { allowedCSIDrivers.add(builder); } else { allowedCSIDrivers.set(index, builder);}
             return (A)this;
    }

    public A addToAllowedCSIDrivers(ExtensionsV1beta1AllowedCSIDriver... items){
            if (this.allowedCSIDrivers == null) {this.allowedCSIDrivers = new ArrayList<ExtensionsV1beta1AllowedCSIDriverBuilder>();}
            for (ExtensionsV1beta1AllowedCSIDriver item : items) {ExtensionsV1beta1AllowedCSIDriverBuilder builder = new ExtensionsV1beta1AllowedCSIDriverBuilder(item);_visitables.get("allowedCSIDrivers").add(builder);this.allowedCSIDrivers.add(builder);} return (A)this;
    }

    public A addAllToAllowedCSIDrivers(Collection<ExtensionsV1beta1AllowedCSIDriver> items){
            if (this.allowedCSIDrivers == null) {this.allowedCSIDrivers = new ArrayList<ExtensionsV1beta1AllowedCSIDriverBuilder>();}
            for (ExtensionsV1beta1AllowedCSIDriver item : items) {ExtensionsV1beta1AllowedCSIDriverBuilder builder = new ExtensionsV1beta1AllowedCSIDriverBuilder(item);_visitables.get("allowedCSIDrivers").add(builder);this.allowedCSIDrivers.add(builder);} return (A)this;
    }

    public A removeFromAllowedCSIDrivers(ExtensionsV1beta1AllowedCSIDriver... items){
            for (ExtensionsV1beta1AllowedCSIDriver item : items) {ExtensionsV1beta1AllowedCSIDriverBuilder builder = new ExtensionsV1beta1AllowedCSIDriverBuilder(item);_visitables.get("allowedCSIDrivers").remove(builder);if (this.allowedCSIDrivers != null) {this.allowedCSIDrivers.remove(builder);}} return (A)this;
    }

    public A removeAllFromAllowedCSIDrivers(Collection<ExtensionsV1beta1AllowedCSIDriver> items){
            for (ExtensionsV1beta1AllowedCSIDriver item : items) {ExtensionsV1beta1AllowedCSIDriverBuilder builder = new ExtensionsV1beta1AllowedCSIDriverBuilder(item);_visitables.get("allowedCSIDrivers").remove(builder);if (this.allowedCSIDrivers != null) {this.allowedCSIDrivers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAllowedCSIDrivers(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedCSIDriverBuilder> predicate){
            if (allowedCSIDrivers == null) return (A) this;
            final Iterator<ExtensionsV1beta1AllowedCSIDriverBuilder> each = allowedCSIDrivers.iterator();
            final List visitables = _visitables.get("allowedCSIDrivers");
            while (each.hasNext()) {
              ExtensionsV1beta1AllowedCSIDriverBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAllowedCSIDrivers instead.
 * @return The buildable object.
 */
@Deprecated public List<ExtensionsV1beta1AllowedCSIDriver> getAllowedCSIDrivers(){
            return build(allowedCSIDrivers);
    }

    public List<ExtensionsV1beta1AllowedCSIDriver> buildAllowedCSIDrivers(){
            return build(allowedCSIDrivers);
    }

    public ExtensionsV1beta1AllowedCSIDriver buildAllowedCSIDriver(int index){
            return this.allowedCSIDrivers.get(index).build();
    }

    public ExtensionsV1beta1AllowedCSIDriver buildFirstAllowedCSIDriver(){
            return this.allowedCSIDrivers.get(0).build();
    }

    public ExtensionsV1beta1AllowedCSIDriver buildLastAllowedCSIDriver(){
            return this.allowedCSIDrivers.get(allowedCSIDrivers.size() - 1).build();
    }

    public ExtensionsV1beta1AllowedCSIDriver buildMatchingAllowedCSIDriver(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedCSIDriverBuilder> predicate){
            for (ExtensionsV1beta1AllowedCSIDriverBuilder item: allowedCSIDrivers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAllowedCSIDriver(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedCSIDriverBuilder> predicate){
            for (ExtensionsV1beta1AllowedCSIDriverBuilder item: allowedCSIDrivers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAllowedCSIDrivers(List<ExtensionsV1beta1AllowedCSIDriver> allowedCSIDrivers){
            if (this.allowedCSIDrivers != null) { _visitables.get("allowedCSIDrivers").removeAll(this.allowedCSIDrivers);}
            if (allowedCSIDrivers != null) {this.allowedCSIDrivers = new ArrayList<ExtensionsV1beta1AllowedCSIDriverBuilder>(); for (ExtensionsV1beta1AllowedCSIDriver item : allowedCSIDrivers){this.addToAllowedCSIDrivers(item);}} else { this.allowedCSIDrivers = null;} return (A) this;
    }

    public A withAllowedCSIDrivers(ExtensionsV1beta1AllowedCSIDriver... allowedCSIDrivers){
            if (this.allowedCSIDrivers != null) {this.allowedCSIDrivers.clear();}
            if (allowedCSIDrivers != null) {for (ExtensionsV1beta1AllowedCSIDriver item :allowedCSIDrivers){ this.addToAllowedCSIDrivers(item);}} return (A) this;
    }

    public Boolean hasAllowedCSIDrivers(){
            return allowedCSIDrivers != null && !allowedCSIDrivers.isEmpty();
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> addNewAllowedCSIDriver(){
            return new AllowedCSIDriversNestedImpl();
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> addNewAllowedCSIDriverLike(ExtensionsV1beta1AllowedCSIDriver item){
            return new AllowedCSIDriversNestedImpl(-1, item);
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> setNewAllowedCSIDriverLike(int index,ExtensionsV1beta1AllowedCSIDriver item){
            return new AllowedCSIDriversNestedImpl(index, item);
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editAllowedCSIDriver(int index){
            if (allowedCSIDrivers.size() <= index) throw new RuntimeException("Can't edit allowedCSIDrivers. Index exceeds size.");
            return setNewAllowedCSIDriverLike(index, buildAllowedCSIDriver(index));
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editFirstAllowedCSIDriver(){
            if (allowedCSIDrivers.size() == 0) throw new RuntimeException("Can't edit first allowedCSIDrivers. The list is empty.");
            return setNewAllowedCSIDriverLike(0, buildAllowedCSIDriver(0));
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editLastAllowedCSIDriver(){
            int index = allowedCSIDrivers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last allowedCSIDrivers. The list is empty.");
            return setNewAllowedCSIDriverLike(index, buildAllowedCSIDriver(index));
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editMatchingAllowedCSIDriver(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedCSIDriverBuilder> predicate){
            int index = -1;
            for (int i=0;i<allowedCSIDrivers.size();i++) { 
            if (predicate.apply(allowedCSIDrivers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching allowedCSIDrivers. No match found.");
            return setNewAllowedCSIDriverLike(index, buildAllowedCSIDriver(index));
    }

    public A addToAllowedCapabilities(int index,String item){
            if (this.allowedCapabilities == null) {this.allowedCapabilities = new ArrayList<String>();}
            this.allowedCapabilities.add(index, item);
            return (A)this;
    }

    public A setToAllowedCapabilities(int index,String item){
            if (this.allowedCapabilities == null) {this.allowedCapabilities = new ArrayList<String>();}
            this.allowedCapabilities.set(index, item); return (A)this;
    }

    public A addToAllowedCapabilities(String... items){
            if (this.allowedCapabilities == null) {this.allowedCapabilities = new ArrayList<String>();}
            for (String item : items) {this.allowedCapabilities.add(item);} return (A)this;
    }

    public A addAllToAllowedCapabilities(Collection<String> items){
            if (this.allowedCapabilities == null) {this.allowedCapabilities = new ArrayList<String>();}
            for (String item : items) {this.allowedCapabilities.add(item);} return (A)this;
    }

    public A removeFromAllowedCapabilities(String... items){
            for (String item : items) {if (this.allowedCapabilities!= null){ this.allowedCapabilities.remove(item);}} return (A)this;
    }

    public A removeAllFromAllowedCapabilities(Collection<String> items){
            for (String item : items) {if (this.allowedCapabilities!= null){ this.allowedCapabilities.remove(item);}} return (A)this;
    }

    public List<String> getAllowedCapabilities(){
            return this.allowedCapabilities;
    }

    public String getAllowedCapability(int index){
            return this.allowedCapabilities.get(index);
    }

    public String getFirstAllowedCapability(){
            return this.allowedCapabilities.get(0);
    }

    public String getLastAllowedCapability(){
            return this.allowedCapabilities.get(allowedCapabilities.size() - 1);
    }

    public String getMatchingAllowedCapability(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: allowedCapabilities) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAllowedCapability(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: allowedCapabilities) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAllowedCapabilities(List<String> allowedCapabilities){
            if (this.allowedCapabilities != null) { _visitables.get("allowedCapabilities").removeAll(this.allowedCapabilities);}
            if (allowedCapabilities != null) {this.allowedCapabilities = new ArrayList<String>(); for (String item : allowedCapabilities){this.addToAllowedCapabilities(item);}} else { this.allowedCapabilities = null;} return (A) this;
    }

    public A withAllowedCapabilities(String... allowedCapabilities){
            if (this.allowedCapabilities != null) {this.allowedCapabilities.clear();}
            if (allowedCapabilities != null) {for (String item :allowedCapabilities){ this.addToAllowedCapabilities(item);}} return (A) this;
    }

    public Boolean hasAllowedCapabilities(){
            return allowedCapabilities != null && !allowedCapabilities.isEmpty();
    }

    public A addNewAllowedCapability(String arg1){
            return (A)addToAllowedCapabilities(new String(arg1));
    }

    public A addNewAllowedCapability(StringBuilder arg1){
            return (A)addToAllowedCapabilities(new String(arg1));
    }

    public A addNewAllowedCapability(StringBuffer arg1){
            return (A)addToAllowedCapabilities(new String(arg1));
    }

    public A addToAllowedFlexVolumes(int index,ExtensionsV1beta1AllowedFlexVolume item){
            if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new ArrayList<ExtensionsV1beta1AllowedFlexVolumeBuilder>();}
            ExtensionsV1beta1AllowedFlexVolumeBuilder builder = new ExtensionsV1beta1AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").add(index >= 0 ? index : _visitables.get("allowedFlexVolumes").size(), builder);this.allowedFlexVolumes.add(index >= 0 ? index : allowedFlexVolumes.size(), builder); return (A)this;
    }

    public A setToAllowedFlexVolumes(int index,ExtensionsV1beta1AllowedFlexVolume item){
            if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new ArrayList<ExtensionsV1beta1AllowedFlexVolumeBuilder>();}
            ExtensionsV1beta1AllowedFlexVolumeBuilder builder = new ExtensionsV1beta1AllowedFlexVolumeBuilder(item);
            if (index < 0 || index >= _visitables.get("allowedFlexVolumes").size()) { _visitables.get("allowedFlexVolumes").add(builder); } else { _visitables.get("allowedFlexVolumes").set(index, builder);}
            if (index < 0 || index >= allowedFlexVolumes.size()) { allowedFlexVolumes.add(builder); } else { allowedFlexVolumes.set(index, builder);}
             return (A)this;
    }

    public A addToAllowedFlexVolumes(ExtensionsV1beta1AllowedFlexVolume... items){
            if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new ArrayList<ExtensionsV1beta1AllowedFlexVolumeBuilder>();}
            for (ExtensionsV1beta1AllowedFlexVolume item : items) {ExtensionsV1beta1AllowedFlexVolumeBuilder builder = new ExtensionsV1beta1AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").add(builder);this.allowedFlexVolumes.add(builder);} return (A)this;
    }

    public A addAllToAllowedFlexVolumes(Collection<ExtensionsV1beta1AllowedFlexVolume> items){
            if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new ArrayList<ExtensionsV1beta1AllowedFlexVolumeBuilder>();}
            for (ExtensionsV1beta1AllowedFlexVolume item : items) {ExtensionsV1beta1AllowedFlexVolumeBuilder builder = new ExtensionsV1beta1AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").add(builder);this.allowedFlexVolumes.add(builder);} return (A)this;
    }

    public A removeFromAllowedFlexVolumes(ExtensionsV1beta1AllowedFlexVolume... items){
            for (ExtensionsV1beta1AllowedFlexVolume item : items) {ExtensionsV1beta1AllowedFlexVolumeBuilder builder = new ExtensionsV1beta1AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").remove(builder);if (this.allowedFlexVolumes != null) {this.allowedFlexVolumes.remove(builder);}} return (A)this;
    }

    public A removeAllFromAllowedFlexVolumes(Collection<ExtensionsV1beta1AllowedFlexVolume> items){
            for (ExtensionsV1beta1AllowedFlexVolume item : items) {ExtensionsV1beta1AllowedFlexVolumeBuilder builder = new ExtensionsV1beta1AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").remove(builder);if (this.allowedFlexVolumes != null) {this.allowedFlexVolumes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAllowedFlexVolumes(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedFlexVolumeBuilder> predicate){
            if (allowedFlexVolumes == null) return (A) this;
            final Iterator<ExtensionsV1beta1AllowedFlexVolumeBuilder> each = allowedFlexVolumes.iterator();
            final List visitables = _visitables.get("allowedFlexVolumes");
            while (each.hasNext()) {
              ExtensionsV1beta1AllowedFlexVolumeBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAllowedFlexVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<ExtensionsV1beta1AllowedFlexVolume> getAllowedFlexVolumes(){
            return build(allowedFlexVolumes);
    }

    public List<ExtensionsV1beta1AllowedFlexVolume> buildAllowedFlexVolumes(){
            return build(allowedFlexVolumes);
    }

    public ExtensionsV1beta1AllowedFlexVolume buildAllowedFlexVolume(int index){
            return this.allowedFlexVolumes.get(index).build();
    }

    public ExtensionsV1beta1AllowedFlexVolume buildFirstAllowedFlexVolume(){
            return this.allowedFlexVolumes.get(0).build();
    }

    public ExtensionsV1beta1AllowedFlexVolume buildLastAllowedFlexVolume(){
            return this.allowedFlexVolumes.get(allowedFlexVolumes.size() - 1).build();
    }

    public ExtensionsV1beta1AllowedFlexVolume buildMatchingAllowedFlexVolume(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedFlexVolumeBuilder> predicate){
            for (ExtensionsV1beta1AllowedFlexVolumeBuilder item: allowedFlexVolumes) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAllowedFlexVolume(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedFlexVolumeBuilder> predicate){
            for (ExtensionsV1beta1AllowedFlexVolumeBuilder item: allowedFlexVolumes) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAllowedFlexVolumes(List<ExtensionsV1beta1AllowedFlexVolume> allowedFlexVolumes){
            if (this.allowedFlexVolumes != null) { _visitables.get("allowedFlexVolumes").removeAll(this.allowedFlexVolumes);}
            if (allowedFlexVolumes != null) {this.allowedFlexVolumes = new ArrayList<ExtensionsV1beta1AllowedFlexVolumeBuilder>(); for (ExtensionsV1beta1AllowedFlexVolume item : allowedFlexVolumes){this.addToAllowedFlexVolumes(item);}} else { this.allowedFlexVolumes = null;} return (A) this;
    }

    public A withAllowedFlexVolumes(ExtensionsV1beta1AllowedFlexVolume... allowedFlexVolumes){
            if (this.allowedFlexVolumes != null) {this.allowedFlexVolumes.clear();}
            if (allowedFlexVolumes != null) {for (ExtensionsV1beta1AllowedFlexVolume item :allowedFlexVolumes){ this.addToAllowedFlexVolumes(item);}} return (A) this;
    }

    public Boolean hasAllowedFlexVolumes(){
            return allowedFlexVolumes != null && !allowedFlexVolumes.isEmpty();
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolume(){
            return new AllowedFlexVolumesNestedImpl();
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolumeLike(ExtensionsV1beta1AllowedFlexVolume item){
            return new AllowedFlexVolumesNestedImpl(-1, item);
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> setNewAllowedFlexVolumeLike(int index,ExtensionsV1beta1AllowedFlexVolume item){
            return new AllowedFlexVolumesNestedImpl(index, item);
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editAllowedFlexVolume(int index){
            if (allowedFlexVolumes.size() <= index) throw new RuntimeException("Can't edit allowedFlexVolumes. Index exceeds size.");
            return setNewAllowedFlexVolumeLike(index, buildAllowedFlexVolume(index));
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editFirstAllowedFlexVolume(){
            if (allowedFlexVolumes.size() == 0) throw new RuntimeException("Can't edit first allowedFlexVolumes. The list is empty.");
            return setNewAllowedFlexVolumeLike(0, buildAllowedFlexVolume(0));
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editLastAllowedFlexVolume(){
            int index = allowedFlexVolumes.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last allowedFlexVolumes. The list is empty.");
            return setNewAllowedFlexVolumeLike(index, buildAllowedFlexVolume(index));
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editMatchingAllowedFlexVolume(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedFlexVolumeBuilder> predicate){
            int index = -1;
            for (int i=0;i<allowedFlexVolumes.size();i++) { 
            if (predicate.apply(allowedFlexVolumes.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching allowedFlexVolumes. No match found.");
            return setNewAllowedFlexVolumeLike(index, buildAllowedFlexVolume(index));
    }

    public A addToAllowedHostPaths(int index,ExtensionsV1beta1AllowedHostPath item){
            if (this.allowedHostPaths == null) {this.allowedHostPaths = new ArrayList<ExtensionsV1beta1AllowedHostPathBuilder>();}
            ExtensionsV1beta1AllowedHostPathBuilder builder = new ExtensionsV1beta1AllowedHostPathBuilder(item);_visitables.get("allowedHostPaths").add(index >= 0 ? index : _visitables.get("allowedHostPaths").size(), builder);this.allowedHostPaths.add(index >= 0 ? index : allowedHostPaths.size(), builder); return (A)this;
    }

    public A setToAllowedHostPaths(int index,ExtensionsV1beta1AllowedHostPath item){
            if (this.allowedHostPaths == null) {this.allowedHostPaths = new ArrayList<ExtensionsV1beta1AllowedHostPathBuilder>();}
            ExtensionsV1beta1AllowedHostPathBuilder builder = new ExtensionsV1beta1AllowedHostPathBuilder(item);
            if (index < 0 || index >= _visitables.get("allowedHostPaths").size()) { _visitables.get("allowedHostPaths").add(builder); } else { _visitables.get("allowedHostPaths").set(index, builder);}
            if (index < 0 || index >= allowedHostPaths.size()) { allowedHostPaths.add(builder); } else { allowedHostPaths.set(index, builder);}
             return (A)this;
    }

    public A addToAllowedHostPaths(ExtensionsV1beta1AllowedHostPath... items){
            if (this.allowedHostPaths == null) {this.allowedHostPaths = new ArrayList<ExtensionsV1beta1AllowedHostPathBuilder>();}
            for (ExtensionsV1beta1AllowedHostPath item : items) {ExtensionsV1beta1AllowedHostPathBuilder builder = new ExtensionsV1beta1AllowedHostPathBuilder(item);_visitables.get("allowedHostPaths").add(builder);this.allowedHostPaths.add(builder);} return (A)this;
    }

    public A addAllToAllowedHostPaths(Collection<ExtensionsV1beta1AllowedHostPath> items){
            if (this.allowedHostPaths == null) {this.allowedHostPaths = new ArrayList<ExtensionsV1beta1AllowedHostPathBuilder>();}
            for (ExtensionsV1beta1AllowedHostPath item : items) {ExtensionsV1beta1AllowedHostPathBuilder builder = new ExtensionsV1beta1AllowedHostPathBuilder(item);_visitables.get("allowedHostPaths").add(builder);this.allowedHostPaths.add(builder);} return (A)this;
    }

    public A removeFromAllowedHostPaths(ExtensionsV1beta1AllowedHostPath... items){
            for (ExtensionsV1beta1AllowedHostPath item : items) {ExtensionsV1beta1AllowedHostPathBuilder builder = new ExtensionsV1beta1AllowedHostPathBuilder(item);_visitables.get("allowedHostPaths").remove(builder);if (this.allowedHostPaths != null) {this.allowedHostPaths.remove(builder);}} return (A)this;
    }

    public A removeAllFromAllowedHostPaths(Collection<ExtensionsV1beta1AllowedHostPath> items){
            for (ExtensionsV1beta1AllowedHostPath item : items) {ExtensionsV1beta1AllowedHostPathBuilder builder = new ExtensionsV1beta1AllowedHostPathBuilder(item);_visitables.get("allowedHostPaths").remove(builder);if (this.allowedHostPaths != null) {this.allowedHostPaths.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAllowedHostPaths(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedHostPathBuilder> predicate){
            if (allowedHostPaths == null) return (A) this;
            final Iterator<ExtensionsV1beta1AllowedHostPathBuilder> each = allowedHostPaths.iterator();
            final List visitables = _visitables.get("allowedHostPaths");
            while (each.hasNext()) {
              ExtensionsV1beta1AllowedHostPathBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAllowedHostPaths instead.
 * @return The buildable object.
 */
@Deprecated public List<ExtensionsV1beta1AllowedHostPath> getAllowedHostPaths(){
            return build(allowedHostPaths);
    }

    public List<ExtensionsV1beta1AllowedHostPath> buildAllowedHostPaths(){
            return build(allowedHostPaths);
    }

    public ExtensionsV1beta1AllowedHostPath buildAllowedHostPath(int index){
            return this.allowedHostPaths.get(index).build();
    }

    public ExtensionsV1beta1AllowedHostPath buildFirstAllowedHostPath(){
            return this.allowedHostPaths.get(0).build();
    }

    public ExtensionsV1beta1AllowedHostPath buildLastAllowedHostPath(){
            return this.allowedHostPaths.get(allowedHostPaths.size() - 1).build();
    }

    public ExtensionsV1beta1AllowedHostPath buildMatchingAllowedHostPath(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedHostPathBuilder> predicate){
            for (ExtensionsV1beta1AllowedHostPathBuilder item: allowedHostPaths) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAllowedHostPath(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedHostPathBuilder> predicate){
            for (ExtensionsV1beta1AllowedHostPathBuilder item: allowedHostPaths) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAllowedHostPaths(List<ExtensionsV1beta1AllowedHostPath> allowedHostPaths){
            if (this.allowedHostPaths != null) { _visitables.get("allowedHostPaths").removeAll(this.allowedHostPaths);}
            if (allowedHostPaths != null) {this.allowedHostPaths = new ArrayList<ExtensionsV1beta1AllowedHostPathBuilder>(); for (ExtensionsV1beta1AllowedHostPath item : allowedHostPaths){this.addToAllowedHostPaths(item);}} else { this.allowedHostPaths = null;} return (A) this;
    }

    public A withAllowedHostPaths(ExtensionsV1beta1AllowedHostPath... allowedHostPaths){
            if (this.allowedHostPaths != null) {this.allowedHostPaths.clear();}
            if (allowedHostPaths != null) {for (ExtensionsV1beta1AllowedHostPath item :allowedHostPaths){ this.addToAllowedHostPaths(item);}} return (A) this;
    }

    public Boolean hasAllowedHostPaths(){
            return allowedHostPaths != null && !allowedHostPaths.isEmpty();
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPath(){
            return new AllowedHostPathsNestedImpl();
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPathLike(ExtensionsV1beta1AllowedHostPath item){
            return new AllowedHostPathsNestedImpl(-1, item);
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> setNewAllowedHostPathLike(int index,ExtensionsV1beta1AllowedHostPath item){
            return new AllowedHostPathsNestedImpl(index, item);
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editAllowedHostPath(int index){
            if (allowedHostPaths.size() <= index) throw new RuntimeException("Can't edit allowedHostPaths. Index exceeds size.");
            return setNewAllowedHostPathLike(index, buildAllowedHostPath(index));
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editFirstAllowedHostPath(){
            if (allowedHostPaths.size() == 0) throw new RuntimeException("Can't edit first allowedHostPaths. The list is empty.");
            return setNewAllowedHostPathLike(0, buildAllowedHostPath(0));
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editLastAllowedHostPath(){
            int index = allowedHostPaths.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last allowedHostPaths. The list is empty.");
            return setNewAllowedHostPathLike(index, buildAllowedHostPath(index));
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editMatchingAllowedHostPath(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedHostPathBuilder> predicate){
            int index = -1;
            for (int i=0;i<allowedHostPaths.size();i++) { 
            if (predicate.apply(allowedHostPaths.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching allowedHostPaths. No match found.");
            return setNewAllowedHostPathLike(index, buildAllowedHostPath(index));
    }

    public A addToAllowedProcMountTypes(int index,String item){
            if (this.allowedProcMountTypes == null) {this.allowedProcMountTypes = new ArrayList<String>();}
            this.allowedProcMountTypes.add(index, item);
            return (A)this;
    }

    public A setToAllowedProcMountTypes(int index,String item){
            if (this.allowedProcMountTypes == null) {this.allowedProcMountTypes = new ArrayList<String>();}
            this.allowedProcMountTypes.set(index, item); return (A)this;
    }

    public A addToAllowedProcMountTypes(String... items){
            if (this.allowedProcMountTypes == null) {this.allowedProcMountTypes = new ArrayList<String>();}
            for (String item : items) {this.allowedProcMountTypes.add(item);} return (A)this;
    }

    public A addAllToAllowedProcMountTypes(Collection<String> items){
            if (this.allowedProcMountTypes == null) {this.allowedProcMountTypes = new ArrayList<String>();}
            for (String item : items) {this.allowedProcMountTypes.add(item);} return (A)this;
    }

    public A removeFromAllowedProcMountTypes(String... items){
            for (String item : items) {if (this.allowedProcMountTypes!= null){ this.allowedProcMountTypes.remove(item);}} return (A)this;
    }

    public A removeAllFromAllowedProcMountTypes(Collection<String> items){
            for (String item : items) {if (this.allowedProcMountTypes!= null){ this.allowedProcMountTypes.remove(item);}} return (A)this;
    }

    public List<String> getAllowedProcMountTypes(){
            return this.allowedProcMountTypes;
    }

    public String getAllowedProcMountType(int index){
            return this.allowedProcMountTypes.get(index);
    }

    public String getFirstAllowedProcMountType(){
            return this.allowedProcMountTypes.get(0);
    }

    public String getLastAllowedProcMountType(){
            return this.allowedProcMountTypes.get(allowedProcMountTypes.size() - 1);
    }

    public String getMatchingAllowedProcMountType(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: allowedProcMountTypes) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAllowedProcMountType(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: allowedProcMountTypes) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAllowedProcMountTypes(List<String> allowedProcMountTypes){
            if (this.allowedProcMountTypes != null) { _visitables.get("allowedProcMountTypes").removeAll(this.allowedProcMountTypes);}
            if (allowedProcMountTypes != null) {this.allowedProcMountTypes = new ArrayList<String>(); for (String item : allowedProcMountTypes){this.addToAllowedProcMountTypes(item);}} else { this.allowedProcMountTypes = null;} return (A) this;
    }

    public A withAllowedProcMountTypes(String... allowedProcMountTypes){
            if (this.allowedProcMountTypes != null) {this.allowedProcMountTypes.clear();}
            if (allowedProcMountTypes != null) {for (String item :allowedProcMountTypes){ this.addToAllowedProcMountTypes(item);}} return (A) this;
    }

    public Boolean hasAllowedProcMountTypes(){
            return allowedProcMountTypes != null && !allowedProcMountTypes.isEmpty();
    }

    public A addNewAllowedProcMountType(String arg1){
            return (A)addToAllowedProcMountTypes(new String(arg1));
    }

    public A addNewAllowedProcMountType(StringBuilder arg1){
            return (A)addToAllowedProcMountTypes(new String(arg1));
    }

    public A addNewAllowedProcMountType(StringBuffer arg1){
            return (A)addToAllowedProcMountTypes(new String(arg1));
    }

    public A addToAllowedUnsafeSysctls(int index,String item){
            if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new ArrayList<String>();}
            this.allowedUnsafeSysctls.add(index, item);
            return (A)this;
    }

    public A setToAllowedUnsafeSysctls(int index,String item){
            if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new ArrayList<String>();}
            this.allowedUnsafeSysctls.set(index, item); return (A)this;
    }

    public A addToAllowedUnsafeSysctls(String... items){
            if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new ArrayList<String>();}
            for (String item : items) {this.allowedUnsafeSysctls.add(item);} return (A)this;
    }

    public A addAllToAllowedUnsafeSysctls(Collection<String> items){
            if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new ArrayList<String>();}
            for (String item : items) {this.allowedUnsafeSysctls.add(item);} return (A)this;
    }

    public A removeFromAllowedUnsafeSysctls(String... items){
            for (String item : items) {if (this.allowedUnsafeSysctls!= null){ this.allowedUnsafeSysctls.remove(item);}} return (A)this;
    }

    public A removeAllFromAllowedUnsafeSysctls(Collection<String> items){
            for (String item : items) {if (this.allowedUnsafeSysctls!= null){ this.allowedUnsafeSysctls.remove(item);}} return (A)this;
    }

    public List<String> getAllowedUnsafeSysctls(){
            return this.allowedUnsafeSysctls;
    }

    public String getAllowedUnsafeSysctl(int index){
            return this.allowedUnsafeSysctls.get(index);
    }

    public String getFirstAllowedUnsafeSysctl(){
            return this.allowedUnsafeSysctls.get(0);
    }

    public String getLastAllowedUnsafeSysctl(){
            return this.allowedUnsafeSysctls.get(allowedUnsafeSysctls.size() - 1);
    }

    public String getMatchingAllowedUnsafeSysctl(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: allowedUnsafeSysctls) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAllowedUnsafeSysctl(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: allowedUnsafeSysctls) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAllowedUnsafeSysctls(List<String> allowedUnsafeSysctls){
            if (this.allowedUnsafeSysctls != null) { _visitables.get("allowedUnsafeSysctls").removeAll(this.allowedUnsafeSysctls);}
            if (allowedUnsafeSysctls != null) {this.allowedUnsafeSysctls = new ArrayList<String>(); for (String item : allowedUnsafeSysctls){this.addToAllowedUnsafeSysctls(item);}} else { this.allowedUnsafeSysctls = null;} return (A) this;
    }

    public A withAllowedUnsafeSysctls(String... allowedUnsafeSysctls){
            if (this.allowedUnsafeSysctls != null) {this.allowedUnsafeSysctls.clear();}
            if (allowedUnsafeSysctls != null) {for (String item :allowedUnsafeSysctls){ this.addToAllowedUnsafeSysctls(item);}} return (A) this;
    }

    public Boolean hasAllowedUnsafeSysctls(){
            return allowedUnsafeSysctls != null && !allowedUnsafeSysctls.isEmpty();
    }

    public A addNewAllowedUnsafeSysctl(String arg1){
            return (A)addToAllowedUnsafeSysctls(new String(arg1));
    }

    public A addNewAllowedUnsafeSysctl(StringBuilder arg1){
            return (A)addToAllowedUnsafeSysctls(new String(arg1));
    }

    public A addNewAllowedUnsafeSysctl(StringBuffer arg1){
            return (A)addToAllowedUnsafeSysctls(new String(arg1));
    }

    public A addToDefaultAddCapabilities(int index,String item){
            if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new ArrayList<String>();}
            this.defaultAddCapabilities.add(index, item);
            return (A)this;
    }

    public A setToDefaultAddCapabilities(int index,String item){
            if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new ArrayList<String>();}
            this.defaultAddCapabilities.set(index, item); return (A)this;
    }

    public A addToDefaultAddCapabilities(String... items){
            if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new ArrayList<String>();}
            for (String item : items) {this.defaultAddCapabilities.add(item);} return (A)this;
    }

    public A addAllToDefaultAddCapabilities(Collection<String> items){
            if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new ArrayList<String>();}
            for (String item : items) {this.defaultAddCapabilities.add(item);} return (A)this;
    }

    public A removeFromDefaultAddCapabilities(String... items){
            for (String item : items) {if (this.defaultAddCapabilities!= null){ this.defaultAddCapabilities.remove(item);}} return (A)this;
    }

    public A removeAllFromDefaultAddCapabilities(Collection<String> items){
            for (String item : items) {if (this.defaultAddCapabilities!= null){ this.defaultAddCapabilities.remove(item);}} return (A)this;
    }

    public List<String> getDefaultAddCapabilities(){
            return this.defaultAddCapabilities;
    }

    public String getDefaultAddCapability(int index){
            return this.defaultAddCapabilities.get(index);
    }

    public String getFirstDefaultAddCapability(){
            return this.defaultAddCapabilities.get(0);
    }

    public String getLastDefaultAddCapability(){
            return this.defaultAddCapabilities.get(defaultAddCapabilities.size() - 1);
    }

    public String getMatchingDefaultAddCapability(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: defaultAddCapabilities) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingDefaultAddCapability(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: defaultAddCapabilities) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities){
            if (this.defaultAddCapabilities != null) { _visitables.get("defaultAddCapabilities").removeAll(this.defaultAddCapabilities);}
            if (defaultAddCapabilities != null) {this.defaultAddCapabilities = new ArrayList<String>(); for (String item : defaultAddCapabilities){this.addToDefaultAddCapabilities(item);}} else { this.defaultAddCapabilities = null;} return (A) this;
    }

    public A withDefaultAddCapabilities(String... defaultAddCapabilities){
            if (this.defaultAddCapabilities != null) {this.defaultAddCapabilities.clear();}
            if (defaultAddCapabilities != null) {for (String item :defaultAddCapabilities){ this.addToDefaultAddCapabilities(item);}} return (A) this;
    }

    public Boolean hasDefaultAddCapabilities(){
            return defaultAddCapabilities != null && !defaultAddCapabilities.isEmpty();
    }

    public A addNewDefaultAddCapability(String arg1){
            return (A)addToDefaultAddCapabilities(new String(arg1));
    }

    public A addNewDefaultAddCapability(StringBuilder arg1){
            return (A)addToDefaultAddCapabilities(new String(arg1));
    }

    public A addNewDefaultAddCapability(StringBuffer arg1){
            return (A)addToDefaultAddCapabilities(new String(arg1));
    }

    public Boolean isDefaultAllowPrivilegeEscalation(){
            return this.defaultAllowPrivilegeEscalation;
    }

    public A withDefaultAllowPrivilegeEscalation(Boolean defaultAllowPrivilegeEscalation){
            this.defaultAllowPrivilegeEscalation=defaultAllowPrivilegeEscalation; return (A) this;
    }

    public Boolean hasDefaultAllowPrivilegeEscalation(){
            return this.defaultAllowPrivilegeEscalation != null;
    }

    public A withNewDefaultAllowPrivilegeEscalation(String arg1){
            return (A)withDefaultAllowPrivilegeEscalation(new Boolean(arg1));
    }

    public A withNewDefaultAllowPrivilegeEscalation(boolean arg1){
            return (A)withDefaultAllowPrivilegeEscalation(new Boolean(arg1));
    }

    public A addToForbiddenSysctls(int index,String item){
            if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new ArrayList<String>();}
            this.forbiddenSysctls.add(index, item);
            return (A)this;
    }

    public A setToForbiddenSysctls(int index,String item){
            if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new ArrayList<String>();}
            this.forbiddenSysctls.set(index, item); return (A)this;
    }

    public A addToForbiddenSysctls(String... items){
            if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new ArrayList<String>();}
            for (String item : items) {this.forbiddenSysctls.add(item);} return (A)this;
    }

    public A addAllToForbiddenSysctls(Collection<String> items){
            if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new ArrayList<String>();}
            for (String item : items) {this.forbiddenSysctls.add(item);} return (A)this;
    }

    public A removeFromForbiddenSysctls(String... items){
            for (String item : items) {if (this.forbiddenSysctls!= null){ this.forbiddenSysctls.remove(item);}} return (A)this;
    }

    public A removeAllFromForbiddenSysctls(Collection<String> items){
            for (String item : items) {if (this.forbiddenSysctls!= null){ this.forbiddenSysctls.remove(item);}} return (A)this;
    }

    public List<String> getForbiddenSysctls(){
            return this.forbiddenSysctls;
    }

    public String getForbiddenSysctl(int index){
            return this.forbiddenSysctls.get(index);
    }

    public String getFirstForbiddenSysctl(){
            return this.forbiddenSysctls.get(0);
    }

    public String getLastForbiddenSysctl(){
            return this.forbiddenSysctls.get(forbiddenSysctls.size() - 1);
    }

    public String getMatchingForbiddenSysctl(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: forbiddenSysctls) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingForbiddenSysctl(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: forbiddenSysctls) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withForbiddenSysctls(List<String> forbiddenSysctls){
            if (this.forbiddenSysctls != null) { _visitables.get("forbiddenSysctls").removeAll(this.forbiddenSysctls);}
            if (forbiddenSysctls != null) {this.forbiddenSysctls = new ArrayList<String>(); for (String item : forbiddenSysctls){this.addToForbiddenSysctls(item);}} else { this.forbiddenSysctls = null;} return (A) this;
    }

    public A withForbiddenSysctls(String... forbiddenSysctls){
            if (this.forbiddenSysctls != null) {this.forbiddenSysctls.clear();}
            if (forbiddenSysctls != null) {for (String item :forbiddenSysctls){ this.addToForbiddenSysctls(item);}} return (A) this;
    }

    public Boolean hasForbiddenSysctls(){
            return forbiddenSysctls != null && !forbiddenSysctls.isEmpty();
    }

    public A addNewForbiddenSysctl(String arg1){
            return (A)addToForbiddenSysctls(new String(arg1));
    }

    public A addNewForbiddenSysctl(StringBuilder arg1){
            return (A)addToForbiddenSysctls(new String(arg1));
    }

    public A addNewForbiddenSysctl(StringBuffer arg1){
            return (A)addToForbiddenSysctls(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildFsGroup instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1FSGroupStrategyOptions getFsGroup(){
            return this.fsGroup!=null?this.fsGroup.build():null;
    }

    public ExtensionsV1beta1FSGroupStrategyOptions buildFsGroup(){
            return this.fsGroup!=null?this.fsGroup.build():null;
    }

    public A withFsGroup(ExtensionsV1beta1FSGroupStrategyOptions fsGroup){
            _visitables.get("fsGroup").remove(this.fsGroup);
            if (fsGroup!=null){ this.fsGroup= new ExtensionsV1beta1FSGroupStrategyOptionsBuilder(fsGroup); _visitables.get("fsGroup").add(this.fsGroup);} return (A) this;
    }

    public Boolean hasFsGroup(){
            return this.fsGroup != null;
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroup(){
            return new FsGroupNestedImpl();
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroupLike(ExtensionsV1beta1FSGroupStrategyOptions item){
            return new FsGroupNestedImpl(item);
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> editFsGroup(){
            return withNewFsGroupLike(getFsGroup());
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroup(){
            return withNewFsGroupLike(getFsGroup() != null ? getFsGroup(): new ExtensionsV1beta1FSGroupStrategyOptionsBuilder().build());
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroupLike(ExtensionsV1beta1FSGroupStrategyOptions item){
            return withNewFsGroupLike(getFsGroup() != null ? getFsGroup(): item);
    }

    public Boolean isHostIPC(){
            return this.hostIPC;
    }

    public A withHostIPC(Boolean hostIPC){
            this.hostIPC=hostIPC; return (A) this;
    }

    public Boolean hasHostIPC(){
            return this.hostIPC != null;
    }

    public A withNewHostIPC(String arg1){
            return (A)withHostIPC(new Boolean(arg1));
    }

    public A withNewHostIPC(boolean arg1){
            return (A)withHostIPC(new Boolean(arg1));
    }

    public Boolean isHostNetwork(){
            return this.hostNetwork;
    }

    public A withHostNetwork(Boolean hostNetwork){
            this.hostNetwork=hostNetwork; return (A) this;
    }

    public Boolean hasHostNetwork(){
            return this.hostNetwork != null;
    }

    public A withNewHostNetwork(String arg1){
            return (A)withHostNetwork(new Boolean(arg1));
    }

    public A withNewHostNetwork(boolean arg1){
            return (A)withHostNetwork(new Boolean(arg1));
    }

    public Boolean isHostPID(){
            return this.hostPID;
    }

    public A withHostPID(Boolean hostPID){
            this.hostPID=hostPID; return (A) this;
    }

    public Boolean hasHostPID(){
            return this.hostPID != null;
    }

    public A withNewHostPID(String arg1){
            return (A)withHostPID(new Boolean(arg1));
    }

    public A withNewHostPID(boolean arg1){
            return (A)withHostPID(new Boolean(arg1));
    }

    public A addToHostPorts(int index,ExtensionsV1beta1HostPortRange item){
            if (this.hostPorts == null) {this.hostPorts = new ArrayList<ExtensionsV1beta1HostPortRangeBuilder>();}
            ExtensionsV1beta1HostPortRangeBuilder builder = new ExtensionsV1beta1HostPortRangeBuilder(item);_visitables.get("hostPorts").add(index >= 0 ? index : _visitables.get("hostPorts").size(), builder);this.hostPorts.add(index >= 0 ? index : hostPorts.size(), builder); return (A)this;
    }

    public A setToHostPorts(int index,ExtensionsV1beta1HostPortRange item){
            if (this.hostPorts == null) {this.hostPorts = new ArrayList<ExtensionsV1beta1HostPortRangeBuilder>();}
            ExtensionsV1beta1HostPortRangeBuilder builder = new ExtensionsV1beta1HostPortRangeBuilder(item);
            if (index < 0 || index >= _visitables.get("hostPorts").size()) { _visitables.get("hostPorts").add(builder); } else { _visitables.get("hostPorts").set(index, builder);}
            if (index < 0 || index >= hostPorts.size()) { hostPorts.add(builder); } else { hostPorts.set(index, builder);}
             return (A)this;
    }

    public A addToHostPorts(ExtensionsV1beta1HostPortRange... items){
            if (this.hostPorts == null) {this.hostPorts = new ArrayList<ExtensionsV1beta1HostPortRangeBuilder>();}
            for (ExtensionsV1beta1HostPortRange item : items) {ExtensionsV1beta1HostPortRangeBuilder builder = new ExtensionsV1beta1HostPortRangeBuilder(item);_visitables.get("hostPorts").add(builder);this.hostPorts.add(builder);} return (A)this;
    }

    public A addAllToHostPorts(Collection<ExtensionsV1beta1HostPortRange> items){
            if (this.hostPorts == null) {this.hostPorts = new ArrayList<ExtensionsV1beta1HostPortRangeBuilder>();}
            for (ExtensionsV1beta1HostPortRange item : items) {ExtensionsV1beta1HostPortRangeBuilder builder = new ExtensionsV1beta1HostPortRangeBuilder(item);_visitables.get("hostPorts").add(builder);this.hostPorts.add(builder);} return (A)this;
    }

    public A removeFromHostPorts(ExtensionsV1beta1HostPortRange... items){
            for (ExtensionsV1beta1HostPortRange item : items) {ExtensionsV1beta1HostPortRangeBuilder builder = new ExtensionsV1beta1HostPortRangeBuilder(item);_visitables.get("hostPorts").remove(builder);if (this.hostPorts != null) {this.hostPorts.remove(builder);}} return (A)this;
    }

    public A removeAllFromHostPorts(Collection<ExtensionsV1beta1HostPortRange> items){
            for (ExtensionsV1beta1HostPortRange item : items) {ExtensionsV1beta1HostPortRangeBuilder builder = new ExtensionsV1beta1HostPortRangeBuilder(item);_visitables.get("hostPorts").remove(builder);if (this.hostPorts != null) {this.hostPorts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromHostPorts(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1HostPortRangeBuilder> predicate){
            if (hostPorts == null) return (A) this;
            final Iterator<ExtensionsV1beta1HostPortRangeBuilder> each = hostPorts.iterator();
            final List visitables = _visitables.get("hostPorts");
            while (each.hasNext()) {
              ExtensionsV1beta1HostPortRangeBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildHostPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<ExtensionsV1beta1HostPortRange> getHostPorts(){
            return build(hostPorts);
    }

    public List<ExtensionsV1beta1HostPortRange> buildHostPorts(){
            return build(hostPorts);
    }

    public ExtensionsV1beta1HostPortRange buildHostPort(int index){
            return this.hostPorts.get(index).build();
    }

    public ExtensionsV1beta1HostPortRange buildFirstHostPort(){
            return this.hostPorts.get(0).build();
    }

    public ExtensionsV1beta1HostPortRange buildLastHostPort(){
            return this.hostPorts.get(hostPorts.size() - 1).build();
    }

    public ExtensionsV1beta1HostPortRange buildMatchingHostPort(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1HostPortRangeBuilder> predicate){
            for (ExtensionsV1beta1HostPortRangeBuilder item: hostPorts) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingHostPort(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1HostPortRangeBuilder> predicate){
            for (ExtensionsV1beta1HostPortRangeBuilder item: hostPorts) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withHostPorts(List<ExtensionsV1beta1HostPortRange> hostPorts){
            if (this.hostPorts != null) { _visitables.get("hostPorts").removeAll(this.hostPorts);}
            if (hostPorts != null) {this.hostPorts = new ArrayList<ExtensionsV1beta1HostPortRangeBuilder>(); for (ExtensionsV1beta1HostPortRange item : hostPorts){this.addToHostPorts(item);}} else { this.hostPorts = null;} return (A) this;
    }

    public A withHostPorts(ExtensionsV1beta1HostPortRange... hostPorts){
            if (this.hostPorts != null) {this.hostPorts.clear();}
            if (hostPorts != null) {for (ExtensionsV1beta1HostPortRange item :hostPorts){ this.addToHostPorts(item);}} return (A) this;
    }

    public Boolean hasHostPorts(){
            return hostPorts != null && !hostPorts.isEmpty();
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPort(){
            return new HostPortsNestedImpl();
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPortLike(ExtensionsV1beta1HostPortRange item){
            return new HostPortsNestedImpl(-1, item);
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> setNewHostPortLike(int index,ExtensionsV1beta1HostPortRange item){
            return new HostPortsNestedImpl(index, item);
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editHostPort(int index){
            if (hostPorts.size() <= index) throw new RuntimeException("Can't edit hostPorts. Index exceeds size.");
            return setNewHostPortLike(index, buildHostPort(index));
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editFirstHostPort(){
            if (hostPorts.size() == 0) throw new RuntimeException("Can't edit first hostPorts. The list is empty.");
            return setNewHostPortLike(0, buildHostPort(0));
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editLastHostPort(){
            int index = hostPorts.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last hostPorts. The list is empty.");
            return setNewHostPortLike(index, buildHostPort(index));
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editMatchingHostPort(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1HostPortRangeBuilder> predicate){
            int index = -1;
            for (int i=0;i<hostPorts.size();i++) { 
            if (predicate.apply(hostPorts.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching hostPorts. No match found.");
            return setNewHostPortLike(index, buildHostPort(index));
    }

    public Boolean isPrivileged(){
            return this.privileged;
    }

    public A withPrivileged(Boolean privileged){
            this.privileged=privileged; return (A) this;
    }

    public Boolean hasPrivileged(){
            return this.privileged != null;
    }

    public A withNewPrivileged(String arg1){
            return (A)withPrivileged(new Boolean(arg1));
    }

    public A withNewPrivileged(boolean arg1){
            return (A)withPrivileged(new Boolean(arg1));
    }

    public Boolean isReadOnlyRootFilesystem(){
            return this.readOnlyRootFilesystem;
    }

    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem){
            this.readOnlyRootFilesystem=readOnlyRootFilesystem; return (A) this;
    }

    public Boolean hasReadOnlyRootFilesystem(){
            return this.readOnlyRootFilesystem != null;
    }

    public A withNewReadOnlyRootFilesystem(String arg1){
            return (A)withReadOnlyRootFilesystem(new Boolean(arg1));
    }

    public A withNewReadOnlyRootFilesystem(boolean arg1){
            return (A)withReadOnlyRootFilesystem(new Boolean(arg1));
    }

    public A addToRequiredDropCapabilities(int index,String item){
            if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new ArrayList<String>();}
            this.requiredDropCapabilities.add(index, item);
            return (A)this;
    }

    public A setToRequiredDropCapabilities(int index,String item){
            if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new ArrayList<String>();}
            this.requiredDropCapabilities.set(index, item); return (A)this;
    }

    public A addToRequiredDropCapabilities(String... items){
            if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new ArrayList<String>();}
            for (String item : items) {this.requiredDropCapabilities.add(item);} return (A)this;
    }

    public A addAllToRequiredDropCapabilities(Collection<String> items){
            if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new ArrayList<String>();}
            for (String item : items) {this.requiredDropCapabilities.add(item);} return (A)this;
    }

    public A removeFromRequiredDropCapabilities(String... items){
            for (String item : items) {if (this.requiredDropCapabilities!= null){ this.requiredDropCapabilities.remove(item);}} return (A)this;
    }

    public A removeAllFromRequiredDropCapabilities(Collection<String> items){
            for (String item : items) {if (this.requiredDropCapabilities!= null){ this.requiredDropCapabilities.remove(item);}} return (A)this;
    }

    public List<String> getRequiredDropCapabilities(){
            return this.requiredDropCapabilities;
    }

    public String getRequiredDropCapability(int index){
            return this.requiredDropCapabilities.get(index);
    }

    public String getFirstRequiredDropCapability(){
            return this.requiredDropCapabilities.get(0);
    }

    public String getLastRequiredDropCapability(){
            return this.requiredDropCapabilities.get(requiredDropCapabilities.size() - 1);
    }

    public String getMatchingRequiredDropCapability(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: requiredDropCapabilities) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingRequiredDropCapability(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: requiredDropCapabilities) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities){
            if (this.requiredDropCapabilities != null) { _visitables.get("requiredDropCapabilities").removeAll(this.requiredDropCapabilities);}
            if (requiredDropCapabilities != null) {this.requiredDropCapabilities = new ArrayList<String>(); for (String item : requiredDropCapabilities){this.addToRequiredDropCapabilities(item);}} else { this.requiredDropCapabilities = null;} return (A) this;
    }

    public A withRequiredDropCapabilities(String... requiredDropCapabilities){
            if (this.requiredDropCapabilities != null) {this.requiredDropCapabilities.clear();}
            if (requiredDropCapabilities != null) {for (String item :requiredDropCapabilities){ this.addToRequiredDropCapabilities(item);}} return (A) this;
    }

    public Boolean hasRequiredDropCapabilities(){
            return requiredDropCapabilities != null && !requiredDropCapabilities.isEmpty();
    }

    public A addNewRequiredDropCapability(String arg1){
            return (A)addToRequiredDropCapabilities(new String(arg1));
    }

    public A addNewRequiredDropCapability(StringBuilder arg1){
            return (A)addToRequiredDropCapabilities(new String(arg1));
    }

    public A addNewRequiredDropCapability(StringBuffer arg1){
            return (A)addToRequiredDropCapabilities(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRunAsGroup instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1RunAsGroupStrategyOptions getRunAsGroup(){
            return this.runAsGroup!=null?this.runAsGroup.build():null;
    }

    public ExtensionsV1beta1RunAsGroupStrategyOptions buildRunAsGroup(){
            return this.runAsGroup!=null?this.runAsGroup.build():null;
    }

    public A withRunAsGroup(ExtensionsV1beta1RunAsGroupStrategyOptions runAsGroup){
            _visitables.get("runAsGroup").remove(this.runAsGroup);
            if (runAsGroup!=null){ this.runAsGroup= new ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder(runAsGroup); _visitables.get("runAsGroup").add(this.runAsGroup);} return (A) this;
    }

    public Boolean hasRunAsGroup(){
            return this.runAsGroup != null;
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsGroupNested<A> withNewRunAsGroup(){
            return new RunAsGroupNestedImpl();
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsGroupNested<A> withNewRunAsGroupLike(ExtensionsV1beta1RunAsGroupStrategyOptions item){
            return new RunAsGroupNestedImpl(item);
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsGroupNested<A> editRunAsGroup(){
            return withNewRunAsGroupLike(getRunAsGroup());
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsGroupNested<A> editOrNewRunAsGroup(){
            return withNewRunAsGroupLike(getRunAsGroup() != null ? getRunAsGroup(): new ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder().build());
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsGroupNested<A> editOrNewRunAsGroupLike(ExtensionsV1beta1RunAsGroupStrategyOptions item){
            return withNewRunAsGroupLike(getRunAsGroup() != null ? getRunAsGroup(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRunAsUser instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1RunAsUserStrategyOptions getRunAsUser(){
            return this.runAsUser!=null?this.runAsUser.build():null;
    }

    public ExtensionsV1beta1RunAsUserStrategyOptions buildRunAsUser(){
            return this.runAsUser!=null?this.runAsUser.build():null;
    }

    public A withRunAsUser(ExtensionsV1beta1RunAsUserStrategyOptions runAsUser){
            _visitables.get("runAsUser").remove(this.runAsUser);
            if (runAsUser!=null){ this.runAsUser= new ExtensionsV1beta1RunAsUserStrategyOptionsBuilder(runAsUser); _visitables.get("runAsUser").add(this.runAsUser);} return (A) this;
    }

    public Boolean hasRunAsUser(){
            return this.runAsUser != null;
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUser(){
            return new RunAsUserNestedImpl();
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUserLike(ExtensionsV1beta1RunAsUserStrategyOptions item){
            return new RunAsUserNestedImpl(item);
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> editRunAsUser(){
            return withNewRunAsUserLike(getRunAsUser());
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUser(){
            return withNewRunAsUserLike(getRunAsUser() != null ? getRunAsUser(): new ExtensionsV1beta1RunAsUserStrategyOptionsBuilder().build());
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUserLike(ExtensionsV1beta1RunAsUserStrategyOptions item){
            return withNewRunAsUserLike(getRunAsUser() != null ? getRunAsUser(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRuntimeClass instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1RuntimeClassStrategyOptions getRuntimeClass(){
            return this.runtimeClass!=null?this.runtimeClass.build():null;
    }

    public ExtensionsV1beta1RuntimeClassStrategyOptions buildRuntimeClass(){
            return this.runtimeClass!=null?this.runtimeClass.build():null;
    }

    public A withRuntimeClass(ExtensionsV1beta1RuntimeClassStrategyOptions runtimeClass){
            _visitables.get("runtimeClass").remove(this.runtimeClass);
            if (runtimeClass!=null){ this.runtimeClass= new ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder(runtimeClass); _visitables.get("runtimeClass").add(this.runtimeClass);} return (A) this;
    }

    public Boolean hasRuntimeClass(){
            return this.runtimeClass != null;
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RuntimeClassNested<A> withNewRuntimeClass(){
            return new RuntimeClassNestedImpl();
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RuntimeClassNested<A> withNewRuntimeClassLike(ExtensionsV1beta1RuntimeClassStrategyOptions item){
            return new RuntimeClassNestedImpl(item);
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RuntimeClassNested<A> editRuntimeClass(){
            return withNewRuntimeClassLike(getRuntimeClass());
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RuntimeClassNested<A> editOrNewRuntimeClass(){
            return withNewRuntimeClassLike(getRuntimeClass() != null ? getRuntimeClass(): new ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder().build());
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RuntimeClassNested<A> editOrNewRuntimeClassLike(ExtensionsV1beta1RuntimeClassStrategyOptions item){
            return withNewRuntimeClassLike(getRuntimeClass() != null ? getRuntimeClass(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSeLinux instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1SELinuxStrategyOptions getSeLinux(){
            return this.seLinux!=null?this.seLinux.build():null;
    }

    public ExtensionsV1beta1SELinuxStrategyOptions buildSeLinux(){
            return this.seLinux!=null?this.seLinux.build():null;
    }

    public A withSeLinux(ExtensionsV1beta1SELinuxStrategyOptions seLinux){
            _visitables.get("seLinux").remove(this.seLinux);
            if (seLinux!=null){ this.seLinux= new ExtensionsV1beta1SELinuxStrategyOptionsBuilder(seLinux); _visitables.get("seLinux").add(this.seLinux);} return (A) this;
    }

    public Boolean hasSeLinux(){
            return this.seLinux != null;
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinux(){
            return new SeLinuxNestedImpl();
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinuxLike(ExtensionsV1beta1SELinuxStrategyOptions item){
            return new SeLinuxNestedImpl(item);
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> editSeLinux(){
            return withNewSeLinuxLike(getSeLinux());
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinux(){
            return withNewSeLinuxLike(getSeLinux() != null ? getSeLinux(): new ExtensionsV1beta1SELinuxStrategyOptionsBuilder().build());
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinuxLike(ExtensionsV1beta1SELinuxStrategyOptions item){
            return withNewSeLinuxLike(getSeLinux() != null ? getSeLinux(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSupplementalGroups instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1SupplementalGroupsStrategyOptions getSupplementalGroups(){
            return this.supplementalGroups!=null?this.supplementalGroups.build():null;
    }

    public ExtensionsV1beta1SupplementalGroupsStrategyOptions buildSupplementalGroups(){
            return this.supplementalGroups!=null?this.supplementalGroups.build():null;
    }

    public A withSupplementalGroups(ExtensionsV1beta1SupplementalGroupsStrategyOptions supplementalGroups){
            _visitables.get("supplementalGroups").remove(this.supplementalGroups);
            if (supplementalGroups!=null){ this.supplementalGroups= new ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder(supplementalGroups); _visitables.get("supplementalGroups").add(this.supplementalGroups);} return (A) this;
    }

    public Boolean hasSupplementalGroups(){
            return this.supplementalGroups != null;
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroups(){
            return new SupplementalGroupsNestedImpl();
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(ExtensionsV1beta1SupplementalGroupsStrategyOptions item){
            return new SupplementalGroupsNestedImpl(item);
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editSupplementalGroups(){
            return withNewSupplementalGroupsLike(getSupplementalGroups());
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups(){
            return withNewSupplementalGroupsLike(getSupplementalGroups() != null ? getSupplementalGroups(): new ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder().build());
    }

    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(ExtensionsV1beta1SupplementalGroupsStrategyOptions item){
            return withNewSupplementalGroupsLike(getSupplementalGroups() != null ? getSupplementalGroups(): item);
    }

    public A addToVolumes(int index,String item){
            if (this.volumes == null) {this.volumes = new ArrayList<String>();}
            this.volumes.add(index, item);
            return (A)this;
    }

    public A setToVolumes(int index,String item){
            if (this.volumes == null) {this.volumes = new ArrayList<String>();}
            this.volumes.set(index, item); return (A)this;
    }

    public A addToVolumes(String... items){
            if (this.volumes == null) {this.volumes = new ArrayList<String>();}
            for (String item : items) {this.volumes.add(item);} return (A)this;
    }

    public A addAllToVolumes(Collection<String> items){
            if (this.volumes == null) {this.volumes = new ArrayList<String>();}
            for (String item : items) {this.volumes.add(item);} return (A)this;
    }

    public A removeFromVolumes(String... items){
            for (String item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumes(Collection<String> items){
            for (String item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public List<String> getVolumes(){
            return this.volumes;
    }

    public String getVolume(int index){
            return this.volumes.get(index);
    }

    public String getFirstVolume(){
            return this.volumes.get(0);
    }

    public String getLastVolume(){
            return this.volumes.get(volumes.size() - 1);
    }

    public String getMatchingVolume(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: volumes) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVolume(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: volumes) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVolumes(List<String> volumes){
            if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
            if (volumes != null) {this.volumes = new ArrayList<String>(); for (String item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(String... volumes){
            if (this.volumes != null) {this.volumes.clear();}
            if (volumes != null) {for (String item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes(){
            return volumes != null && !volumes.isEmpty();
    }

    public A addNewVolume(String arg1){
            return (A)addToVolumes(new String(arg1));
    }

    public A addNewVolume(StringBuilder arg1){
            return (A)addToVolumes(new String(arg1));
    }

    public A addNewVolume(StringBuffer arg1){
            return (A)addToVolumes(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ExtensionsV1beta1PodSecurityPolicySpecFluentImpl that = (ExtensionsV1beta1PodSecurityPolicySpecFluentImpl) o;
            if (allowPrivilegeEscalation != null ? !allowPrivilegeEscalation.equals(that.allowPrivilegeEscalation) :that.allowPrivilegeEscalation != null) return false;
            if (allowedCSIDrivers != null ? !allowedCSIDrivers.equals(that.allowedCSIDrivers) :that.allowedCSIDrivers != null) return false;
            if (allowedCapabilities != null ? !allowedCapabilities.equals(that.allowedCapabilities) :that.allowedCapabilities != null) return false;
            if (allowedFlexVolumes != null ? !allowedFlexVolumes.equals(that.allowedFlexVolumes) :that.allowedFlexVolumes != null) return false;
            if (allowedHostPaths != null ? !allowedHostPaths.equals(that.allowedHostPaths) :that.allowedHostPaths != null) return false;
            if (allowedProcMountTypes != null ? !allowedProcMountTypes.equals(that.allowedProcMountTypes) :that.allowedProcMountTypes != null) return false;
            if (allowedUnsafeSysctls != null ? !allowedUnsafeSysctls.equals(that.allowedUnsafeSysctls) :that.allowedUnsafeSysctls != null) return false;
            if (defaultAddCapabilities != null ? !defaultAddCapabilities.equals(that.defaultAddCapabilities) :that.defaultAddCapabilities != null) return false;
            if (defaultAllowPrivilegeEscalation != null ? !defaultAllowPrivilegeEscalation.equals(that.defaultAllowPrivilegeEscalation) :that.defaultAllowPrivilegeEscalation != null) return false;
            if (forbiddenSysctls != null ? !forbiddenSysctls.equals(that.forbiddenSysctls) :that.forbiddenSysctls != null) return false;
            if (fsGroup != null ? !fsGroup.equals(that.fsGroup) :that.fsGroup != null) return false;
            if (hostIPC != null ? !hostIPC.equals(that.hostIPC) :that.hostIPC != null) return false;
            if (hostNetwork != null ? !hostNetwork.equals(that.hostNetwork) :that.hostNetwork != null) return false;
            if (hostPID != null ? !hostPID.equals(that.hostPID) :that.hostPID != null) return false;
            if (hostPorts != null ? !hostPorts.equals(that.hostPorts) :that.hostPorts != null) return false;
            if (privileged != null ? !privileged.equals(that.privileged) :that.privileged != null) return false;
            if (readOnlyRootFilesystem != null ? !readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) :that.readOnlyRootFilesystem != null) return false;
            if (requiredDropCapabilities != null ? !requiredDropCapabilities.equals(that.requiredDropCapabilities) :that.requiredDropCapabilities != null) return false;
            if (runAsGroup != null ? !runAsGroup.equals(that.runAsGroup) :that.runAsGroup != null) return false;
            if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
            if (runtimeClass != null ? !runtimeClass.equals(that.runtimeClass) :that.runtimeClass != null) return false;
            if (seLinux != null ? !seLinux.equals(that.seLinux) :that.seLinux != null) return false;
            if (supplementalGroups != null ? !supplementalGroups.equals(that.supplementalGroups) :that.supplementalGroups != null) return false;
            if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
            return true;
    }


    public class AllowedCSIDriversNestedImpl<N> extends ExtensionsV1beta1AllowedCSIDriverFluentImpl<ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedCSIDriversNested<N>> implements ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedCSIDriversNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1AllowedCSIDriverBuilder builder;
        private final int index;
    
            AllowedCSIDriversNestedImpl(int index,ExtensionsV1beta1AllowedCSIDriver item){
                    this.index = index;
                    this.builder = new ExtensionsV1beta1AllowedCSIDriverBuilder(this, item);
            }
            AllowedCSIDriversNestedImpl(){
                    this.index = -1;
                    this.builder = new ExtensionsV1beta1AllowedCSIDriverBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1PodSecurityPolicySpecFluentImpl.this.setToAllowedCSIDrivers(index,builder.build());
    }
    public N endAllowedCSIDriver(){
            return and();
    }

}
    public class AllowedFlexVolumesNestedImpl<N> extends ExtensionsV1beta1AllowedFlexVolumeFluentImpl<ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<N>> implements ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1AllowedFlexVolumeBuilder builder;
        private final int index;
    
            AllowedFlexVolumesNestedImpl(int index,ExtensionsV1beta1AllowedFlexVolume item){
                    this.index = index;
                    this.builder = new ExtensionsV1beta1AllowedFlexVolumeBuilder(this, item);
            }
            AllowedFlexVolumesNestedImpl(){
                    this.index = -1;
                    this.builder = new ExtensionsV1beta1AllowedFlexVolumeBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1PodSecurityPolicySpecFluentImpl.this.setToAllowedFlexVolumes(index,builder.build());
    }
    public N endAllowedFlexVolume(){
            return and();
    }

}
    public class AllowedHostPathsNestedImpl<N> extends ExtensionsV1beta1AllowedHostPathFluentImpl<ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<N>> implements ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1AllowedHostPathBuilder builder;
        private final int index;
    
            AllowedHostPathsNestedImpl(int index,ExtensionsV1beta1AllowedHostPath item){
                    this.index = index;
                    this.builder = new ExtensionsV1beta1AllowedHostPathBuilder(this, item);
            }
            AllowedHostPathsNestedImpl(){
                    this.index = -1;
                    this.builder = new ExtensionsV1beta1AllowedHostPathBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1PodSecurityPolicySpecFluentImpl.this.setToAllowedHostPaths(index,builder.build());
    }
    public N endAllowedHostPath(){
            return and();
    }

}
    public class FsGroupNestedImpl<N> extends ExtensionsV1beta1FSGroupStrategyOptionsFluentImpl<ExtensionsV1beta1PodSecurityPolicySpecFluent.FsGroupNested<N>> implements ExtensionsV1beta1PodSecurityPolicySpecFluent.FsGroupNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1FSGroupStrategyOptionsBuilder builder;
    
            FsGroupNestedImpl(ExtensionsV1beta1FSGroupStrategyOptions item){
                    this.builder = new ExtensionsV1beta1FSGroupStrategyOptionsBuilder(this, item);
            }
            FsGroupNestedImpl(){
                    this.builder = new ExtensionsV1beta1FSGroupStrategyOptionsBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1PodSecurityPolicySpecFluentImpl.this.withFsGroup(builder.build());
    }
    public N endFsGroup(){
            return and();
    }

}
    public class HostPortsNestedImpl<N> extends ExtensionsV1beta1HostPortRangeFluentImpl<ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<N>> implements ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1HostPortRangeBuilder builder;
        private final int index;
    
            HostPortsNestedImpl(int index,ExtensionsV1beta1HostPortRange item){
                    this.index = index;
                    this.builder = new ExtensionsV1beta1HostPortRangeBuilder(this, item);
            }
            HostPortsNestedImpl(){
                    this.index = -1;
                    this.builder = new ExtensionsV1beta1HostPortRangeBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1PodSecurityPolicySpecFluentImpl.this.setToHostPorts(index,builder.build());
    }
    public N endHostPort(){
            return and();
    }

}
    public class RunAsGroupNestedImpl<N> extends ExtensionsV1beta1RunAsGroupStrategyOptionsFluentImpl<ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsGroupNested<N>> implements ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsGroupNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder builder;
    
            RunAsGroupNestedImpl(ExtensionsV1beta1RunAsGroupStrategyOptions item){
                    this.builder = new ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder(this, item);
            }
            RunAsGroupNestedImpl(){
                    this.builder = new ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1PodSecurityPolicySpecFluentImpl.this.withRunAsGroup(builder.build());
    }
    public N endRunAsGroup(){
            return and();
    }

}
    public class RunAsUserNestedImpl<N> extends ExtensionsV1beta1RunAsUserStrategyOptionsFluentImpl<ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<N>> implements ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1RunAsUserStrategyOptionsBuilder builder;
    
            RunAsUserNestedImpl(ExtensionsV1beta1RunAsUserStrategyOptions item){
                    this.builder = new ExtensionsV1beta1RunAsUserStrategyOptionsBuilder(this, item);
            }
            RunAsUserNestedImpl(){
                    this.builder = new ExtensionsV1beta1RunAsUserStrategyOptionsBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1PodSecurityPolicySpecFluentImpl.this.withRunAsUser(builder.build());
    }
    public N endRunAsUser(){
            return and();
    }

}
    public class RuntimeClassNestedImpl<N> extends ExtensionsV1beta1RuntimeClassStrategyOptionsFluentImpl<ExtensionsV1beta1PodSecurityPolicySpecFluent.RuntimeClassNested<N>> implements ExtensionsV1beta1PodSecurityPolicySpecFluent.RuntimeClassNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder builder;
    
            RuntimeClassNestedImpl(ExtensionsV1beta1RuntimeClassStrategyOptions item){
                    this.builder = new ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder(this, item);
            }
            RuntimeClassNestedImpl(){
                    this.builder = new ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1PodSecurityPolicySpecFluentImpl.this.withRuntimeClass(builder.build());
    }
    public N endRuntimeClass(){
            return and();
    }

}
    public class SeLinuxNestedImpl<N> extends ExtensionsV1beta1SELinuxStrategyOptionsFluentImpl<ExtensionsV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<N>> implements ExtensionsV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1SELinuxStrategyOptionsBuilder builder;
    
            SeLinuxNestedImpl(ExtensionsV1beta1SELinuxStrategyOptions item){
                    this.builder = new ExtensionsV1beta1SELinuxStrategyOptionsBuilder(this, item);
            }
            SeLinuxNestedImpl(){
                    this.builder = new ExtensionsV1beta1SELinuxStrategyOptionsBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1PodSecurityPolicySpecFluentImpl.this.withSeLinux(builder.build());
    }
    public N endSeLinux(){
            return and();
    }

}
    public class SupplementalGroupsNestedImpl<N> extends ExtensionsV1beta1SupplementalGroupsStrategyOptionsFluentImpl<ExtensionsV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>> implements ExtensionsV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder builder;
    
            SupplementalGroupsNestedImpl(ExtensionsV1beta1SupplementalGroupsStrategyOptions item){
                    this.builder = new ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder(this, item);
            }
            SupplementalGroupsNestedImpl(){
                    this.builder = new ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1PodSecurityPolicySpecFluentImpl.this.withSupplementalGroups(builder.build());
    }
    public N endSupplementalGroups(){
            return and();
    }

}


}
