package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PolicyV1beta1SupplementalGroupsStrategyOptionsFluentImpl<A extends PolicyV1beta1SupplementalGroupsStrategyOptionsFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements PolicyV1beta1SupplementalGroupsStrategyOptionsFluent<A>{

    private List<PolicyV1beta1IDRangeBuilder> ranges;
    private String rule;

    public PolicyV1beta1SupplementalGroupsStrategyOptionsFluentImpl(){
    }
    public PolicyV1beta1SupplementalGroupsStrategyOptionsFluentImpl(PolicyV1beta1SupplementalGroupsStrategyOptions instance){
            this.withRanges(instance.getRanges());

            this.withRule(instance.getRule());

    }

    public A addToRanges(int index,PolicyV1beta1IDRange item){
            if (this.ranges == null) {this.ranges = new ArrayList<PolicyV1beta1IDRangeBuilder>();}
            PolicyV1beta1IDRangeBuilder builder = new PolicyV1beta1IDRangeBuilder(item);_visitables.get("ranges").add(index >= 0 ? index : _visitables.get("ranges").size(), builder);this.ranges.add(index >= 0 ? index : ranges.size(), builder); return (A)this;
    }

    public A setToRanges(int index,PolicyV1beta1IDRange item){
            if (this.ranges == null) {this.ranges = new ArrayList<PolicyV1beta1IDRangeBuilder>();}
            PolicyV1beta1IDRangeBuilder builder = new PolicyV1beta1IDRangeBuilder(item);
            if (index < 0 || index >= _visitables.get("ranges").size()) { _visitables.get("ranges").add(builder); } else { _visitables.get("ranges").set(index, builder);}
            if (index < 0 || index >= ranges.size()) { ranges.add(builder); } else { ranges.set(index, builder);}
             return (A)this;
    }

    public A addToRanges(PolicyV1beta1IDRange... items){
            if (this.ranges == null) {this.ranges = new ArrayList<PolicyV1beta1IDRangeBuilder>();}
            for (PolicyV1beta1IDRange item : items) {PolicyV1beta1IDRangeBuilder builder = new PolicyV1beta1IDRangeBuilder(item);_visitables.get("ranges").add(builder);this.ranges.add(builder);} return (A)this;
    }

    public A addAllToRanges(Collection<PolicyV1beta1IDRange> items){
            if (this.ranges == null) {this.ranges = new ArrayList<PolicyV1beta1IDRangeBuilder>();}
            for (PolicyV1beta1IDRange item : items) {PolicyV1beta1IDRangeBuilder builder = new PolicyV1beta1IDRangeBuilder(item);_visitables.get("ranges").add(builder);this.ranges.add(builder);} return (A)this;
    }

    public A removeFromRanges(PolicyV1beta1IDRange... items){
            for (PolicyV1beta1IDRange item : items) {PolicyV1beta1IDRangeBuilder builder = new PolicyV1beta1IDRangeBuilder(item);_visitables.get("ranges").remove(builder);if (this.ranges != null) {this.ranges.remove(builder);}} return (A)this;
    }

    public A removeAllFromRanges(Collection<PolicyV1beta1IDRange> items){
            for (PolicyV1beta1IDRange item : items) {PolicyV1beta1IDRangeBuilder builder = new PolicyV1beta1IDRangeBuilder(item);_visitables.get("ranges").remove(builder);if (this.ranges != null) {this.ranges.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRanges(io.kubernetes.client.fluent.Predicate<PolicyV1beta1IDRangeBuilder> predicate){
            if (ranges == null) return (A) this;
            final Iterator<PolicyV1beta1IDRangeBuilder> each = ranges.iterator();
            final List visitables = _visitables.get("ranges");
            while (each.hasNext()) {
              PolicyV1beta1IDRangeBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRanges instead.
 * @return The buildable object.
 */
@Deprecated public List<PolicyV1beta1IDRange> getRanges(){
            return build(ranges);
    }

    public List<PolicyV1beta1IDRange> buildRanges(){
            return build(ranges);
    }

    public PolicyV1beta1IDRange buildRange(int index){
            return this.ranges.get(index).build();
    }

    public PolicyV1beta1IDRange buildFirstRange(){
            return this.ranges.get(0).build();
    }

    public PolicyV1beta1IDRange buildLastRange(){
            return this.ranges.get(ranges.size() - 1).build();
    }

    public PolicyV1beta1IDRange buildMatchingRange(io.kubernetes.client.fluent.Predicate<PolicyV1beta1IDRangeBuilder> predicate){
            for (PolicyV1beta1IDRangeBuilder item: ranges) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRange(io.kubernetes.client.fluent.Predicate<PolicyV1beta1IDRangeBuilder> predicate){
            for (PolicyV1beta1IDRangeBuilder item: ranges) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRanges(List<PolicyV1beta1IDRange> ranges){
            if (this.ranges != null) { _visitables.get("ranges").removeAll(this.ranges);}
            if (ranges != null) {this.ranges = new ArrayList<PolicyV1beta1IDRangeBuilder>(); for (PolicyV1beta1IDRange item : ranges){this.addToRanges(item);}} else { this.ranges = null;} return (A) this;
    }

    public A withRanges(PolicyV1beta1IDRange... ranges){
            if (this.ranges != null) {this.ranges.clear();}
            if (ranges != null) {for (PolicyV1beta1IDRange item :ranges){ this.addToRanges(item);}} return (A) this;
    }

    public Boolean hasRanges(){
            return ranges != null && !ranges.isEmpty();
    }

    public PolicyV1beta1SupplementalGroupsStrategyOptionsFluent.RangesNested<A> addNewRange(){
            return new RangesNestedImpl();
    }

    public PolicyV1beta1SupplementalGroupsStrategyOptionsFluent.RangesNested<A> addNewRangeLike(PolicyV1beta1IDRange item){
            return new RangesNestedImpl(-1, item);
    }

    public PolicyV1beta1SupplementalGroupsStrategyOptionsFluent.RangesNested<A> setNewRangeLike(int index,PolicyV1beta1IDRange item){
            return new RangesNestedImpl(index, item);
    }

    public PolicyV1beta1SupplementalGroupsStrategyOptionsFluent.RangesNested<A> editRange(int index){
            if (ranges.size() <= index) throw new RuntimeException("Can't edit ranges. Index exceeds size.");
            return setNewRangeLike(index, buildRange(index));
    }

    public PolicyV1beta1SupplementalGroupsStrategyOptionsFluent.RangesNested<A> editFirstRange(){
            if (ranges.size() == 0) throw new RuntimeException("Can't edit first ranges. The list is empty.");
            return setNewRangeLike(0, buildRange(0));
    }

    public PolicyV1beta1SupplementalGroupsStrategyOptionsFluent.RangesNested<A> editLastRange(){
            int index = ranges.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ranges. The list is empty.");
            return setNewRangeLike(index, buildRange(index));
    }

    public PolicyV1beta1SupplementalGroupsStrategyOptionsFluent.RangesNested<A> editMatchingRange(io.kubernetes.client.fluent.Predicate<PolicyV1beta1IDRangeBuilder> predicate){
            int index = -1;
            for (int i=0;i<ranges.size();i++) { 
            if (predicate.apply(ranges.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ranges. No match found.");
            return setNewRangeLike(index, buildRange(index));
    }

    public String getRule(){
            return this.rule;
    }

    public A withRule(String rule){
            this.rule=rule; return (A) this;
    }

    public Boolean hasRule(){
            return this.rule != null;
    }

    public A withNewRule(String arg1){
            return (A)withRule(new String(arg1));
    }

    public A withNewRule(StringBuilder arg1){
            return (A)withRule(new String(arg1));
    }

    public A withNewRule(StringBuffer arg1){
            return (A)withRule(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PolicyV1beta1SupplementalGroupsStrategyOptionsFluentImpl that = (PolicyV1beta1SupplementalGroupsStrategyOptionsFluentImpl) o;
            if (ranges != null ? !ranges.equals(that.ranges) :that.ranges != null) return false;
            if (rule != null ? !rule.equals(that.rule) :that.rule != null) return false;
            return true;
    }


    public class RangesNestedImpl<N> extends PolicyV1beta1IDRangeFluentImpl<PolicyV1beta1SupplementalGroupsStrategyOptionsFluent.RangesNested<N>> implements PolicyV1beta1SupplementalGroupsStrategyOptionsFluent.RangesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final PolicyV1beta1IDRangeBuilder builder;
        private final int index;
    
            RangesNestedImpl(int index,PolicyV1beta1IDRange item){
                    this.index = index;
                    this.builder = new PolicyV1beta1IDRangeBuilder(this, item);
            }
            RangesNestedImpl(){
                    this.index = -1;
                    this.builder = new PolicyV1beta1IDRangeBuilder(this);
            }
    
    public N and(){
            return (N) PolicyV1beta1SupplementalGroupsStrategyOptionsFluentImpl.this.setToRanges(index,builder.build());
    }
    public N endRange(){
            return and();
    }

}


}
