package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1NetworkPolicyPortBuilder extends V1NetworkPolicyPortFluentImpl<V1NetworkPolicyPortBuilder> implements VisitableBuilder<V1NetworkPolicyPort,V1NetworkPolicyPortBuilder>{

    V1NetworkPolicyPortFluent<?> fluent;
    Boolean validationEnabled;

    public V1NetworkPolicyPortBuilder(){
            this(true);
    }
    public V1NetworkPolicyPortBuilder(Boolean validationEnabled){
            this(new V1NetworkPolicyPort(), validationEnabled);
    }
    public V1NetworkPolicyPortBuilder(V1NetworkPolicyPortFluent<?> fluent){
            this(fluent, true);
    }
    public V1NetworkPolicyPortBuilder(V1NetworkPolicyPortFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1NetworkPolicyPort(), validationEnabled);
    }
    public V1NetworkPolicyPortBuilder(V1NetworkPolicyPortFluent<?> fluent,V1NetworkPolicyPort instance){
            this(fluent, instance, true);
    }
    public V1NetworkPolicyPortBuilder(V1NetworkPolicyPortFluent<?> fluent,V1NetworkPolicyPort instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPort(instance.getPort());

            fluent.withProtocol(instance.getProtocol());

            this.validationEnabled = validationEnabled; 
    }
    public V1NetworkPolicyPortBuilder(V1NetworkPolicyPort instance){
            this(instance,true);
    }
    public V1NetworkPolicyPortBuilder(V1NetworkPolicyPort instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPort(instance.getPort());

            this.withProtocol(instance.getProtocol());

            this.validationEnabled = validationEnabled; 
    }

    public V1NetworkPolicyPort build(){
            V1NetworkPolicyPort buildable = new V1NetworkPolicyPort();
            buildable.setPort(fluent.getPort());
            buildable.setProtocol(fluent.getProtocol());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NetworkPolicyPortBuilder that = (V1NetworkPolicyPortBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
