package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1NodeDaemonEndpointsBuilder extends V1NodeDaemonEndpointsFluentImpl<V1NodeDaemonEndpointsBuilder> implements VisitableBuilder<V1NodeDaemonEndpoints,V1NodeDaemonEndpointsBuilder>{

    V1NodeDaemonEndpointsFluent<?> fluent;
    Boolean validationEnabled;

    public V1NodeDaemonEndpointsBuilder(){
            this(true);
    }
    public V1NodeDaemonEndpointsBuilder(Boolean validationEnabled){
            this(new V1NodeDaemonEndpoints(), validationEnabled);
    }
    public V1NodeDaemonEndpointsBuilder(V1NodeDaemonEndpointsFluent<?> fluent){
            this(fluent, true);
    }
    public V1NodeDaemonEndpointsBuilder(V1NodeDaemonEndpointsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1NodeDaemonEndpoints(), validationEnabled);
    }
    public V1NodeDaemonEndpointsBuilder(V1NodeDaemonEndpointsFluent<?> fluent,V1NodeDaemonEndpoints instance){
            this(fluent, instance, true);
    }
    public V1NodeDaemonEndpointsBuilder(V1NodeDaemonEndpointsFluent<?> fluent,V1NodeDaemonEndpoints instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withKubeletEndpoint(instance.getKubeletEndpoint());

            this.validationEnabled = validationEnabled; 
    }
    public V1NodeDaemonEndpointsBuilder(V1NodeDaemonEndpoints instance){
            this(instance,true);
    }
    public V1NodeDaemonEndpointsBuilder(V1NodeDaemonEndpoints instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withKubeletEndpoint(instance.getKubeletEndpoint());

            this.validationEnabled = validationEnabled; 
    }

    public V1NodeDaemonEndpoints build(){
            V1NodeDaemonEndpoints buildable = new V1NodeDaemonEndpoints();
            buildable.setKubeletEndpoint(fluent.getKubeletEndpoint());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NodeDaemonEndpointsBuilder that = (V1NodeDaemonEndpointsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
